/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.menu.MagiaDrawerMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.util.ItemHelper;

public class TileMagiaDrawer
extends TileSMMagic {
    public int maxMagiaFlux = 100000;
    public int range = 4;
    private static final int MIN_RANGE = 1;
    private static final int MAX_RANGE = 64;
    public final TileAbstractSM.StackHandler inputInv = new TileAbstractSM.StackHandler(this.getInvSize());

    public TileMagiaDrawer(BlockPos pos, BlockState state) {
        this(TileInit.magiarDrawer, pos, state);
    }

    public TileMagiaDrawer(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.SingleHandlerProvider((IItemHandlerModifiable)this.inputInv, IN_OUT);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.tickTime % 30 != 0 || this.isRSPower()) {
            return;
        }
        this.tickTime = 0;
        if (this.getMF() >= 4) {
            this.suctionItem(world, pos);
        }
    }

    public void suctionItem(Level world, BlockPos pos) {
        List<ItemEntity> entityList = this.getEntityList(ItemEntity.class, e -> !e.m_32055_().m_41619_(), this.range);
        if (entityList.isEmpty()) {
            return;
        }
        int isInsert = 0;
        int mf = this.getMF();
        HashSet<ItemPos> posList = new HashSet<ItemPos>();
        for (ItemEntity entity : entityList) {
            ItemStack stack = entity.m_32055_();
            ItemStack insert = ItemHelper.insertStack(this.getInput(), stack.m_41777_(), false);
            if (insert.m_41619_() || insert.m_41613_() <= 0) {
                ItemPos.create(posList, (Entity)entity);
                entity.m_146870_();
                isInsert += stack.m_41613_();
            }
            if (isInsert < mf) continue;
            break;
        }
        if (isInsert > 0) {
            this.setMF(mf - isInsert);
            this.sendPKT();
        }
        if (world instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)world;
            this.renderMFFlow(server, pos, posList);
        }
    }

    public void renderMFFlow(ServerLevel world, BlockPos basePos, Set<ItemPos> posList) {
        float speed = 0.0265f;
        SimpleParticleType par = ParticleInit.MF;
        for (ItemPos pos : posList) {
            for (int i = 0; i < 8; ++i) {
                float x = (float)pos.x + this.getRandFloat(0.25f);
                float y = (float)pos.y + this.getRandFloat(0.25f);
                float z = (float)pos.z + this.getRandFloat(0.25f);
                float xSpeed = ((float)basePos.m_123341_() + 0.5f - x) * speed;
                float ySpeed = ((float)basePos.m_123342_() + 0.5f - y) * speed;
                float zSpeed = ((float)basePos.m_123343_() + 0.5f - z) * speed;
                world.m_8767_((ParticleOptions)par, (double)x, (double)y, (double)z, 0, (double)xSpeed, (double)ySpeed, (double)zSpeed, 1.0);
            }
        }
    }

    public void addRange(int id) {
        int addValue = 0;
        switch (id) {
            case 0: {
                addValue = 1;
                break;
            }
            case 1: {
                addValue = 10;
                break;
            }
            case 2: {
                addValue = -1;
                break;
            }
            case 3: {
                addValue = -10;
            }
        }
        this.range = Math.min(64, Math.max(1, this.range + addValue));
        this.clickButton();
        this.sendPKT();
    }

    @Override
    public int getInvSize() {
        return 104;
    }

    @Override
    public int getReceiveMF() {
        return 10000;
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem(int i) {
        return this.getInput().getStackInSlot(i);
    }

    public boolean isInvEmpty() {
        for (int i = 0; i < this.getInvSize(); ++i) {
            if (this.getInputItem(i).m_41619_()) continue;
            return false;
        }
        return this.isMFEmpty();
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
        tag.m_128405_("range", this.range);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputInv.deserializeNBT(tag.m_128469_("inputInv"));
        this.range = tag.m_128451_("range");
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new MagiaDrawerMenu(windowId, inv, this);
    }

    @Override
    public boolean isRSStop() {
        return true;
    }

    public List<ItemStack> getInputList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getInvSize(); ++i) {
            stackList.add(this.getInputItem(i));
        }
        return stackList;
    }

    public List<ItemStack> getInvList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getInputItem(i));
        }
        return stackList;
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getInvList().isEmpty() && this.isMFEmpty();
    }

    public record ItemPos(double x, double y, double z) {
        public static void create(Set<ItemPos> posList, Entity entity) {
            posList.add(new ItemPos(entity.f_19854_, entity.f_19855_, entity.f_19856_));
        }
    }
}

