/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.menu.MagiaLanternMenu;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.util.WorldHelper;

public class TileMagiaLantern
extends TileSMMagic {
    private int range = 128;
    public int maxMagiaFlux = 100000;
    private static final int MIN_RANGE = 1;
    private static final int MAX_RANGE = 1024;

    public TileMagiaLantern(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TileMagiaLantern(BlockPos pos, BlockState state) {
        super(TileInit.magiaLantern, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.tickTime % 20 != 0 || this.isRSPower() || this.getMF() < this.getShrinkMF() || WorldHelper.isPeace((LevelAccessor)world)) {
            return;
        }
        this.setMF(this.getMF() - this.getShrinkMF());
        this.sendInfo();
    }

    @Override
    public int getShrinkMF() {
        return this.getRange() / 4;
    }

    public int getRange() {
        return this.range;
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public int getReceiveMF() {
        return 10000;
    }

    @Override
    public IItemHandler getInput() {
        return null;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("range", this.range);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.range = tag.m_128451_("range");
    }

    public void addRange(int id) {
        int addValue = 0;
        switch (id) {
            case 0: {
                addValue = -1;
                break;
            }
            case 1: {
                addValue = -10;
                break;
            }
            case 2: {
                addValue = -64;
                break;
            }
            case 3: {
                addValue = 1;
                break;
            }
            case 4: {
                addValue = 10;
                break;
            }
            case 5: {
                addValue = 64;
            }
        }
        this.range = Math.min(1024, Math.max(1, this.range + addValue));
        this.clickButton();
        this.sendPKT();
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new MagiaLanternMenu(windowId, inv, this);
    }
}

