/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.sm.MagiaStorage;
import sweetmagic.init.tile.menu.MagiaStorageMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;

public class TileMagiaStorage
extends TileAbstractSM {
    private Block block = null;
    public final TileAbstractSM.MagiaHandler inputInv = new TileAbstractSM.MagiaHandler(this.getInvSize());

    public TileMagiaStorage(BlockPos pos, BlockState state) {
        this(TileInit.magiaStorage, pos, state);
    }

    public TileMagiaStorage(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.SingleHandlerProvider((IItemHandlerModifiable)this.inputInv, IN_OUT);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputInv.deserializeNBT(tag.m_128469_("inputInv"));
    }

    @Override
    public int getInvSize() {
        return 104;
    }

    public Block getBlock() {
        if (this.block == null) {
            this.block = this.getBlock(this.m_58899_());
        }
        return this.block;
    }

    @Override
    public int getMaxStackSize() {
        switch (this.getData()) {
            case 1: {
                return 1280;
            }
            case 2: {
                return 5120;
            }
            case 3: {
                return 25600;
            }
            case 4: {
                return Integer.MAX_VALUE;
            }
        }
        return 256;
    }

    public TileAbstractSM.MagiaHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem(int i) {
        return this.getInput().getStackInSlot(i);
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new MagiaStorageMenu(windowId, inv, this);
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getInputList().isEmpty();
    }

    public List<ItemStack> getInputList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getInputItem(i));
        }
        return stackList;
    }

    public List<ItemStack> getInvList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getInvSize(); ++i) {
            stackList.add(this.getInputItem(i));
        }
        return stackList;
    }

    public int getData() {
        return ((MagiaStorage)this.getBlock(this.m_58899_())).getData();
    }
}

