/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.init.SoundInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileAbstractSMCook;
import sweetmagic.recipe.mill.MillRecipe;
import sweetmagic.util.ItemHelper;

public class TileMill
extends TileAbstractSMCook {
    private static final int MAX_CRAFT_TIME = 4;
    public int craftTime = 0;
    public int amount = 0;
    public boolean isCraft = false;
    public List<Float> chanceList = new ArrayList<Float>();
    public List<ItemStack> craftList = new ArrayList<ItemStack>();
    public List<ItemStack> resultList = new ArrayList<ItemStack>();
    protected final TileAbstractSM.StackHandler handInv = new TileAbstractSM.StackHandler(1);
    protected final TileAbstractSM.MagiaHandler outputInv = new TileAbstractSM.MagiaHandler(this.getInvSize());

    public TileMill(BlockPos pos, BlockState state) {
        this(TileInit.mill, pos, state);
    }

    public TileMill(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.InOutHandlerProvider((IItemHandlerModifiable)this.handInv, (IItemHandlerModifiable)this.outputInv);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.tickTime % 20 != 0) {
            return;
        }
        this.tickTime = 0;
        if (this.isCook()) {
            this.addCookTime();
            if (this.isFinishCook()) {
                this.craftFinish();
            } else {
                this.playSound(pos, SoundInit.MACHIN, 0.0625f, 1.0f);
            }
            this.sendPKT();
        } else if (this.isOutputEmpty() && this.getCookData() == 2) {
            this.setState(0);
            this.outPutClear();
        }
        if (this.isCook() || this.getHandItem().m_41619_() || !this.isOutputEmpty()) {
            return;
        }
        if (this.checkRecipe()) {
            this.craftStart();
        } else {
            ItemStack hand = this.getHandItem();
            ItemHelper.insertStack(this.getOutput(), hand.m_41777_(), false);
            hand.m_41774_(hand.m_41613_());
            this.setState(2);
        }
    }

    public List<ItemStack> getStackList() {
        return Arrays.asList(this.getHandItem());
    }

    @Override
    public List<ItemStack> getDropList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        this.addStackList(stackList, this.getHandItem());
        for (int i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getOutputItem(i));
        }
        if (!this.craftList.isEmpty()) {
            ItemStack stack = this.craftList.get(0);
            stack.m_41764_(this.amount);
            this.addStackList(stackList, stack);
        }
        return stackList;
    }

    @Override
    public boolean checkRecipe() {
        return !MillRecipe.getRecipe(this.m_58904_(), this.getStackList()).isEmpty();
    }

    @Override
    public void craftStart() {
        List<ItemStack> stackList = this.getStackList();
        MillRecipe recipe = MillRecipe.getRecipe(this.m_58904_(), stackList).get();
        List<ItemStack> requestList = recipe.getRequestList();
        ItemStack hasndStack = stackList.get(0);
        int amount = hasndStack.m_41613_() / requestList.get(0).m_41613_();
        this.craftList = new ArrayList<ItemStack>(requestList);
        List<ItemStack> resultList = recipe.getResultList();
        resultList = new ArrayList<ItemStack>(resultList);
        for (ItemStack request : recipe.getRequestList()) {
            if (!request.m_150930_(hasndStack.m_41720_())) continue;
            hasndStack.m_41774_(request.m_41613_() * amount);
            break;
        }
        this.amount = amount;
        this.isCraft = true;
        this.chanceList = new ArrayList<Float>(recipe.getChanceList());
        this.resultList = recipe.getResultList();
        this.tickTime = 0;
        this.setState(1);
        this.playSound(this.m_58899_(), SoundInit.MACHIN, 0.0625f, 1.0f);
        this.sendPKT();
    }

    @Override
    public void craftFinish() {
        for (int i = 0; i < this.resultList.size(); ++i) {
            float chance = this.chanceList.isEmpty() ? 0.0f : this.chanceList.get(i).floatValue();
            for (int k = 0; k < this.amount; ++k) {
                if (i != 0 && !(chance >= this.rand.nextFloat())) continue;
                ItemHelper.insertStack(this.getOutput(), this.resultList.get(i).m_41777_(), false);
            }
        }
        this.clearInfo();
        this.setState(2);
        this.playSound(this.m_58899_(), SoundInit.DROP, 0.0625f, 1.0f);
        this.sendPKT();
    }

    @Override
    public void clearInfo() {
        this.amount = 0;
        this.craftTime = 0;
        this.isCraft = false;
        this.chanceList.clear();
        this.craftList.clear();
        this.resultList.clear();
        this.sendPKT();
    }

    public boolean isOutputEmpty() {
        for (int i = 0; i < this.getInvSize(); ++i) {
            if (this.getOutputItem(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public List<ItemStack> getOutPutList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getOutputItem(i));
        }
        return stackList;
    }

    public void outPutClear() {
        this.getOutPutList().forEach(s -> s.m_41774_(s.m_41613_()));
    }

    @Override
    public int getMaxCookTime() {
        return 4;
    }

    @Override
    public int getCookTime() {
        return this.craftTime;
    }

    @Override
    public void setCookTime(int cookTime) {
        this.craftTime = cookTime;
    }

    @Override
    public boolean isCook() {
        return this.isCraft;
    }

    @Override
    public List<ItemStack> getCraftList() {
        return this.craftList;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("handInv", (Tag)this.handInv.serializeNBT());
        tag.m_128365_("outputInv", (Tag)this.outputInv.serializeNBT());
        tag.m_128379_("isCraft", this.isCraft);
        tag.m_128405_("craftTime", this.craftTime);
        tag.m_128405_("amount", this.amount);
        this.saveFloatList(tag, this.chanceList, "chanceList");
        this.saveStackList(tag, this.craftList, "craftList");
        this.saveStackList(tag, this.resultList, "resultList");
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.handInv.deserializeNBT(tag.m_128469_("handInv"));
        this.outputInv.deserializeNBT(tag.m_128469_("outputInv"));
        this.isCraft = tag.m_128471_("isCraft");
        this.craftTime = tag.m_128451_("craftTime");
        this.amount = tag.m_128451_("amount");
        this.chanceList = this.loadAllFloat(tag, "chanceList");
        this.craftList = this.loadAllStack(tag, "craftList");
        this.resultList = this.loadAllStack(tag, "resultList");
    }

    @Override
    public int getInvSize() {
        return 4;
    }

    @Override
    public int getMaxStackSize() {
        return Integer.MAX_VALUE;
    }

    public IItemHandler getHand() {
        return this.handInv;
    }

    public ItemStack getHandItem() {
        return this.getHand().getStackInSlot(0);
    }

    public IItemHandler getOutput() {
        return this.outputInv;
    }

    public ItemStack getOutputItem(int i) {
        return this.getOutput().getStackInSlot(i);
    }
}

