/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import sweetmagic.api.SweetMagicAPI;
import sweetmagic.api.iitem.IAcce;
import sweetmagic.api.iitem.IFood;
import sweetmagic.api.iitem.IMagicItem;
import sweetmagic.api.iitem.ITier;
import sweetmagic.api.iitem.info.AcceInfo;
import sweetmagic.handler.PacketHandler;
import sweetmagic.init.ItemInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.TagInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.capability.icap.ICookingStatus;
import sweetmagic.init.item.blockitem.SMSeed;
import sweetmagic.init.item.sm.SMFood;
import sweetmagic.init.tile.menu.NotePCMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.packet.NoteBuyPKT;
import sweetmagic.recipe.trade.TradeRecipe;
import sweetmagic.util.ItemHelper;

public class TileNotePC
extends TileAbstractSM {
    public long randDate = -1L;
    private long nextTime = 0L;
    private long seed = 0L;
    private float rate = 0.0f;
    private Random dateRand = null;
    public UUID ownerUUID;
    private Player player;
    public final TileAbstractSM.StackHandler inputInv = new TileAbstractSM.StackHandler(1);
    public final TileAbstractSM.StackHandler outInv = new TileAbstractSM.StackHandler(this.getInvSize());
    public List<ItemStack> stackList = new ArrayList<ItemStack>();
    public List<Integer> intList = new ArrayList<Integer>();
    public int buyCount = 1;
    private int viewCount = 10;
    private static final String FURNITURE = "furniture";
    private static final String MAGIC = "magic";
    private static final String SEASONING = "seasoning";
    private static final String SEED = "seed";
    private static final String VANILLA = "vanilla";

    public TileNotePC(BlockPos pos, BlockState state) {
        super(TileInit.notePC, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.InOutHandlerProvider((IItemHandlerModifiable)this.inputInv, (IItemHandlerModifiable)this.outInv);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.tickTime % 20 != 0) {
            return;
        }
        if (!this.stackList.isEmpty()) {
            ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
            for (ItemStack stack : this.stackList) {
                if (stack.m_41619_()) continue;
                ItemStack out = ItemHelper.insertStack(this.getOut(), stack.m_41777_(), false);
                this.addStackList(stackList, out);
            }
            this.stackList.clear();
            if (!stackList.isEmpty()) {
                this.stackList = stackList;
            }
        }
        this.clearInfo();
        this.setNextTime();
        Player player = this.getOwner();
        if (player == null || !this.isRSPower()) {
            return;
        }
        this.addButSale(player);
    }

    public List<List<TradeInfo>> getTrade(Player player) {
        boolean isUpdate;
        ArrayList<List<TradeInfo>> list = new ArrayList<List<TradeInfo>>();
        ICookingStatus cook = this.getCook(player);
        boolean bl = isUpdate = (cook.getRandDate() != this.randDate || cook.getSeedList().isEmpty()) && !this.m_58904_().m_5776_();
        if (isUpdate) {
            cook.setRandDate(this.randDate);
        }
        List<TradeRecipe> tradeList = this.getTradeList();
        this.dateRand = new Random(this.seed + this.randDate);
        cook.setRate(this.getRate());
        this.viewCount = 10 + cook.getTradeLevel() * 2;
        this.intList = Arrays.asList(0, 1, 2, 3, 4, 5);
        Collections.shuffle(this.intList, this.dateRand);
        list.add(this.getSeedList(cook, isUpdate, this.filterTradeList(tradeList, SEED)));
        list.add(this.getMagicList(cook, isUpdate, this.filterTradeList(tradeList, MAGIC)));
        list.add(this.getFurnitureList(cook, isUpdate, this.filterTradeList(tradeList, FURNITURE)));
        list.add(this.getEnchantList(cook, isUpdate));
        list.add(this.getVanillaList(cook, isUpdate, this.filterTradeList(tradeList, VANILLA)));
        list.add(this.getSeasoningList(cook, isUpdate, this.filterTradeList(tradeList, SEASONING)));
        List intFixList = new ArrayList<Integer>();
        ArrayList<List<TradeInfo>> tradeInfoList = new ArrayList<List<TradeInfo>>();
        int tradeLevel = this.getCook(player).getTradeLevel() + 1;
        for (int i2 = 0; i2 < tradeLevel; ++i2) {
            intFixList.add(this.intList.get(i2));
        }
        intFixList = intFixList.stream().sorted((s1, s2) -> ItemHelper.sortInt(s1, s2)).toList();
        intFixList.forEach(i -> tradeInfoList.add((List)list.get((int)i)));
        this.intList = intFixList;
        return tradeInfoList;
    }

    public Player getOwner() {
        ServerLevel server;
        Level level;
        if (this.player != null) {
            return this.player;
        }
        if (this.ownerUUID != null && (level = this.m_58904_()) instanceof ServerLevel && (level = (server = (ServerLevel)level).m_8791_(this.ownerUUID)) instanceof Player) {
            Player player;
            this.player = player = (Player)level;
            return player;
        }
        return null;
    }

    public void setOwner(Player player) {
        this.player = player;
        this.ownerUUID = player.m_20148_();
    }

    public void clearInfo() {
        if (this.dateRand != null && this.randDate == this.getDate()) {
            return;
        }
        if (this.player == null) {
            return;
        }
        this.randDate = this.getDate();
        this.seed = this.seed != 0L ? this.seed : this.m_58904_().m_7654_().m_129880_(Level.f_46428_).m_7328_();
        this.sendInfo();
    }

    public long getDate() {
        ServerLevel sever = this.m_58904_().m_7654_().m_129880_(Level.f_46428_);
        int dayTime = 24000;
        return sever.m_46468_() / (long)dayTime;
    }

    public Random getRand(ICookingStatus cook) {
        ServerLevel sever = this.m_58904_().m_7654_().m_129880_(Level.f_46428_);
        cook.setLongRand(sever.m_7328_() + this.randDate);
        return new Random(cook.getLongRand());
    }

    public float getRate() {
        this.dateRand.nextFloat();
        return 0.75f + this.dateRand.nextFloat() * 0.75f;
    }

    public List<TradeInfo> getSeedList(ICookingStatus cook, boolean isUpdate, List<TradeRecipe> tradeList) {
        if (!isUpdate) {
            return cook.getSeedList();
        }
        List<TradeInfo> list = this.setSeedList(tradeList);
        cook.setSeedList(list);
        return list;
    }

    public List<TradeInfo> setSeedList(List<TradeRecipe> tradeList) {
        ArrayList<TradeInfo> list = new ArrayList<TradeInfo>();
        for (TradeRecipe trade : tradeList) {
            List<Ingredient> ingList = trade.getIngredList();
            for (int i = 0; i < ingList.size(); ++i) {
                int count = trade.getCountList().get(i);
                int value = trade.getValueList().get(i);
                Ingredient ing = ingList.get(i);
                ArrayList<ItemStack> stackList = new ArrayList<ItemStack>(Arrays.asList(ing.m_43908_()));
                for (ItemStack stack : stackList) {
                    ITier ti;
                    Item item = stack.m_41720_();
                    if (item instanceof ITier && (ti = (ITier)item).getTier() > 0) {
                        list.add(TradeInfo.create(item, count, 1000 + value + 500 * ti.getTier() * ti.getTier(), this.dateRand));
                        continue;
                    }
                    list.add(TradeInfo.create(item, count, value, this.dateRand));
                }
            }
        }
        return this.getTradeList(list);
    }

    public List<TradeInfo> getMagicList(ICookingStatus cook, boolean isUpdate, List<TradeRecipe> tradeList) {
        if (!isUpdate) {
            return cook.getMagicList();
        }
        List<TradeInfo> list = this.setMagicList(tradeList);
        cook.setMagicList(list);
        return list;
    }

    public List<TradeInfo> setMagicList(List<TradeRecipe> tradeList) {
        ArrayList<TradeInfo> list = new ArrayList<TradeInfo>();
        for (TradeRecipe trade : tradeList) {
            List<Ingredient> ingList = trade.getIngredList();
            for (int i = 0; i < ingList.size(); ++i) {
                int count = trade.getCountList().get(i);
                int value = trade.getValueList().get(i);
                Ingredient ing = ingList.get(i);
                ArrayList<ItemStack> stackList = new ArrayList<ItemStack>(Arrays.asList(ing.m_43908_()));
                stackList.forEach(s -> list.add(TradeInfo.create(s.m_41720_(), count, value, 1.5f, this.dateRand)));
            }
        }
        return this.getTradeList(list);
    }

    public List<TradeInfo> getFurnitureList(ICookingStatus cook, boolean isUpdate, List<TradeRecipe> tradeList) {
        if (!isUpdate) {
            return cook.getFurnitureList();
        }
        List<TradeInfo> list = this.setFurnitureList(tradeList);
        cook.setFurnitureList(list);
        return list;
    }

    public List<TradeInfo> setFurnitureList(List<TradeRecipe> tradeList) {
        ArrayList<TradeInfo> list = new ArrayList<TradeInfo>();
        for (TradeRecipe trade : tradeList) {
            List<Ingredient> ingList = trade.getIngredList();
            for (int i = 0; i < ingList.size(); ++i) {
                int count = trade.getCountList().get(i);
                int value = trade.getValueList().get(i);
                Ingredient ing = ingList.get(i);
                ArrayList<ItemStack> stackList = new ArrayList<ItemStack>(Arrays.asList(ing.m_43908_()));
                stackList.forEach(s -> list.add(TradeInfo.create(s.m_41720_(), count, value, this.dateRand)));
            }
        }
        return this.getTradeList(list);
    }

    public List<TradeInfo> getEnchantList(ICookingStatus cook, boolean isUpdate) {
        if (!isUpdate) {
            return cook.getEnchantList();
        }
        List<TradeInfo> list = this.setEnchantList();
        cook.setEnchantList(list);
        return list;
    }

    public List<TradeInfo> setEnchantList() {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42690_);
        ArrayList<TradeInfo> seedList = new ArrayList<TradeInfo>();
        List allEncha = Registry.f_122825_.m_123024_().toList();
        for (int i = 0; i < this.getViewCount(); ++i) {
            int cost = 0;
            ItemStack copy = stack.m_41777_();
            ArrayList<Enchantment> enchaList = new ArrayList<Enchantment>();
            ArrayList<EnchantmentInstance> enchaInsList = new ArrayList<EnchantmentInstance>();
            for (int k = 0; k < this.dateRand.nextInt(3) + 1; ++k) {
                Enchantment encha = (Enchantment)allEncha.get(this.dateRand.nextInt(allEncha.size()));
                if (enchaList.contains(encha)) continue;
                int level = Math.min(encha.m_6586_(), this.dateRand.nextInt(encha.m_6586_() + 1) + 1);
                cost += (11 - encha.m_44699_().m_44716_()) * level * 200;
                if (encha.m_6586_() == 1) {
                    cost += (11 - encha.m_44699_().m_44716_()) * (encha.m_6589_() ? -100 : 3000);
                }
                enchaList.add(encha);
                enchaInsList.add(new EnchantmentInstance(encha, level));
            }
            ListTag listtag = new ListTag();
            enchaInsList.forEach(e -> listtag.add((Object)EnchantmentHelper.m_182443_((ResourceLocation)EnchantmentHelper.m_182432_((Enchantment)e.f_44947_), (int)e.f_44948_)));
            copy.m_41784_().m_128365_("StoredEnchantments", (Tag)listtag);
            seedList.add(new TradeInfo(copy, cost + this.dateRand.nextInt(Math.max(1, cost / 4))));
        }
        return seedList;
    }

    public List<TradeInfo> getVanillaList(ICookingStatus cook, boolean isUpdate, List<TradeRecipe> tradeList) {
        if (!isUpdate) {
            return cook.getVanillaList();
        }
        List<TradeInfo> list = this.setVanillaList(tradeList);
        cook.setVanillaList(list);
        return list;
    }

    public List<TradeInfo> setVanillaList(List<TradeRecipe> tradeList) {
        ArrayList<TradeInfo> list = new ArrayList<TradeInfo>();
        for (TradeRecipe trade : tradeList) {
            List<Ingredient> ingList = trade.getIngredList();
            for (int i = 0; i < ingList.size(); ++i) {
                int count = trade.getCountList().get(i);
                int value = trade.getValueList().get(i);
                Ingredient ing = ingList.get(i);
                ArrayList<ItemStack> stackList = new ArrayList<ItemStack>(Arrays.asList(ing.m_43908_()));
                stackList.forEach(s -> list.add(TradeInfo.create(s.m_41720_(), count, value, 1.0f, this.dateRand)));
            }
        }
        return this.getTradeList(list);
    }

    public List<TradeInfo> getSeasoningList(ICookingStatus cook, boolean isUpdate, List<TradeRecipe> tradeList) {
        if (!isUpdate) {
            return cook.getSeasoningList();
        }
        List<TradeInfo> list = this.setSeasoningList(tradeList);
        cook.setSeasoningList(list);
        return list;
    }

    public List<TradeInfo> setSeasoningList(List<TradeRecipe> tradeList) {
        ArrayList<TradeInfo> list = new ArrayList<TradeInfo>();
        for (TradeRecipe trade : tradeList) {
            List<Ingredient> ingList = trade.getIngredList();
            for (int i = 0; i < ingList.size(); ++i) {
                int count = trade.getCountList().get(i);
                int value = trade.getValueList().get(i);
                Ingredient ing = ingList.get(i);
                ArrayList<ItemStack> stackList = new ArrayList<ItemStack>(Arrays.asList(ing.m_43908_()));
                stackList.forEach(s -> list.add(TradeInfo.create(s.m_41720_(), count, value, this.dateRand)));
            }
        }
        return this.getTradeList(list);
    }

    public List<TradeInfo> getTradeList(List<TradeInfo> list) {
        ArrayList<TradeInfo> tradeList = new ArrayList<TradeInfo>();
        int size = Math.min(this.getViewCount(), list.size());
        for (int i = 0; i < size; ++i) {
            TradeInfo info;
            while (tradeList.contains(info = list.get(this.dateRand.nextInt(list.size())))) {
            }
            tradeList.add(info);
        }
        return tradeList;
    }

    public int getValue(ICookingStatus cook, ItemStack stack) {
        return TileNotePC.getGlobalValue(cook.getRate(), stack);
    }

    public static int getGlobalValue(float rate, ItemStack stack) {
        int value = stack.m_41613_();
        Item item = stack.m_41720_();
        List seedStackList = TileNotePC.getGlobalTagList(TagInit.SEEDS).stream().toList();
        List saplingStackList = TileNotePC.getGlobalTagList(TagInit.SAPLINGS).stream().toList();
        if (saplingStackList.contains(item)) {
            return (int)((float)(25 * value) * rate);
        }
        if (seedStackList.contains(item) || item instanceof SMSeed) {
            return (int)((float)(40 * value) * rate);
        }
        if (item instanceof SMFood) {
            SMFood food = (SMFood)item;
            if (stack.m_150930_(ItemInit.watercup)) {
                return (int)((float)value * rate);
            }
            if (stack.m_150930_(ItemInit.milk_pack)) {
                return (int)((float)(5 * value) * rate);
            }
            FoodProperties pro = food.getFoodProperties(stack, null);
            int amount = (int)((float)Math.max(1, pro.m_38744_()) * Math.max(pro.m_38745_(), 0.05f) * 100.0f);
            float saturation = Math.max(pro.m_38745_() * pro.m_38745_(), 0.75f);
            int mfValue = (int)((double)amount * ((double)saturation + 0.1));
            float quality = 1.0f + (float)food.getQualityValue(stack) * 0.25f;
            return (int)((float)(mfValue * value) * rate * quality);
        }
        if (item instanceof IFood || ItemInit.foodList.contains(item) || item.m_41472_()) {
            if (ItemInit.foodList.contains(item)) {
                return (int)((float)(30 * value) * rate);
            }
            FoodProperties pro = item.m_41473_();
            int amount = (int)((float)pro.m_38744_() * pro.m_38745_() * 10.0f);
            int mfValue = (int)((float)amount * 0.5f);
            return (int)((float)(mfValue * value) * rate);
        }
        if (item == Items.f_42616_) {
            return (int)((float)(1000 * value) * rate);
        }
        if (SweetMagicAPI.hasMF(stack)) {
            int sp = (int)((float)(Math.min(10000, Math.max(1, SweetMagicAPI.getMF(stack) / 15)) * value) * rate);
            if (sp > 100000) {
                sp = (int)((float)sp * 0.33f);
            } else if (sp > 10000) {
                sp = (int)((float)sp * 0.67f);
            } else if (sp > 1000) {
                sp = (int)((float)sp * 0.75f);
            }
            return sp;
        }
        if (item instanceof IAcce) {
            IAcce acce = (IAcce)item;
            int tier = acce.getTier() - 1;
            return (int)((float)(1000 + 10000 * tier * tier) * rate * (float)acce.getStackCount(new AcceInfo(stack))) * value;
        }
        if (item instanceof ITier) {
            ITier tier = (ITier)item;
            return (int)(10.0f + (float)(20 * tier.getTier() * tier.getTier()) * rate) * value;
        }
        return Math.max(1, (int)((float)value * rate));
    }

    public void addButCount(int id) {
        switch (id) {
            case 0: {
                this.buyCount = Math.min(640, this.buyCount + 1);
                break;
            }
            case 1: {
                int addValue = this.buyCount == 1 ? 9 : 10;
                this.buyCount = Math.min(640, this.buyCount + addValue);
                break;
            }
            case 2: {
                int addValue2 = this.buyCount == 1 ? 63 : 64;
                this.buyCount = Math.min(640, this.buyCount + addValue2);
                break;
            }
            case 3: {
                this.buyCount = Math.max(1, this.buyCount - 1);
                break;
            }
            case 4: {
                this.buyCount = Math.max(1, this.buyCount - 10);
                break;
            }
            case 5: {
                this.buyCount = Math.max(1, this.buyCount - 64);
            }
        }
        this.sendInfo();
    }

    public void addButSale(Player player) {
        ItemStack stack = this.getInputItem();
        if (stack.m_41619_()) {
            return;
        }
        this.dateRand = new Random(this.seed + this.randDate);
        this.rate = this.getRate();
        ICookingStatus cook = this.getCook(player);
        if (cook == null) {
            return;
        }
        if (cook.getTradeSP() < 0) {
            cook.setTradeSP(0);
        }
        cook.setRate(this.rate);
        int value = this.getValue(cook, stack);
        cook.addTradeSP(value);
        stack.m_41774_(stack.m_41613_());
        cook.addTradeExp(player.m_9236_(), value, false);
        ICookingStatus.sendPKT(this.player);
    }

    public void addButBuy(Player player, int id) {
        if (!this.stackList.isEmpty()) {
            return;
        }
        ICookingStatus cook = this.getCook(player);
        if (cook == null) {
            return;
        }
        if (cook.getTradeSP() < 0) {
            cook.setTradeSP(0);
        }
        int viewCount = 10 + cook.getTradeLevel() * 2;
        int tabId = id / viewCount;
        int selectId = id % viewCount;
        List<List<TradeInfo>> tradeList = this.getTrade(player);
        TradeInfo info = tradeList.get(tabId).get(selectId);
        int buyCount = this.buyCount;
        int shrinkSP = info.price() * buyCount;
        if (cook.getTradeSP() < shrinkSP || this.m_58904_().m_5776_()) {
            return;
        }
        PacketHandler.sendToServer(new NoteBuyPKT(info, shrinkSP, buyCount, this.m_58899_()));
    }

    public long getNextTime() {
        return this.nextTime;
    }

    public void setNextTime() {
        this.nextTime = this.getNextDate();
        this.sendInfo();
    }

    public long getNextDate() {
        ServerLevel sever = this.m_58904_().m_7654_().m_129880_(Level.f_46428_);
        int dayTime = 24000;
        long date = sever.m_46468_() / (long)dayTime;
        long nextDate = (date + 1L) * (long)dayTime;
        return nextDate - sever.m_46468_();
    }

    public int getViewCount() {
        return this.viewCount;
    }

    public ICookingStatus getCook(Player player) {
        return ICookingStatus.hasValue((LivingEntity)player) ? ICookingStatus.getState((LivingEntity)player) : null;
    }

    public ITag<Item> getTagList(TagKey<Item> tag) {
        return TileNotePC.getGlobalTagList(tag);
    }

    public static ITag<Item> getGlobalTagList(TagKey<Item> tag) {
        return ForgeRegistries.ITEMS.tags().getTag(tag);
    }

    @Override
    public int getInvSize() {
        return 10;
    }

    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem() {
        return this.getInput().getStackInSlot(0);
    }

    public IItemHandler getOut() {
        return this.outInv;
    }

    public ItemStack getOutItem(int i) {
        return this.getOut().getStackInSlot(i);
    }

    @Override
    protected void m_183515_(CompoundTag tags) {
        super.m_183515_(tags);
        tags.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
        tags.m_128365_("outInv", (Tag)this.outInv.serializeNBT());
        tags.m_128405_("buyCount", this.buyCount);
        tags.m_128356_("nextTime", this.getNextTime());
        tags.m_128356_(SEED, this.seed);
        tags.m_128356_("randDate", this.randDate);
        this.saveStackList(tags, this.stackList, "stackList");
        if (this.ownerUUID != null) {
            tags.m_128362_("Owner", this.ownerUUID);
        }
    }

    @Override
    public void m_142466_(CompoundTag tags) {
        super.m_142466_(tags);
        this.inputInv.deserializeNBT(tags.m_128469_("inputInv"));
        this.outInv.deserializeNBT(tags.m_128469_("outInv"));
        this.buyCount = tags.m_128451_("buyCount");
        this.nextTime = tags.m_128454_("nextTime");
        this.seed = tags.m_128454_(SEED);
        this.randDate = tags.m_128454_("randDate");
        this.stackList = this.loadAllStack(tags, "stackList");
        if (tags.m_128403_("Owner")) {
            this.ownerUUID = tags.m_128342_("Owner");
        }
    }

    public CompoundTag saveTradeList(CompoundTag nbt, List<TradeInfo> tradeList, String name) {
        if (tradeList != null && !tradeList.isEmpty()) {
            ListTag tagsList = new ListTag();
            for (TradeInfo trade : tradeList) {
                CompoundTag tags = new CompoundTag();
                tags.m_128365_("stack", (Tag)trade.stack.m_41739_(new CompoundTag()));
                tags.m_128405_("price", trade.price);
                tagsList.add((Object)tags);
            }
            nbt.m_128365_(name, (Tag)tagsList);
        }
        return nbt;
    }

    public List<TradeInfo> loadAllTrade(CompoundTag nbt, String name) {
        ArrayList<TradeInfo> tradeList = new ArrayList<TradeInfo>();
        nbt.m_128437_(name, 10).forEach(t -> tradeList.add(new TradeInfo(ItemStack.m_41712_((CompoundTag)this.getTag((Tag)t).m_128469_("stack")), this.getTag((Tag)t).m_128451_("price"))));
        return tradeList;
    }

    public List<TradeRecipe> getTradeList() {
        ArrayList<TradeRecipe> list = new ArrayList<TradeRecipe>();
        List<Recipe> recipeList = this.m_58904_().m_7465_().m_44051_().stream().filter(r -> r instanceof TradeRecipe).toList();
        recipeList.forEach(r -> list.add((TradeRecipe)r));
        return list;
    }

    public List<TradeRecipe> filterTradeList(List<TradeRecipe> list, String tradeType) {
        return list.stream().filter(t -> t.getTradeType().equals(tradeType)).toList();
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getInputItem().m_41619_();
    }

    public void playBuy(Player player) {
        this.playSound((Entity)player, SoundInit.BUY, 0.67f, this.rand.nextFloat() * 0.1f + 0.9f);
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new NotePCMenu(windowId, inv, this);
    }

    public record TradeInfo(ItemStack stack, int price) {
        public static TradeInfo create(Item item, int price) {
            return new TradeInfo(new ItemStack((ItemLike)item), price);
        }

        public static TradeInfo create(Item item, int count, int price, Random rand) {
            return new TradeInfo(new ItemStack((ItemLike)item, count), price + rand.nextInt(Math.max(1, price / 4)));
        }

        public static TradeInfo create(Item item, int count, int price, float rate, Random rand) {
            ItemStack stack = new ItemStack((ItemLike)item, count);
            int mf = SweetMagicAPI.getMF(stack) + price;
            if (mf <= 0 && item instanceof ITier) {
                ITier ti = (ITier)item;
                int addRate = item instanceof IMagicItem ? Math.max(3, ti.getTier()) : 1;
                mf = 100 + (150 + price) * ti.getTier() * ti.getTier() * addRate;
            } else if (item instanceof ITier) {
                ITier ti = (ITier)item;
                int addRate = item instanceof IMagicItem ? Math.max(3, ti.getTier()) + 1 : 1;
                mf = mf * ti.getTier() * ti.getTier() * addRate;
            }
            return new TradeInfo(stack, (int)((float)mf * rate * (1.25f - rand.nextFloat() * 0.25f)));
        }
    }

    public static enum TradType {
        FURNITURE,
        MAGIC,
        SEASONING,
        SEED,
        VANILLA;


        public static TradType getType(String name) {
            return switch (name) {
                case TileNotePC.MAGIC -> MAGIC;
                case TileNotePC.SEASONING -> SEASONING;
                case TileNotePC.SEED -> SEED;
                case TileNotePC.VANILLA -> VANILLA;
                default -> FURNITURE;
            };
        }
    }
}

