/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.init.SoundInit;
import sweetmagic.init.TagInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.menu.ObMagiaMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.recipe.obmagia.ObMagiaRecipe;
import sweetmagic.util.ItemHelper;

public class TileObMagia
extends TileAbstractSM {
    public int maxCraftTime = 10;
    public int craftTime = 0;
    public boolean isCraft = false;
    public boolean canCraft = false;
    public ItemStack outStack = ItemStack.f_41583_;
    public ItemStack viewStack = ItemStack.f_41583_;
    public List<ItemStack> craftList = new ArrayList<ItemStack>();
    protected final TileAbstractSM.StackHandler baseInv = new TileAbstractSM.StackHandler(1);
    protected final TileAbstractSM.StackHandler pageInv = new TileAbstractSM.StackHandler(1);
    protected final TileAbstractSM.StackHandler handInv = new TileAbstractSM.StackHandler(1);
    protected final TileAbstractSM.StackHandler inputInv = new TileAbstractSM.StackHandler(this.getInvSize());
    protected final TileAbstractSM.StackHandler outputInv = new TileAbstractSM.StackHandler(1);
    protected final TileAbstractSM.StackHandler sideInv = new TileAbstractSM.StackHandler(9);

    public TileObMagia(BlockPos pos, BlockState state) {
        this(TileInit.obmagia, pos, state);
    }

    public TileObMagia(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.InOutHandlerProvider((IItemHandlerModifiable)this.inputInv, (IItemHandlerModifiable)this.outputInv);
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.tickTime % 10 != 0) {
            return;
        }
        if (this.tickTime >= 30) {
            this.tickTime = 0;
            if (this.isCraft && (this.maxCraftTime - 2) * 30 >= this.craftTime) {
                this.playSound(pos, SoundInit.TURN_PAGE, 0.1f, 1.0f);
            }
        }
        if (this.isCraft) {
            if (this.craftTime++ >= this.maxCraftTime) {
                this.craftFinish();
            }
            this.sendPKT();
            return;
        }
        if (this.isCraft || this.getHandItem().m_41619_()) {
            this.canCraft = false;
            this.sendPKT();
            return;
        }
        this.canCraft = this.checkRecipe();
        this.sendPKT();
    }

    public List<ItemStack> getStackList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        stackList.add(this.getHandItem());
        for (int i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getInputItem(i));
        }
        return stackList;
    }

    public boolean checkRecipe() {
        boolean isCraft;
        List<ItemStack> stackList = this.getStackList();
        ItemStack page = this.getPageItem();
        ItemStack base = this.getBaseItem();
        boolean bl = isCraft = !ObMagiaRecipe.getRecipe(this.m_58904_(), stackList, page, base).isEmpty();
        if (isCraft) {
            ObMagiaRecipe recipe = ObMagiaRecipe.getRecipe(this.m_58904_(), stackList, page, base).get();
            this.viewStack = recipe.m_8043_().m_41777_();
        }
        return isCraft;
    }

    public void craftStart() {
        List<ItemStack> stackList = this.getStackList();
        ItemStack page = this.getPageItem();
        ItemStack base = this.getBaseItem();
        ObMagiaRecipe recipe = ObMagiaRecipe.getRecipe(this.m_58904_(), stackList, page, base).get();
        ItemStack resultStack = recipe.m_8043_().m_41777_();
        if (!ItemHelper.insertStack(this.getOutput(), resultStack, true).m_41619_()) {
            return;
        }
        this.craftList = new ArrayList<ItemStack>(recipe.getRequestList());
        this.outStack = resultStack;
        block0: for (ItemStack request : recipe.getRequestList()) {
            for (ItemStack stack : stackList) {
                if (!request.m_150930_(stack.m_41720_())) continue;
                stack.m_41774_(request.m_41613_());
                continue block0;
            }
        }
        ItemStack pageStack = recipe.getPage();
        this.craftList.add(pageStack.m_41777_());
        page.m_41774_(pageStack.m_41613_());
        ItemStack baseStack = recipe.getBase();
        if (!baseStack.m_204117_(TagInit.MAGIC_BOOK)) {
            this.craftList.add(baseStack.m_41777_());
            base.m_41774_(baseStack.m_41613_());
        }
        this.maxCraftTime = recipe.getCraftTime();
        this.isCraft = true;
        this.canCraft = false;
        this.sendPKT();
        this.clickButton();
    }

    public void craftFinish() {
        ItemHelper.insertStack(this.getOutput(), this.outStack, false);
        this.playSound(this.m_58899_(), SoundInit.WRITE, 0.1f, 1.0f);
        this.clearInfo();
    }

    public void clearInfo() {
        this.craftTime = 0;
        this.maxCraftTime = 10;
        this.isCraft = false;
        this.outStack = ItemStack.f_41583_;
        this.viewStack = ItemStack.f_41583_;
        this.craftList.clear();
        this.sendPKT();
    }

    public List<ItemStack> getDropList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        this.addStackList(stackList, this.getHandItem());
        for (int i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getInputItem(i));
        }
        this.addStackList(stackList, this.getOutputItem());
        stackList.addAll(this.craftList);
        return stackList;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("baseInv", (Tag)this.baseInv.serializeNBT());
        tag.m_128365_("pageInv", (Tag)this.pageInv.serializeNBT());
        tag.m_128365_("handInv", (Tag)this.handInv.serializeNBT());
        tag.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
        tag.m_128365_("outputInv", (Tag)this.outputInv.serializeNBT());
        tag.m_128365_("sideInv", (Tag)this.sideInv.serializeNBT());
        tag.m_128379_("isCraft", this.isCraft);
        tag.m_128379_("canCraft", this.canCraft);
        tag.m_128405_("craftTime", this.craftTime);
        tag.m_128405_("maxCraftTime", this.maxCraftTime);
        this.saveStackList(tag, this.craftList, "craftList");
        tag.m_128365_("outPutStack", (Tag)this.outStack.m_41739_(new CompoundTag()));
        tag.m_128365_("viewStack", (Tag)this.viewStack.m_41739_(new CompoundTag()));
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.setInv(this.baseInv, tag, "baseInv");
        this.setInv(this.pageInv, tag, "pageInv");
        this.setInv(this.handInv, tag, "handInv");
        this.setInv(this.inputInv, tag, "inputInv");
        this.setInv(this.outputInv, tag, "outputInv");
        this.setInv(this.sideInv, tag, "sideInv");
        this.isCraft = tag.m_128471_("isCraft");
        this.canCraft = tag.m_128471_("canCraft");
        this.craftTime = tag.m_128451_("craftTime");
        this.maxCraftTime = tag.m_128451_("maxCraftTime");
        this.craftList = this.loadAllStack(tag, "craftList");
        this.outStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("outPutStack"));
        this.viewStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("viewStack"));
    }

    public void setInv(TileAbstractSM.StackHandler inv, CompoundTag tags, String name) {
        CompoundTag tag = tags.m_128469_(name);
        if (tag == null) {
            return;
        }
        inv.deserializeNBT(tag);
    }

    @Override
    public boolean isInfoEmpty() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        this.addStackList(stackList, this.outStack);
        this.addStackList(stackList, this.getOutputItem());
        this.addStackList(stackList, this.getPageItem());
        this.addStackList(stackList, this.getBaseItem());
        this.addStackList(stackList, this.getHandItem());
        for (int i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getInputItem(i));
        }
        return stackList.isEmpty();
    }

    @Override
    public int getInvSize() {
        return 8;
    }

    public IItemHandler getBase() {
        return this.baseInv;
    }

    public ItemStack getBaseItem() {
        return this.getBase().getStackInSlot(0);
    }

    public IItemHandler getpage() {
        return this.pageInv;
    }

    public ItemStack getPageItem() {
        return this.getpage().getStackInSlot(0);
    }

    public IItemHandler getHand() {
        return this.handInv;
    }

    public ItemStack getHandItem() {
        return this.getHand().getStackInSlot(0);
    }

    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem(int i) {
        return this.getInput().getStackInSlot(i);
    }

    public IItemHandler getOutput() {
        return this.outputInv;
    }

    public ItemStack getOutputItem() {
        return this.getOutput().getStackInSlot(0);
    }

    public IItemHandler getSide() {
        return this.sideInv;
    }

    public int getProgress(int value) {
        return this.getProgress(value, this.craftTime, this.maxCraftTime);
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new ObMagiaMenu(windowId, inv, this);
    }
}

