/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sweetmagic.api.iitem.IWand;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.tile.menu.ReplicaAltarMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.util.ItemHelper;

public class TileReplicaAltar
extends TileSMMagic {
    public boolean isCraft = false;
    public boolean canCraft = false;
    public int nowTick = 0;
    public int craftTime = 0;
    public int maxCraftTime = 10;
    public int maxMagiaFlux = 200000;
    public ItemStack copyMagic = ItemStack.f_41583_;
    public List<ItemStack> stackList = new ArrayList<ItemStack>();
    protected final TileAbstractSM.StackHandler inputInv = new TileAbstractSM.StackHandler(1, true){

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    protected final TileAbstractSM.StackHandler outputInv = new TileAbstractSM.StackHandler(1, true);
    protected final TileAbstractSM.StackHandler subInv = new TileAbstractSM.StackHandler(6);

    public TileReplicaAltar(BlockPos pos, BlockState state) {
        super(TileInit.replicaAltar, pos, state);
        this.resolver = (TileAbstractSM)this.new TileAbstractSM.SingleHandlerProvider((IItemHandlerModifiable)this.inputInv, IN_OUT);
    }

    public TileReplicaAltar(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.isCraft) {
            ++this.nowTick;
            this.sendPKT();
        }
        if (this.tickTime % 10 != 0) {
            return;
        }
        ItemStack stack = this.getInputItem();
        if (!this.isCraft) {
            if (stack.m_41619_()) {
                return;
            }
            this.canCraft = this.craftStart(stack, true);
            this.sendInfo();
            return;
        }
        if (this.craftTime + 2 < this.maxCraftTime && world instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)world;
            this.spawnParticleRing(server, (float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 1.3f, (float)pos.m_123343_() + 0.5f, 0.0, 0.0, 0.0, 0.75);
        }
        if (this.craftTime++ >= this.maxCraftTime) {
            this.craftFinish(stack);
        } else if (this.craftTime % 2 == 0 && this.craftTime <= this.maxCraftTime - 2) {
            this.playSound(pos, SoundInit.STARDUST, 1.0f, 0.9f + this.rand.nextFloat() * 0.3f);
        }
        this.sendInfo();
    }

    public boolean craftStart(ItemStack stack, boolean isSum) {
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        if (!(item instanceof IWand)) {
            return false;
        }
        IWand wand = (IWand)item;
        WandInfo info = new WandInfo(stack);
        boolean hasOut = this.hasOut(info);
        if (!hasOut && !ItemHelper.insertStack(this.getOutput(), stack.m_41777_(), true).m_41619_()) {
            return false;
        }
        if (this.getMF() < this.getRequestMF(info, hasOut)) {
            return false;
        }
        List<ItemStack> requestList = this.getRequestList(info, hasOut);
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < 6; ++i) {
            ItemStack sub = this.getSubItem(i);
            if (sub.m_41619_()) continue;
            stackList.add(sub);
        }
        ArrayList<ItemStack> resultList = new ArrayList<ItemStack>();
        ArrayList<Integer> slotIdList = new ArrayList<Integer>();
        for (ItemStack ingStack : requestList) {
            boolean isChecked = false;
            for (int i = 0; i < stackList.size(); ++i) {
                ItemStack s;
                if (slotIdList.contains(i) || !ingStack.m_150930_((s = (ItemStack)stackList.get(i)).m_41720_()) || s.m_41613_() < ingStack.m_41613_()) continue;
                slotIdList.add(i);
                resultList.add(ingStack);
                isChecked = true;
                break;
            }
            if (isChecked) continue;
            return false;
        }
        if (isSum) {
            return true;
        }
        this.isCraft = true;
        this.craftTime = 0;
        this.maxCraftTime = this.getMaxCraftTime(info);
        this.setMF(this.getMF() - this.getRequestMF(info, hasOut));
        this.copyMagic = hasOut ? new ItemStack((ItemLike)this.getOutItem().m_41720_()) : new ItemStack((ItemLike)stack.m_41720_());
        info = new WandInfo(this.copyMagic);
        info.getNBT().m_128405_("level", IWand.getWand(stack).getWandLevel(stack));
        this.stackList = new ArrayList<ItemStack>(resultList);
        this.clickButton();
        this.sendPKT();
        if (hasOut) {
            this.getOutItem().m_41774_(1);
        }
        for (ItemStack ingStack : resultList) {
            for (int i = 0; i < stackList.size(); ++i) {
                ItemStack s = (ItemStack)stackList.get(i);
                if (!ingStack.m_150930_(s.m_41720_()) || s.m_41613_() < ingStack.m_41613_()) continue;
                s.m_41774_(ingStack.m_41613_());
            }
        }
        return true;
    }

    public void craftFinish(ItemStack stack) {
        boolean hasOut;
        boolean bl = hasOut = !this.getOutItem().m_41619_();
        if (!hasOut && !ItemHelper.insertStack(this.getOutput(), this.copyMagic, true).m_41619_()) {
            return;
        }
        if (!hasOut) {
            ItemHelper.insertStack(this.getOutput(), this.copyMagic, false);
        }
        this.canCraft = false;
        this.isCraft = false;
        this.craftTime = 0;
        this.nowTick = 0;
        this.copyMagic = ItemStack.f_41583_;
        this.stackList.clear();
        this.playSound(this.getTilePos(), SoundEvents.f_12275_, 1.0f, 1.3f);
        this.m_58904_().m_46796_(2003, this.m_58899_().m_6630_(1), 0);
        this.sendPKT();
    }

    @Override
    public void clientTick(Level world, BlockPos pos, BlockState state) {
        super.clientTick(world, pos, state);
    }

    public void spawnParticle(Level world, BlockPos pos) {
        int i;
        float posX = (float)pos.m_123341_() + 0.5f;
        float posY = (float)pos.m_123342_() + 1.25f;
        float posZ = (float)pos.m_123343_() + 0.5f;
        SimpleParticleType par = ParticleInit.CYCLE_LIGHT;
        for (i = 0; i < 8; ++i) {
            this.spawnParticleCycle(world, (ParticleOptions)par, posX, posY, (double)posZ, 0.67, (float)i * 32.0f);
        }
        par = ParticleInit.DIVINE;
        for (i = 0; i < 2; ++i) {
            world.m_7106_((ParticleOptions)par, (double)(posX + this.getRandFloat(0.2f)), (double)posY, (double)(posZ + this.getRandFloat(0.2f)), (double)this.getRandFloat(0.075f), (double)0.1f, (double)this.getRandFloat(0.075f));
        }
    }

    protected void spawnParticleCycle(Level world, ParticleOptions par, double x, double y, double z, double range, double angle) {
        world.m_7106_(par, x, y, z, (double)Direction.UP.m_122411_(), range, angle + 6.0 - (double)(this.tickTime * 5));
    }

    public void getMainRequestItem(List<ItemStack> stackList, WandInfo info, boolean hasOut) {
        int totalExp = 0;
        IWand wand = info.getWand();
        for (int i = 0; i < wand.getWandLevel(info.getStack()); ++i) {
            totalExp += wand.getNeedExp(i + 1);
        }
        if (hasOut) {
            WandInfo outInfo = new WandInfo(this.getOutItem());
            IWand wandOut = outInfo.getWand();
            for (int i = 0; i < wandOut.getWandLevel(outInfo.getStack()); ++i) {
                totalExp -= wandOut.getNeedExp(i + 1);
                totalExp *= 2;
            }
        }
        if ((totalExp *= 4) >= 1000000) {
            stackList.add(new ItemStack((ItemLike)BlockInit.magiaflux_block, Math.min(61, totalExp / 1000000)));
        } else if (totalExp >= 100000) {
            stackList.add(new ItemStack((ItemLike)ItemInit.magia_bottle, totalExp / 100000));
        } else if (totalExp >= 10000) {
            stackList.add(new ItemStack((ItemLike)ItemInit.mf_bottle, totalExp / 10000));
        } else {
            stackList.add(new ItemStack((ItemLike)ItemInit.mf_small_bottle, totalExp / 1000));
        }
    }

    public boolean hasOut() {
        ItemStack inputStack = this.getInputItem();
        if (inputStack.m_41619_()) {
            return false;
        }
        return this.hasOut(new WandInfo(inputStack));
    }

    public boolean hasOut(WandInfo info) {
        ItemStack outStack = this.getOutItem();
        if (outStack.m_41619_()) {
            return false;
        }
        WandInfo out = new WandInfo(outStack);
        return info.getWand().getWandLevel(info.getStack()) > out.getWand().getWandLevel(out.getStack());
    }

    public int getMaxCraftTime(WandInfo info) {
        return switch (info.getWand().getWandTier()) {
            case 1 -> 6;
            case 2 -> 12;
            case 3 -> 18;
            case 4 -> 24;
            default -> 30;
        };
    }

    public List<ItemStack> getRequestList(WandInfo info, boolean hasOut) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        if (!hasOut) {
            switch (info.getWand().getWandTier()) {
                case 1: {
                    stackList.add(new ItemStack((ItemLike)ItemInit.aether_crystal, 4));
                    stackList.add(new ItemStack((ItemLike)ItemInit.mf_small_bottle, 4));
                    break;
                }
                case 2: {
                    stackList.add(new ItemStack((ItemLike)ItemInit.divine_crystal, 3));
                    stackList.add(new ItemStack((ItemLike)ItemInit.mf_bottle, 4));
                    stackList.add(new ItemStack((ItemLike)ItemInit.alternative_ingot, 6));
                    break;
                }
                case 3: {
                    stackList.add(new ItemStack((ItemLike)ItemInit.pure_crystal, 2));
                    stackList.add(new ItemStack((ItemLike)ItemInit.magia_bottle, 4));
                    stackList.add(new ItemStack((ItemLike)ItemInit.fluorite, 6));
                    break;
                }
                case 4: {
                    stackList.add(new ItemStack((ItemLike)ItemInit.deus_crystal));
                    stackList.add(new ItemStack((ItemLike)BlockInit.magiaflux_block));
                    stackList.add(new ItemStack((ItemLike)ItemInit.redberyl, 6));
                    break;
                }
                case 5: {
                    stackList.add(new ItemStack((ItemLike)ItemInit.cosmic_crystal));
                    stackList.add(new ItemStack((ItemLike)BlockInit.magiaflux_block, 3));
                    stackList.add(new ItemStack((ItemLike)ItemInit.redberyl, 16));
                }
            }
        }
        this.getMainRequestItem(stackList, info, hasOut);
        ItemHelper.compactItemListNoStacksize(stackList);
        return stackList;
    }

    public int getRequestMF(WandInfo info, boolean hasOut) {
        int rate = hasOut ? 10 : 1;
        return switch (info.getWand().getWandTier()) {
            case 2 -> 5000 / rate;
            case 3 -> 25000 / rate;
            case 4 -> 100000 / rate;
            case 5 -> 200000 / rate;
            default -> 2000 / rate;
        };
    }

    public int getCraftProgress(int value) {
        return this.getProgress(value, this.craftTime, this.maxCraftTime);
    }

    public void spawnParticleRing(ServerLevel world, double x, double y, double z, double vecX, double vecY, double vecZ, double step) {
        double spped = 0.075;
        for (double degree = 0.0; degree < Math.PI * 4; degree += step) {
            if (this.rand.nextFloat() > 0.67f) continue;
            world.m_8767_((ParticleOptions)ParticleInit.TWILIGHTLIGHT, x + Math.cos(degree), y, z + Math.sin(degree), 0, -Math.cos(degree) * spped, vecY, -Math.sin(degree) * spped, 1.0);
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
        tag.m_128365_("outputInv", (Tag)this.outputInv.serializeNBT());
        tag.m_128365_("subInv", (Tag)this.subInv.serializeNBT());
        tag.m_128365_("copyMagic", (Tag)this.copyMagic.m_41739_(new CompoundTag()));
        this.saveStackList(tag, this.stackList, "stackList");
        tag.m_128405_("nowTick", this.nowTick);
        tag.m_128405_("craftTime", this.craftTime);
        tag.m_128405_("maxCraftTime", this.maxCraftTime);
        tag.m_128379_("isCraft", this.isCraft);
        tag.m_128379_("canCraft", this.canCraft);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputInv.deserializeNBT(tag.m_128469_("inputInv"));
        this.outputInv.deserializeNBT(tag.m_128469_("outputInv"));
        this.subInv.deserializeNBT(tag.m_128469_("subInv"));
        this.stackList = this.loadAllStack(tag, "stackList");
        this.copyMagic = ItemStack.m_41712_((CompoundTag)tag.m_128469_("copyMagic"));
        this.nowTick = tag.m_128451_("nowTick");
        this.craftTime = tag.m_128451_("craftTime");
        this.maxCraftTime = tag.m_128451_("maxCraftTime");
        this.isCraft = tag.m_128471_("isCraft");
        this.canCraft = tag.m_128471_("canCraft");
    }

    @Override
    public int getMaxMF() {
        return this.maxMagiaFlux;
    }

    @Override
    public int getReceiveMF() {
        return 25000;
    }

    @Override
    public int getInvSize() {
        return 6;
    }

    @Override
    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem() {
        return this.getInput().getStackInSlot(0);
    }

    public IItemHandler getOutput() {
        return this.outputInv;
    }

    public ItemStack getOutItem() {
        return this.getOutput().getStackInSlot(0);
    }

    public IItemHandler getSub() {
        return this.subInv;
    }

    public ItemStack getSubItem(int i) {
        return this.getSub().getStackInSlot(i);
    }

    public List<ItemStack> getInvList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        this.addStackList(stackList, this.getInputItem());
        this.addStackList(stackList, this.getOutItem());
        for (int i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getSubItem(i));
        }
        return stackList;
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getInvList().isEmpty() && this.isMFEmpty();
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new ReplicaAltarMenu(windowId, inv, this);
    }
}

