/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.ItemInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.entity.animal.AbstractSummonMob;
import sweetmagic.init.entity.monster.ArchSpider;
import sweetmagic.init.entity.monster.BlazeTempest;
import sweetmagic.init.entity.monster.BlazeTempestTornado;
import sweetmagic.init.entity.monster.BlitzWizard;
import sweetmagic.init.entity.monster.CreeperCalamity;
import sweetmagic.init.entity.monster.DwarfZombie;
import sweetmagic.init.entity.monster.DwarfZombieMaster;
import sweetmagic.init.entity.monster.ElectricCube;
import sweetmagic.init.entity.monster.ElectricGolem;
import sweetmagic.init.entity.monster.EnderMage;
import sweetmagic.init.entity.monster.EnderShadow;
import sweetmagic.init.entity.monster.PhantomWolf;
import sweetmagic.init.entity.monster.SkullFlame;
import sweetmagic.init.entity.monster.SkullFlameArcher;
import sweetmagic.init.entity.monster.SkullFrost;
import sweetmagic.init.entity.monster.SkullFrostRoyalGuard;
import sweetmagic.init.entity.monster.WindWitch;
import sweetmagic.init.tile.menu.SpawnStoneMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;

public class TileSpawnStone
extends TileAbstractSM {
    private int range = 4;
    private int mobLevel = 1;
    private int mobType = 0;
    public boolean isPlayer = false;
    public boolean isPeace = false;

    public TileSpawnStone(BlockPos pos, BlockState state) {
        super(TileInit.spawnStone, pos, state);
    }

    public TileSpawnStone(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state) {
        super.serverTick(world, pos, state);
        if (this.tickTime % 10 != 0 || this.isPeaceful(world)) {
            return;
        }
        List<Player> playerList = this.getEntityListUp(Player.class, e -> e.m_6084_() && !e.m_7500_() && !e.m_5833_(), this.getRange());
        if (playerList.isEmpty()) {
            return;
        }
        this.spawnMob(world, pos, this.getMobLevel());
    }

    public void spawnMob(Level world, BlockPos pos, int data) {
        int count = 0;
        int maxCount = this.range * this.range;
        Random rand = this.rand;
        int spawnMobType = this.getMobType();
        if (spawnMobType == -1) {
            spawnMobType = rand.nextInt(9);
        }
        int summonSize = 4;
        int playerAllListSize = this.getEntityList(Player.class, e -> e.m_6084_() && !e.m_7500_() && !e.m_5833_(), 80.0).size() - 1;
        if (playerAllListSize > 0) {
            summonSize = (int)((float)summonSize * (1.0f + (float)playerAllListSize * 0.1f));
        }
        int summonMobSize = this.getEntityList(AbstractSummonMob.class, e -> e.m_6084_(), 80.0).size();
        float addHealth = 1.0f + (float)summonMobSize * 0.1f;
        for (int i = 0; i < summonSize; ++i) {
            boolean isZero = i % 4 == 0;
            BlockPos secondPos = new BlockPos(pos.m_123341_() + this.getRand(rand, 3), pos.m_123342_(), pos.m_123343_() + this.getRand(rand, 3));
            count = 0;
            while (!this.checkAABB(world, secondPos)) {
                secondPos = new BlockPos(pos.m_123341_() + this.getRand(rand, 3), pos.m_123342_(), pos.m_123343_() + this.getRand(rand, 3));
                if (count++ < maxCount / 2) continue;
            }
            LivingEntity entity = isZero ? this.setBigMob(world, spawnMobType, data, addHealth) : this.setMob(world, spawnMobType, data, addHealth);
            entity.m_6034_((double)secondPos.m_123341_() + 0.5, (double)secondPos.m_123342_() + 0.5, (double)secondPos.m_123343_() + 0.5);
            world.m_7967_((Entity)entity);
            ((ISMMob)entity).refreshInfo();
        }
        world.m_46961_(pos, false);
        world.m_7471_(pos, false);
        this.playSound(pos, SoundInit.HORAMAGIC, 0.15f, 1.0f);
    }

    public LivingEntity setMob(Level world, int spawnMobType, int mobLevel, float addHealth) {
        ISMMob entity = null;
        switch (spawnMobType) {
            case 1: {
                entity = new SkullFlame(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                break;
            }
            case 2: {
                entity = new BlazeTempest(world);
                break;
            }
            case 3: {
                entity = new EnderMage(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                break;
            }
            case 4: {
                entity = new DwarfZombie(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ItemInit.alt_pick));
                break;
            }
            case 5: {
                entity = new WindWitch(world);
                this.addPotion((LivingEntity)entity, MobEffects.f_19613_, 99999, 0);
                break;
            }
            case 6: {
                entity = new ElectricCube(world);
                ((ElectricCube)entity).setSize(2);
                this.addPotion((LivingEntity)entity, PotionInit.leader_flag, 99999, 0);
                break;
            }
            case 7: {
                entity = new ArchSpider(world);
                break;
            }
            case 8: {
                entity = new CreeperCalamity(world);
                break;
            }
            default: {
                entity = new SkullFrost(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
            }
        }
        entity.m_21051_(Attributes.f_22276_).m_22100_((double)(entity.m_21233_() * (1.0f + (float)mobLevel * 0.5f) * addHealth));
        entity.m_21153_(entity.m_21233_());
        this.setMobBuff((LivingEntity)entity, mobLevel);
        return entity;
    }

    public LivingEntity setBigMob(Level world, int spawnMobType, int mobLevel, float addHealth) {
        ISMMob entity = null;
        switch (spawnMobType) {
            case 1: {
                entity = new SkullFlameArcher(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                entity.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42472_));
                entity.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42475_));
                break;
            }
            case 2: {
                entity = new BlazeTempestTornado(world);
                break;
            }
            case 3: {
                entity = new EnderShadow(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
                break;
            }
            case 4: {
                entity = new DwarfZombieMaster(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ItemInit.alt_sword));
                break;
            }
            case 5: {
                entity = new WindWitch(world);
                this.addPotion((LivingEntity)entity, MobEffects.f_19600_, 99999, 1);
                break;
            }
            case 6: {
                entity = new ElectricGolem(world);
                break;
            }
            case 7: {
                entity = new PhantomWolf(world);
                break;
            }
            case 8: {
                entity = new BlitzWizard(world);
                break;
            }
            default: {
                entity = new SkullFrostRoyalGuard(world);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                entity.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42469_));
                entity.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42471_));
            }
        }
        entity.m_21051_(Attributes.f_22276_).m_22100_((double)(entity.m_21233_() * (1.0f + (float)mobLevel * 0.5f) * addHealth));
        entity.m_21153_(entity.m_21233_());
        this.setBigMobBuff((LivingEntity)entity, mobLevel);
        return entity;
    }

    public String getEntityName() {
        String text = switch (this.getMobType()) {
            case 0 -> "skullfrost_royalguard";
            case 1 -> "skullflame_archer";
            case 2 -> "blazetempest_tornado";
            case 3 -> "endershadow";
            case 4 -> "dwarfzombie_master";
            case 5 -> "windwitch";
            case 6 -> "electricgolem";
            case 7 -> "phantomwolf";
            case 8 -> "blitz_wizard";
            default -> "random";
        };
        return this.getTip("entity.sweetmagic." + text).getString();
    }

    public void setMobBuff(LivingEntity entity, int mobLevel) {
        this.addPotion(entity, MobEffects.f_19600_, 99999, mobLevel);
        this.addPotion(entity, PotionInit.resistance_blow, 99999, 5);
    }

    public void setBigMobBuff(LivingEntity entity, int mobLevel) {
        this.addPotion(entity, PotionInit.resistance_blow, 99999, 5);
        this.addPotion(entity, PotionInit.aether_armor, 200, 4);
    }

    public void clickButton(int id) {
        switch (id) {
            case 0: {
                this.setRange(Math.min(16, this.getRange() + 1));
                break;
            }
            case 1: {
                this.setRange(Math.max(1, this.getRange() - 1));
                break;
            }
            case 2: {
                this.setMobLevel(Math.min(10, this.getMobLevel() + 1));
                break;
            }
            case 3: {
                this.setMobLevel(Math.max(1, this.getMobLevel() - 1));
                break;
            }
            case 4: {
                this.setMobType(Math.min(8, this.getMobType() + 1));
                break;
            }
            case 5: {
                this.setMobType(Math.max(-1, this.getMobType() - 1));
            }
        }
        this.sendPKT();
        this.clickButton();
    }

    @Override
    public boolean checkAABB(Level world, BlockPos pos) {
        BlockState underState = world.m_8055_(pos.m_6625_(2));
        VoxelShape underAABB = underState.m_60734_().m_7947_(underState, (BlockGetter)world, pos.m_7495_());
        return super.checkAABB(world, pos) && underAABB.equals(Shapes.m_83040_());
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("range", this.getRange());
        tag.m_128405_("mobLevel", this.getMobLevel());
        tag.m_128405_("mobType", this.getMobType());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.setRange(tag.m_128451_("range"));
        this.setMobLevel(tag.m_128451_("mobLevel"));
        this.setMobType(tag.m_128451_("mobType"));
    }

    public int getRand(Random rand, int range) {
        return rand.nextInt(range) - rand.nextInt(range);
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int range) {
        this.range = range;
    }

    public int getMobLevel() {
        return this.mobLevel;
    }

    public void setMobLevel(int level) {
        this.mobLevel = level;
    }

    public int getMobType() {
        return this.mobType;
    }

    public void setMobType(int mobType) {
        this.mobType = mobType;
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new SpawnStoneMenu(windowId, inv, this);
    }
}

