/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.sm;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import sweetmagic.init.TileInit;
import sweetmagic.init.item.magic.MFTeleport;
import sweetmagic.init.tile.menu.WarpMenu;
import sweetmagic.init.tile.sm.TileAbstractSM;

public class TileWarp
extends TileAbstractSM {
    protected final TileAbstractSM.StackHandler inputInv = new TileAbstractSM.StackHandler(this.getInvSize()){

        public int getSlotLimit(int slot) {
            return 1;
        }
    };

    public TileWarp(BlockPos pos, BlockState state) {
        super(TileInit.warpBlock, pos, state);
    }

    public void doTereport(Player player, int id) {
        ItemStack stack = this.getInputItem(id);
        if (stack.m_41619_() || !(stack.m_41720_() instanceof MFTeleport)) {
            return;
        }
        CompoundTag tags = stack.m_41783_();
        if (tags == null || !tags.m_128441_("pX")) {
            return;
        }
        this.clickButton();
        this.playSound(player.m_20183_(), SoundEvents.f_11852_, 1.0f, 1.0f);
        BlockPos pos = new BlockPos((double)((float)tags.m_128451_("pX") + 0.5f), (double)((float)tags.m_128451_("pY") + 1.0f), (double)((float)tags.m_128451_("pZ") + 0.5f));
        ResourceLocation dim = new ResourceLocation(tags.m_128461_("dim"));
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            double range = 0.875;
            double ySpeed = -2.0;
            for (int i = -1; i < 5; ++i) {
                this.spawnParticleRing(server, (ParticleOptions)ParticleTypes.f_123760_, range, player.m_20183_().m_6630_(1), (double)i / 3.0, ySpeed, 1.0);
            }
        }
        if (player.m_20194_() != null && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            ServerLevel server = sp.m_20194_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dim));
            sp.m_8999_(server, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
            double range = 0.875;
            double ySpeed = 1.0;
            for (int i = -1; i < 5; ++i) {
                this.spawnParticleRing(server, (ParticleOptions)ParticleTypes.f_123760_, range, pos.m_6625_(2), (double)i / 3.0, ySpeed, 1.0);
            }
            this.playSound((Level)server, pos, SoundEvents.f_11852_, 1.0f, 1.0f);
        }
        player.f_19789_ = 0.0f;
        player.m_6756_(0);
    }

    @Override
    public int getInvSize() {
        return 4;
    }

    public IItemHandler getInput() {
        return this.inputInv;
    }

    public ItemStack getInputItem(int i) {
        return this.getInput().getStackInSlot(i);
    }

    @Override
    public boolean isInfoEmpty() {
        return this.getInputList().isEmpty();
    }

    public List<ItemStack> getInputList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getInvSize(); ++i) {
            this.addStackList(stackList, this.getInputItem(i));
        }
        return stackList;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inputInv", (Tag)this.inputInv.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.setInv(this.inputInv, tag, "inputInv");
    }

    public void setInv(TileAbstractSM.StackHandler inv, CompoundTag tags, String name) {
        CompoundTag tag = tags.m_128469_(name);
        if (tag == null) {
            return;
        }
        inv.deserializeNBT(tag);
    }

    @Override
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new WarpMenu(windowId, inv, this);
    }
}

