/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.packet;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import sweetmagic.api.iitem.IMagicBook;
import sweetmagic.api.iitem.IPorch;
import sweetmagic.api.iitem.IRobe;
import sweetmagic.api.iitem.IWand;
import sweetmagic.init.ItemInit;
import sweetmagic.init.entity.block.Broom;
import sweetmagic.init.item.magic.StartLightWand;
import sweetmagic.init.item.sm.SMAxe;
import sweetmagic.key.SMKeybind;
import sweetmagic.packet.IPacket;

public record KeyPressPKT(SMKeybind key) implements IPacket
{
    @Override
    public void handle(NetworkEvent.Context con) {
        ServerPlayer player = con.getSender();
        if (player == null) {
            return;
        }
        Level level = player.f_19853_;
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        ItemStack wandStack = IWand.getWand((Player)player);
        Item wandItem = wandStack.m_41720_();
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        ItemStack leg = player.m_6844_(EquipmentSlot.LEGS);
        switch (this.key) {
            case OPEN: {
                Item item2;
                if (!wandStack.m_41619_() && wandItem instanceof IWand) {
                    IWand wand = (IWand)wandItem;
                    wand.openGui(level, (Player)player, wandStack);
                    break;
                }
                if (chest.m_41619_() || !((item2 = chest.m_41720_()) instanceof IRobe)) break;
                IRobe robe = (IRobe)item2;
                robe.openGui(level, (Player)player, chest);
                break;
            }
            case NEXT: {
                if (player.m_6144_()) {
                    IPorch porch;
                    Item item3;
                    if (leg.m_41619_() || !((item3 = leg.m_41720_()) instanceof IPorch) || !(porch = (IPorch)item3).hasAcce(leg, ItemInit.earth_ruby_ring)) break;
                    porch.acceInvalidate((Player)player, leg, ItemInit.earth_ruby_ring);
                    return;
                }
                if (!wandStack.m_41619_() && wandItem instanceof IWand) {
                    IWand wand = (IWand)wandItem;
                    wand.nextSlot(level, (Player)player, wandStack);
                    break;
                }
                if (!(item instanceof StartLightWand)) break;
                StartLightWand wand = (StartLightWand)item;
                wand.resetPos((Player)player, stack);
                break;
            }
            case BACK: {
                if (item instanceof IMagicBook) {
                    IMagicBook book = (IMagicBook)item;
                    book.openGui(level, (Player)player, stack);
                    break;
                }
                if (!wandStack.m_41619_() && wandItem instanceof IWand) {
                    IWand wand = (IWand)wandItem;
                    wand.backSlot(level, (Player)player, wandStack);
                    break;
                }
                if (!(item instanceof StartLightWand)) break;
                StartLightWand wand = (StartLightWand)item;
                wand.changeExchange((Player)player, stack);
                break;
            }
            case POUCH: {
                Item wand;
                if (leg.m_41619_() || !((wand = leg.m_41720_()) instanceof IPorch)) break;
                IPorch porch = (IPorch)wand;
                if (player.m_6144_() && porch.hasAcce(leg, ItemInit.gravity_pendant)) {
                    porch.acceInvalidate((Player)player, leg, ItemInit.gravity_pendant);
                    break;
                }
                porch.openGui(level, (Player)player, leg);
                break;
            }
            case SPECIAL: {
                Broom broom;
                Entity entity = player.m_20202_();
                if (entity instanceof Broom && (broom = (Broom)entity).m_146895_() == player) {
                    broom.setHide(!broom.getHide());
                    break;
                }
                if (!(item instanceof SMAxe)) break;
                SMAxe axe = (SMAxe)item;
                axe.cancelAction((Player)player);
                break;
            }
            case BROOM: {
                Broom broom;
                Entity entity = player.m_20202_();
                if (!(entity instanceof Broom) || (broom = (Broom)entity).m_146895_() != player) break;
                broom.setInput(true);
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.key);
    }

    public static KeyPressPKT decode(FriendlyByteBuf buf) {
        return new KeyPressPKT((SMKeybind)buf.m_130066_(SMKeybind.class));
    }
}

