/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.packet;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import sweetmagic.init.capability.icap.ICookingStatus;
import sweetmagic.init.tile.sm.TileNotePC;
import sweetmagic.packet.IPacket;
import sweetmagic.util.ItemHelper;
import sweetmagic.util.SMDebug;

public record NoteBuyPKT(TileNotePC.TradeInfo info, int shrinkSP, int buyCount, BlockPos pos) implements IPacket
{
    @Override
    public void handle(NetworkEvent.Context con) {
        int count;
        int newBuyCount;
        ServerPlayer player = con.getSender();
        if (player == null) {
            return;
        }
        TileNotePC tile = (TileNotePC)player.m_9236_().m_7702_(this.pos);
        ICookingStatus cook = tile.getCook((Player)player);
        if (cook == null) {
            return;
        }
        SMDebug.info(newBuyCount);
        for (newBuyCount = this.buyCount; newBuyCount > 0; newBuyCount -= count) {
            count = Math.min(64, newBuyCount);
            ItemStack stack = this.info.stack();
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(count * copy.m_41613_());
            ItemStack out = ItemHelper.insertStack(tile.getOut(), copy, false);
            tile.addStackList(tile.stackList, out);
        }
        cook.addTradeExp((Level)player.m_9236_(), this.shrinkSP, true);
        cook.addTradeSP(-this.shrinkSP);
        ICookingStatus.sendPKT((Player)player);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeItemStack(this.info.stack(), false);
        buf.writeInt(this.info.price());
        buf.writeInt(this.shrinkSP);
        buf.writeInt(this.buyCount);
        buf.m_130064_(this.pos);
    }

    public static NoteBuyPKT decode(FriendlyByteBuf buf) {
        return new NoteBuyPKT(new TileNotePC.TradeInfo(buf.m_130267_(), buf.readInt()), buf.readInt(), buf.readInt(), buf.m_130135_());
    }
}

