/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.plugin.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.BlockInit;
import sweetmagic.plugin.jei.AbstractCategory;
import sweetmagic.plugin.jei.SMJeiPlugin;
import sweetmagic.recipe.juice_maker.JuiceMakerRecipe;

public class JuiceMakerCategory
extends AbstractCategory
implements IRecipeCategory<JuiceMakerRecipe> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_juicemaker.png");
    private final IDrawableAnimated arrow;
    private final IDrawable water;

    public JuiceMakerCategory(IGuiHelper helper) {
        IDrawableStatic background = helper.createDrawable(TEX, 0, 0, 176, 104);
        IDrawable icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockInit.juice_maker));
        this.recipeType = helper.createDrawable(TEX, 0, 181, 176, 4);
        this.water = helper.createDrawable(TEX, 190, 0, 17, 77);
        this.arrow = helper.drawableBuilder(TEX, 211, 15, 22, 14).buildAnimated(60, IDrawableAnimated.StartDirection.LEFT, false);
        this.setInfo((IDrawable)background, icon, "juicemaker");
    }

    public RecipeType<JuiceMakerRecipe> getRecipeType() {
        return SMJeiPlugin.JUICEMAKER;
    }

    public void setRecipe(IRecipeLayoutBuilder build, JuiceMakerRecipe recipe, IFocusGroup group) {
        int i;
        List<Ingredient> ingredList = recipe.getIngredList();
        List<ItemStack> resultList = recipe.getResultList();
        int handCount = recipe.getCountList().get(0);
        ArrayList<ItemStack> handList = new ArrayList<ItemStack>();
        List<ItemStack> ingHandList = Arrays.asList(ingredList.get(0).m_43908_());
        for (ItemStack stack : ingHandList) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(handCount);
            handList.add(copy);
        }
        build.addSlot(RecipeIngredientRole.INPUT, 71, 8).addItemStacks(handList);
        for (i = 1; i < ingredList.size(); ++i) {
            int count = recipe.getCountList().get(i);
            ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
            List<ItemStack> ingStackList = Arrays.asList(ingredList.get(i).m_43908_());
            for (ItemStack stack : ingStackList) {
                ItemStack copy = stack.m_41777_();
                copy.m_41764_(count);
                stackList.add(copy);
            }
            build.addSlot(RecipeIngredientRole.INPUT, 71, 26 + i * 18).addItemStacks(stackList);
        }
        for (i = 0; i < resultList.size(); ++i) {
            ItemStack stack = resultList.get(i);
            build.addSlot(RecipeIngredientRole.OUTPUT, 134, 8 + i * 18).addItemStack(stack);
        }
    }

    public void draw(JuiceMakerRecipe recipe, IRecipeSlotsView view, PoseStack pose, double mouseX, double mouseY) {
        this.recipeType.draw(pose, 0, 100);
        this.water.draw(pose, 28, 18);
        this.arrow.draw(pose, 99, 36);
    }
}

