/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.plugin.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.BlockInit;
import sweetmagic.plugin.jei.AbstractCategory;
import sweetmagic.plugin.jei.SMJeiPlugin;
import sweetmagic.recipe.mill.MillRecipe;

public class MillRecipeCategory
extends AbstractCategory
implements IRecipeCategory<MillRecipe> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_mill.png");

    public MillRecipeCategory(IGuiHelper helper) {
        IDrawableStatic background = helper.createDrawable(TEX, 0, 0, 124, 116);
        IDrawable icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockInit.mill));
        this.setInfo((IDrawable)background, icon, "mill");
    }

    public RecipeType<MillRecipe> getRecipeType() {
        return SMJeiPlugin.MILL;
    }

    public void setRecipe(IRecipeLayoutBuilder build, MillRecipe recipe, IFocusGroup group) {
        int i;
        List<Ingredient> ingredList = recipe.getIngredList();
        List<ItemStack> resultList = recipe.getResultList();
        List<Float> chancList = recipe.getChanceList();
        ((IRecipeSlotBuilder)build.addSlot(RecipeIngredientRole.INPUT, 5, 27).addItemStacks(Arrays.asList(ingredList.get(0).m_43908_()))).addTooltipCallback((view, tip) -> tip.add(1, this.getTipArray(this.getText("right_click")).m_130940_(GOLD)));
        for (i = 1; i < ingredList.size(); ++i) {
            boolean isSecond = i > 5;
            int x = 5 + (i - 1 - (isSecond ? 4 : 0)) * 18;
            int y = 42 + (isSecond ? 1 : 0);
            int count = recipe.getCountList().get(i);
            ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
            List<ItemStack> ingStackList = Arrays.asList(ingredList.get(i).m_43908_());
            for (ItemStack stack : ingStackList) {
                ItemStack copy = stack.m_41777_();
                copy.m_41764_(count);
                stackList.add(copy);
            }
            build.addSlot(RecipeIngredientRole.INPUT, x, y).addItemStacks(stackList);
        }
        build.addSlot(RecipeIngredientRole.OUTPUT, 65, 27).addItemStack(resultList.get(0));
        for (i = 1; i < resultList.size(); ++i) {
            int addY = (i - 1) * 18;
            String chance = String.format("%.2f", Float.valueOf((chancList.isEmpty() ? 1.0f : chancList.get(i).floatValue()) * 100.0f));
            ((IRecipeSlotBuilder)build.addSlot(RecipeIngredientRole.OUTPUT, 103, 5 + addY).addItemStack(resultList.get(i))).addTooltipCallback((view, tip) -> tip.add(1, this.getTipArray(this.getText("chancedrop"), "\uff1a" + chance + "%").m_130940_(GOLD)));
        }
    }
}

