/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.recipe;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import sweetmagic.init.ItemInit;
import sweetmagic.init.TagInit;
import sweetmagic.init.item.sm.SMBucket;
import sweetmagic.recipe.base.AbstractRecipe;

public class RecipeHelper {
    public static List<ItemStack> getPlayerInv(Player player, ItemStack stack) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        Inventory inv = player.m_150109_();
        NonNullList pInv = inv.f_35974_;
        int selectId = inv.f_35977_;
        stackList.add(stack);
        for (int i = 0; i < pInv.size(); ++i) {
            ItemStack s = (ItemStack)pInv.get(i);
            if (i == selectId || ((ItemStack)pInv.get(i)).m_41619_()) continue;
            stackList.add(s);
        }
        return stackList;
    }

    public static RecipeUtil recipeAllCraft(List<ItemStack> invList, AbstractRecipe recipe) {
        Item fluid;
        ArrayList<ItemStack> inputList = new ArrayList<ItemStack>();
        ArrayList<ItemStack> resultAllList = new ArrayList<ItemStack>();
        List<ItemStack> requestList = recipe.getRequestList();
        List<ItemStack> resultList = recipe.getResultList();
        if (recipe.isTagResult()) {
            Random rand = new Random();
            List<Ingredient> ingList = recipe.getResultIngList();
            resultList = new ArrayList<ItemStack>();
            for (Ingredient ing : ingList) {
                Object stackArray;
                resultList.add(stackArray[((ItemStack[])(stackArray = ing.m_43908_())).length > 1 ? rand.nextInt(((Object)stackArray).length) : 0]);
            }
        }
        int reHandAmount = requestList.get(0).m_41613_();
        int shrinkAmount = RecipeHelper.getRequestAmount(reHandAmount, invList.get(0).m_41777_().m_41613_());
        block1: for (ItemStack request : requestList) {
            for (ItemStack stack : invList) {
                Item item;
                if (!request.m_150930_(stack.m_41720_())) continue;
                if (stack.m_150930_(ItemInit.alt_bucket_water) && (item = stack.m_41720_()) instanceof SMBucket) {
                    SMBucket bucket = (SMBucket)item;
                    fluid = bucket.getFluidStack(stack);
                    if (fluid.isEmpty() || fluid.getAmount() < request.m_41613_()) continue;
                    int inputShrink = RecipeHelper.getRequestAmount(request.m_41613_(), fluid.getAmount());
                    shrinkAmount = shrinkAmount > inputShrink ? inputShrink : shrinkAmount;
                    continue block1;
                }
                if (request.m_41613_() > stack.m_41613_()) continue;
                int inputShrink = RecipeHelper.getRequestAmount(request.m_41613_(), stack.m_41613_());
                shrinkAmount = shrinkAmount > inputShrink ? inputShrink : shrinkAmount;
                continue block1;
            }
        }
        block3: for (ItemStack request : requestList) {
            for (ItemStack stack : invList) {
                if (!request.m_150930_(stack.m_41720_())) continue;
                if (stack.m_150930_(ItemInit.alt_bucket_water) && (fluid = stack.m_41720_()) instanceof SMBucket) {
                    SMBucket bucket = (SMBucket)fluid;
                    if ((fluid = bucket.getFluidStack(stack)).isEmpty() || fluid.getAmount() < request.m_41613_()) continue;
                    int shrinkCount = shrinkAmount * request.m_41613_();
                    ItemStack send = stack.m_41777_();
                    inputList.add(stack.m_41777_());
                    send.m_41751_(bucket.getTag(stack));
                    send = bucket.shrinkWater(send, shrinkCount * 1000);
                    resultAllList.add(send);
                    stack.m_41774_(1);
                    continue block3;
                }
                if (request.m_41613_() > stack.m_41613_()) continue;
                int shrinkCount = shrinkAmount * request.m_41613_();
                ItemStack send = stack.m_41777_();
                send.m_41764_(shrinkCount);
                inputList.add(send);
                if (RecipeHelper.isBucket(stack.m_41720_())) {
                    resultAllList.add(new ItemStack((ItemLike)Items.f_42446_));
                }
                stack.m_41774_(shrinkCount);
                continue block3;
            }
        }
        for (ItemStack stack : resultList) {
            int input;
            for (int amount = stack.m_41613_() * shrinkAmount; amount > 0; amount -= input) {
                input = Math.min(amount, 64);
                ItemStack resultItems = stack.m_41777_();
                resultItems.m_41764_(input);
                resultAllList.add(resultItems);
            }
        }
        return new RecipeUtil(inputList, resultAllList, shrinkAmount);
    }

    public static RecipeUtil recipeSingleCraft(List<ItemStack> stackList, AbstractRecipe recipe) {
        ArrayList<ItemStack> inputList = new ArrayList<ItemStack>();
        List<ItemStack> requestList = recipe.getRequestList();
        List<ItemStack> resultList = recipe.getResultList();
        block0: for (ItemStack request : requestList) {
            for (int i = 0; i < stackList.size(); ++i) {
                Item item;
                ItemStack stack = stackList.get(i);
                if (!request.m_150930_(stack.m_41720_())) continue;
                if (stack.m_150930_(ItemInit.alt_bucket_water) && (item = stack.m_41720_()) instanceof SMBucket) {
                    SMBucket bucket = (SMBucket)item;
                    FluidStack fluid = bucket.getFluidStack(stack);
                    if (fluid.isEmpty() || fluid.getAmount() < request.m_41613_()) continue;
                    ItemStack send = stack.m_41777_();
                    inputList.add(stack.m_41777_());
                    send.m_41751_(bucket.getTag(stack));
                    send = bucket.shrinkWater(send, request.m_41613_() * 1000);
                    resultList.add(send);
                    stack.m_41774_(1);
                    continue block0;
                }
                if (request.m_41613_() > stack.m_41613_()) continue;
                if (stack.m_204117_(TagInit.MAGIC_BOOK_COSMIC) && i != 0) continue block0;
                int shrinkCount = request.m_41613_();
                ItemStack send = stack.m_41777_();
                send.m_41764_(shrinkCount);
                inputList.add(send);
                if (RecipeHelper.isBucket(stack.m_41720_())) {
                    resultList.add(new ItemStack((ItemLike)Items.f_42446_));
                }
                stack.m_41774_(shrinkCount);
                continue block0;
            }
        }
        return new RecipeUtil(inputList, resultList, 1);
    }

    public static RecipeUtil recipePreview(List<ItemStack> stackList, AbstractRecipe recipe) {
        ArrayList<ItemStack> inputList = new ArrayList<ItemStack>();
        List<ItemStack> requestList = recipe.getRequestList();
        List<ItemStack> resultList = recipe.getResultList();
        block0: for (ItemStack request : requestList) {
            for (ItemStack stack : stackList) {
                Item item;
                if (!request.m_150930_(stack.m_41720_())) continue;
                if (stack.m_150930_(ItemInit.alt_bucket_water) && (item = stack.m_41720_()) instanceof SMBucket) {
                    SMBucket bucket = (SMBucket)item;
                    FluidStack fluid = bucket.getFluidStack(stack);
                    if (!fluid.isEmpty() && fluid.getAmount() >= request.m_41613_()) {
                        inputList.add(stack.m_41777_());
                        resultList.add(stack.m_41777_());
                        continue block0;
                    }
                } else if (request.m_41613_() > stack.m_41613_()) continue;
                int shrinkCount = request.m_41613_();
                ItemStack send = stack.m_41777_();
                send.m_41764_(shrinkCount);
                inputList.add(send);
                if (RecipeHelper.isBucket(stack.m_41720_())) {
                    resultList.add(new ItemStack((ItemLike)Items.f_42446_));
                    continue block0;
                }
                if (!stack.m_204117_(TagInit.MAGIC_BOOK_COSMIC)) continue block0;
                resultList.add(stack.m_41777_());
                continue block0;
            }
        }
        return new RecipeUtil(inputList, resultList, 1);
    }

    public static int getRequestAmount(int recipeAmount, int invAmount) {
        return invAmount / recipeAmount;
    }

    public static boolean isBucket(Item item) {
        return item == Items.f_42447_ || item == Items.f_42455_;
    }

    public record RecipeUtil(List<ItemStack> inputList, List<ItemStack> resultList, int count) {
        public ItemStack getHand() {
            return this.getInputList().get(0);
        }

        public List<ItemStack> getInputList() {
            return this.inputList;
        }

        public List<ItemStack> getResultList() {
            return this.resultList;
        }

        public int getCount() {
            return this.count;
        }
    }
}

