/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.recipe.base;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class AbstractRecipeSerializer {
    public JsonArray getArray(JsonObject json, String name) {
        return GsonHelper.m_13933_((JsonObject)json, (String)name);
    }

    protected ItemStack readStack(JsonObject jo, String name) {
        JsonArray resultArray = this.getArray(jo, name);
        ItemStack stack = ItemStack.f_41583_;
        for (JsonElement json : resultArray) {
            ItemStack result = this.readJsonResult(json);
            if (result.m_41619_()) continue;
            stack = result;
            break;
        }
        return stack;
    }

    protected int readIntValue(JsonObject jo, int minValue, String name, String type) {
        int craftTime;
        block0: {
            JsonArray resultArray = this.getArray(jo, name);
            craftTime = minValue;
            Iterator iterator = resultArray.iterator();
            if (!iterator.hasNext()) break block0;
            JsonElement json = (JsonElement)iterator.next();
            craftTime = this.readIntValueJson(json, type);
        }
        return craftTime;
    }

    protected List<ItemStack> readResultList(JsonObject jo, String name) {
        JsonArray resultArray = this.getArray(jo, name);
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        resultArray.forEach(r -> list.add(this.readJsonResult((JsonElement)r)));
        return list;
    }

    protected ItemStack readJsonResult(JsonElement je) {
        if (!je.isJsonObject()) {
            throw new JsonSyntaxException("Must be a json object");
        }
        JsonObject json = je.getAsJsonObject();
        String itemId = GsonHelper.m_13906_((JsonObject)json, (String)"item");
        if (itemId.equals("")) {
            return ItemStack.f_41583_;
        }
        int count = GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1);
        return new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId)), count);
    }

    protected List<Ingredient> readIngredList(JsonObject jo, String name) {
        JsonArray resultArray = this.getArray(jo, name);
        ArrayList<Ingredient> list = new ArrayList<Ingredient>();
        resultArray.forEach(r -> list.add(this.readIngred(r.getAsJsonObject())));
        return list;
    }

    protected Ingredient readIngred(JsonObject json) {
        int count = GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1);
        if (json.has("item") && json.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or an item, not both");
        }
        if (json.has("item")) {
            Item item = ShapedRecipe.m_151278_((JsonObject)json);
            return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)item, count)});
        }
        if (json.has("tag")) {
            return Ingredient.m_204132_((TagKey)TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag"))));
        }
        throw new JsonParseException("An ingredient entry needs either a tag or an item");
    }

    protected String readString(JsonObject jo, String name, String type) {
        JsonArray resultArray = this.getArray(jo, name);
        String value = "";
        for (JsonElement json : resultArray) {
            String value2 = this.readStringValueJson(json, type);
            if (value2.isEmpty()) continue;
            value = value2;
            break;
        }
        return value;
    }

    protected List<Integer> readCountList(JsonObject jo, String name) {
        return this.readIntList(jo, name, "count", 1);
    }

    protected List<Integer> readValueList(JsonObject jo, String name) {
        return this.readIntList(jo, name, "value", 1);
    }

    protected List<Integer> readIntList(JsonObject jo, String jName, String name, int value) {
        JsonArray resultArray = this.getArray(jo, jName);
        ArrayList<Integer> list = new ArrayList<Integer>();
        resultArray.forEach(r -> list.add(GsonHelper.m_13824_((JsonObject)r.getAsJsonObject(), (String)name, (int)value)));
        return list;
    }

    protected List<Boolean> readNBTList(JsonObject jo, String name) {
        JsonArray resultArray = this.getArray(jo, name);
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        resultArray.forEach(r -> list.add(GsonHelper.m_13912_((JsonObject)r.getAsJsonObject(), (String)"nbt")));
        return list;
    }

    protected List<Float> readChanceList(JsonObject jo, String name) {
        JsonArray resultArray = this.getArray(jo, name);
        ArrayList<Float> list = new ArrayList<Float>();
        resultArray.forEach(r -> list.add(Float.valueOf(GsonHelper.m_13820_((JsonObject)r.getAsJsonObject(), (String)"chance", (float)1.0f))));
        return list;
    }

    protected int readIntValueJson(JsonElement je, String type) {
        if (!je.isJsonObject()) {
            throw new JsonSyntaxException("Must be a json object");
        }
        return GsonHelper.m_13824_((JsonObject)je.getAsJsonObject(), (String)type, (int)1);
    }

    protected String readStringValueJson(JsonElement je, String type) {
        if (!je.isJsonObject()) {
            throw new JsonSyntaxException("Must be a json object");
        }
        return GsonHelper.m_13906_((JsonObject)je.getAsJsonObject(), (String)type);
    }

    public List<ItemStack> loadStackList(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int k = 0; k < size; ++k) {
            list.add(buf.m_130267_());
        }
        return list;
    }

    public List<Ingredient> loadIngList(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        ArrayList<Ingredient> list = new ArrayList<Ingredient>();
        for (int i = 0; i < size; ++i) {
            list.add(Ingredient.m_43940_((FriendlyByteBuf)buf));
        }
        return list;
    }

    public List<Integer> loadIntList(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            list.add(buf.m_130242_());
        }
        return list;
    }

    public List<Float> loadFltList(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        ArrayList<Float> list = new ArrayList<Float>();
        for (int i = 0; i < size; ++i) {
            list.add(Float.valueOf(buf.readFloat()));
        }
        return list;
    }

    public List<Boolean> loadBlnList(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        for (int i = 0; i < size; ++i) {
            list.add(buf.readBoolean());
        }
        return list;
    }

    public void saveStackList(FriendlyByteBuf buf, List<ItemStack> list) {
        buf.m_130130_(list.size());
        list.forEach(s -> buf.m_130055_(s));
    }

    public void saveIngList(FriendlyByteBuf buf, List<Ingredient> list) {
        buf.m_130130_(list.size());
        list.forEach(t -> t.m_43923_(buf));
    }

    public void saveIntList(FriendlyByteBuf buf, List<Integer> list) {
        buf.m_130130_(list.size());
        list.forEach(i -> buf.m_130130_(i.intValue()));
    }

    public void saveFltList(FriendlyByteBuf buf, List<Float> list) {
        buf.m_130130_(list.size());
        list.forEach(f -> buf.writeFloat(f.floatValue()));
    }

    public void saveBlnList(FriendlyByteBuf buf, List<Boolean> list) {
        buf.m_130130_(list.size());
        list.forEach(b -> buf.writeBoolean(b.booleanValue()));
    }
}

