/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.recipe.trade;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import sweetmagic.recipe.base.AbstractRecipeSerializer;
import sweetmagic.recipe.trade.TradeRecipe;

public class TradeRecipeSeria
extends AbstractRecipeSerializer
implements RecipeSerializer<TradeRecipe> {
    public TradeRecipe fromJson(ResourceLocation id, JsonObject json) {
        String type = this.readString(json, "ingredients", "type");
        List<Ingredient> resultList = this.readIngredList(json, "result");
        List<Integer> countList = this.readCountList(json, "result");
        List<Integer> valueList = this.readValueList(json, "result");
        return new TradeRecipe(id, type, resultList, countList, valueList);
    }

    @Nullable
    public TradeRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        String tradeType = buf.m_130277_();
        List<Ingredient> resultList = this.loadIngList(buf);
        List<Integer> countList = this.loadIntList(buf);
        List<Integer> valueList = this.loadIntList(buf);
        return new TradeRecipe(id, tradeType, resultList, countList, valueList);
    }

    public void toNetwork(FriendlyByteBuf buf, TradeRecipe recipe) {
        buf.m_130070_(recipe.getTradeType());
        this.saveIngList(buf, recipe.getIngredList());
        this.saveIntList(buf, recipe.getCountList());
        this.saveIntList(buf, recipe.getValueList());
    }
}

