/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.recipe.woodcutter;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import sweetmagic.recipe.base.AbstractRecipeSerializer;
import sweetmagic.recipe.woodcutter.WoodCutterRecipe;

public class WoodCutterRecipeSeria
extends AbstractRecipeSerializer
implements RecipeSerializer<WoodCutterRecipe> {
    public WoodCutterRecipe fromJson(ResourceLocation id, JsonObject json) {
        List<ItemStack> resultList = this.readResultList(json, "result");
        List<Ingredient> ingredList = this.readIngredList(json, "ingredients");
        List<Integer> countList = this.readCountList(json, "ingredients");
        List<Integer> minList = this.readIntList(json, "result", "min", 0);
        List<Integer> maxList = this.readIntList(json, "result", "max", 0);
        int mf = this.readIntValue(json, 200, "request", "mf");
        return new WoodCutterRecipe(id, resultList, ingredList, countList, minList, maxList, mf);
    }

    @Nullable
    public WoodCutterRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        List<ItemStack> resultList = this.loadStackList(buf);
        List<Ingredient> ingredList = this.loadIngList(buf);
        List<Integer> countList = this.loadIntList(buf);
        List<Integer> minList = this.loadIntList(buf);
        List<Integer> maxList = this.loadIntList(buf);
        int mf = buf.m_130242_();
        return new WoodCutterRecipe(id, resultList, ingredList, countList, minList, maxList, mf);
    }

    public void toNetwork(FriendlyByteBuf buf, WoodCutterRecipe recipe) {
        this.saveStackList(buf, recipe.getResultList());
        this.saveIngList(buf, recipe.getIngredList());
        this.saveIntList(buf, recipe.getCountList());
        this.saveIntList(buf, recipe.getMinList());
        this.saveIntList(buf, recipe.getMaxList());
        buf.m_130130_(recipe.getMF());
    }
}

