/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.util;

import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import sweetmagic.api.iitem.IPorch;
import sweetmagic.init.ItemInit;

public class PlayerHelper {
    public static void setPotion(LivingEntity target, MobEffect effect, int level, int time) {
        Item item;
        target.m_21195_(effect);
        ItemStack leg = target.m_6844_(EquipmentSlot.LEGS);
        if (!leg.m_41619_() && (item = leg.m_41720_()) instanceof IPorch) {
            boolean isBadEffect;
            IPorch porch = (IPorch)item;
            int count = porch.acceCount(leg, ItemInit.pendulum_necklace, 4);
            boolean bl = isBadEffect = effect.m_19483_() == MobEffectCategory.HARMFUL;
            if (count > 0) {
                time = (int)((float)time * (!isBadEffect ? 1.0f + (float)count * 0.25f : 1.0f - (float)count * 0.125f));
            }
        }
        target.m_7292_(new MobEffectInstance(effect, time, level, true, false));
    }

    public static void setPotion(LivingEntity target, MobEffect effect, int level, int time, boolean flag) {
        Item item;
        target.m_21195_(effect);
        ItemStack leg = target.m_6844_(EquipmentSlot.LEGS);
        if (!leg.m_41619_() && (item = leg.m_41720_()) instanceof IPorch) {
            boolean isBadEffect;
            IPorch porch = (IPorch)item;
            int count = porch.acceCount(leg, ItemInit.pendulum_necklace, 4);
            boolean bl = isBadEffect = effect.m_19483_() == MobEffectCategory.HARMFUL;
            if (count > 0) {
                time = (int)((float)time * (!isBadEffect ? 1.0f + (float)count * 0.25f : 1.0f - (float)count * 0.125f));
            }
        }
        target.m_7292_(new MobEffectInstance(effect, time, level));
    }

    public static void addExp(Player player, int amount) {
        player.f_36079_ += amount;
        player.f_36078_ = PlayerHelper.getLevelForExp(player.f_36079_);
        player.f_36079_ = Math.max(0, player.f_36079_);
        player.f_36080_ = -((float)(PlayerHelper.getExpForLevel(player.f_36078_) - player.f_36079_)) / (float)player.m_36323_();
    }

    public static int getExpValue(Player player) {
        return (int)((float)PlayerHelper.getExpForLevel(player.f_36078_) + player.f_36080_ * (float)player.m_36323_());
    }

    public static int getLevelForExp(int exp) {
        int level = 0;
        while (PlayerHelper.getExpForLevel(level) <= exp) {
            ++level;
        }
        return Math.max(0, level - 1);
    }

    public static int getExpForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level > 0 && level < 17) {
            return level * level + 6 * level;
        }
        if (level > 16 && level < 32) {
            return (int)(2.5f * (float)level * (float)level - 40.5f * (float)level + 360.0f);
        }
        return (int)(4.5f * (float)level * (float)level - 162.5f * (float)level + 2220.0f);
    }

    public static int getLevelForExperience(int exp) {
        int level = 0;
        while (PlayerHelper.getExpForLevel(level) <= exp) {
            ++level;
        }
        return level - 1;
    }

    public static List<MobEffectInstance> getEffectList(LivingEntity entity, MobEffectCategory cate) {
        return entity.m_21220_().stream().filter(p -> p.m_19544_().m_19483_() == cate).toList();
    }

    public static boolean checkClearAdvanced(Player player, ResourceLocation ... advancedArray) {
        return PlayerHelper.checkClearAdvanced(player, List.of(advancedArray));
    }

    public static boolean checkClearAdvanced(Player player, Iterable<ResourceLocation> advancedList) {
        if (player.m_9236_().m_5776_() || !(player instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        for (ResourceLocation advanced : advancedList) {
            Advancement adv = sPlayer.m_9236_().m_7654_().m_129889_().m_136041_(advanced);
            if (adv != null && sPlayer.m_8960_().m_135996_(adv).m_8193_()) continue;
            return false;
        }
        return true;
    }
}

