/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ForgeHooksClient;
import sweetmagic.init.tile.sm.TileAbstractSM;

public class RenderUtil {
    public static void renderItem(RenderInfo info, TileAbstractSM tile, ItemStack stack, double x, double y, double z) {
        RenderUtil.renderItem(info, tile, stack, x, y, z, 1.0f, false);
    }

    public static void renderItem(RenderInfo info, TileAbstractSM tile, ItemStack stack, double x, double y, double z, float rate, boolean isBlock) {
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_85845_(Vector3f.f_122225_.m_122240_(tile.getRot()));
        switch (tile.getFace()) {
            case SOUTH: {
                pose.m_85837_(-1.0, 0.0, -1.0);
                break;
            }
            case WEST: {
                pose.m_85837_(-1.0, 0.0, 0.0);
                break;
            }
            case EAST: {
                pose.m_85837_(0.0, 0.0, -1.0);
            }
        }
        if (!isBlock && stack.m_41720_() instanceof BlockItem) {
            pose.m_85841_(0.5f, 0.5f, 0.5f);
            pose.m_85837_(x, y, z);
            pose.m_85837_(-0.325, -y / 3.3, -0.5);
        } else {
            float scale = 0.375f * rate;
            pose.m_85841_(scale, scale, scale);
            pose.m_85837_(x, y, z);
        }
        info.render().m_174269_(stack, ItemTransforms.TransformType.FIXED, info.light(), info.overlay(), pose, info.buf(), 0);
        pose.m_85849_();
    }

    public static void renderBlock(RenderInfo info, RenderColor color, Block block) {
        RenderUtil.renderBlock(info.pose(), info.buf(), color, block);
    }

    public static void renderBlock(PoseStack pose, MultiBufferSource buf, RenderColor color, Block block) {
        Minecraft mc = Minecraft.m_91087_();
        BlockState state = block.m_49966_();
        VertexConsumer vert = buf.m_6299_(RenderType.m_110463_()).m_85950_(0.0f, 0.0f, 0.0f, 1.0f);
        ModelBlockRenderer render = new ModelBlockRenderer(mc.m_91298_());
        BakedModel model = mc.m_91289_().m_110910_(state);
        render.m_111067_(pose.m_85850_(), vert, state, model, color.red(), color.green(), color.blue(), color.light(), color.overlayLight());
    }

    public static void renderTransBlock(PoseStack pose, MultiBufferSource buf, RenderColor renderColor, Block block) {
        RenderUtil.renderTransBlock(pose, buf, renderColor, block.m_49966_());
    }

    public static void renderTransBlock(PoseStack pose, MultiBufferSource buf, RenderColor renderColor, BlockState state) {
        Minecraft mc = Minecraft.m_91087_();
        VertexConsumer vert = buf.m_6299_(RenderType.m_110466_()).m_85950_(0.0f, 0.0f, 0.0f, 1.0f);
        ModelBlockRenderer render = new ModelBlockRenderer(mc.m_91298_());
        BakedModel model = mc.m_91289_().m_110910_(state);
        render.m_111067_(pose.m_85850_(), vert, state, model, renderColor.red(), renderColor.green(), renderColor.blue(), renderColor.light(), renderColor.overlayLight());
    }

    public static void renderTransBlock(PoseStack pose, MultiBufferSource buf, RenderColor color, BlockState state, float alpha) {
        Minecraft mc = Minecraft.m_91087_();
        VertexConsumer ver = buf.m_6299_(RenderType.m_110466_()).m_85950_(0.0f, 0.0f, 0.0f, 1.0f);
        BakedModel model = mc.m_91289_().m_110910_(state);
        int light = color.light();
        int over = color.overlayLight();
        for (Direction face : Direction.values()) {
            List quadList = model.m_213637_(state, face, RandomSource.m_216335_((long)Mth.m_14130_((int)1, (int)1, (int)1)));
            for (BakedQuad quad : quadList) {
                boolean flag = quad.m_111304_();
                float f = flag ? 0.0f : 1.0f;
                float f1 = flag ? 0.0f : 1.0f;
                float f2 = flag ? 0.0f : 1.0f;
                ver.putBulkData(pose.m_85850_(), quad, f, f1, f2, alpha, light, over, true);
            }
        }
    }

    public static void renderBlock(Level world, BlockPos pos, BlockState state, BlockRenderDispatcher render, PoseStack pose, MultiBufferSource buf, int overlay) {
        ForgeHooksClient.renderPistonMovedBlocks((BlockPos)pos, (BlockState)state, (PoseStack)pose, (MultiBufferSource)buf, (Level)world, (boolean)false, (int)overlay, (BlockRenderDispatcher)render);
    }

    public record RenderInfo(ItemRenderer render, int light, int overlay, PoseStack pose, MultiBufferSource buf) {
        public void itemRender(ItemStack stack) {
            this.render().m_174269_(stack, ItemTransforms.TransformType.FIXED, this.light(), this.overlay(), this.pose(), this.buf(), 0);
        }

        public void itemRenderNo(ItemStack stack) {
            this.render().m_174269_(stack, ItemTransforms.TransformType.FIXED, this.light(), OverlayTexture.f_118083_, this.pose(), this.buf(), 0);
        }
    }

    public record RenderColor(float red, float green, float blue, int light, int overlayLight) {
        public static RenderColor create(int light) {
            return new RenderColor(1.0f, 1.0f, 1.0f, light, OverlayTexture.f_118083_);
        }

        public static RenderColor create(RenderInfo info) {
            return new RenderColor(1.0f, 1.0f, 1.0f, info.light(), OverlayTexture.f_118083_);
        }

        public static RenderColor create(float red, float green, float blue, RenderInfo info) {
            return new RenderColor(red / 255.0f, blue / 255.0f, green / 255.0f, info.light(), info.overlay());
        }
    }

    public record RGBColor(int red, int green, int blue) {
    }
}

