/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.util;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.AABB;
import sweetmagic.util.ItemHelper;

public class WorldHelper {
    public static boolean isPeace(LevelAccessor world) {
        return world.m_46791_() == Difficulty.PEACEFUL;
    }

    public static void createLootDrop(List<ItemStack> drops, Level world, double x, double y, double z) {
        if (drops.isEmpty()) {
            return;
        }
        ItemHelper.compactItemListNoStacksize(drops);
        drops.forEach(d -> world.m_7967_((Entity)new ItemEntity(world, x, y, z, d)));
    }

    public static Structure getStructureKey(ServerLevel world, ResourceLocation key) {
        return (Structure)WorldHelper.getStructureRegistry(world).m_7745_(key);
    }

    private static Registry<Structure> getStructureRegistry(ServerLevel world) {
        return world.m_5962_().m_206191_(Registry.f_235725_);
    }

    public static Holder<Structure> getStructure(ServerLevel world, Structure struc) {
        Registry<Structure> strReg = WorldHelper.getStructureRegistry(world);
        Optional str = strReg.m_7854_((Object)struc);
        return str.isPresent() ? strReg.m_206081_((ResourceKey)str.get()) : null;
    }

    public static Iterable<BlockPos> getRangePos(BlockPos pos, double area) {
        return WorldHelper.getRangePos(pos, -area, -area, -area, area, area, area);
    }

    public static Iterable<BlockPos> getRangePos(BlockPos pos, double xA, double yA, double zA, double xB, double yB, double zB) {
        return BlockPos.m_121940_((BlockPos)WorldHelper.offset(pos, xA, yA, zA), (BlockPos)WorldHelper.offset(pos, xB, yB, zB));
    }

    public static <T extends Entity> List<T> getEntityList(Entity entity, Class<T> enClass, AABB aabb) {
        return entity.m_9236_().m_45976_(enClass, aabb);
    }

    public static <T extends Entity> List<T> getEntityList(Level world, Class<T> enClass, AABB aabb) {
        return world.m_45976_(enClass, aabb);
    }

    public static <T extends Entity> List<T> getEntityList(Entity entity, Class<T> enClass, Predicate<T> filter, AABB aabb) {
        return entity.m_9236_().m_45976_(enClass, aabb).stream().filter(filter).toList();
    }

    public static <T extends Entity> List<T> getEntityList(Level world, Class<T> enClass, Predicate<T> filter, AABB aabb) {
        return world.m_45976_(enClass, aabb).stream().filter(filter).toList();
    }

    public static BlockPos offset(BlockPos pos, double x, double y, double z) {
        return new BlockPos((double)pos.m_123341_() + x, (double)pos.m_123342_() + y, (double)pos.m_123343_() + z);
    }

    public static AABB getAABB(BlockPos pos, double range) {
        return new AABB(WorldHelper.offset(pos, -range, -range, -range), WorldHelper.offset(pos, range, range, range));
    }

    public static AABB getAABB(BlockPos pos, double x, double y, double z) {
        return new AABB(WorldHelper.offset(pos, -x, -y, -z), WorldHelper.offset(pos, x, y, z));
    }
}

