/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.worldgen.flower;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.registries.DeferredRegister;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.iblock.ISMCrop;
import sweetmagic.config.SMConfig;
import sweetmagic.init.BlockInit;
import sweetmagic.init.block.sm.SMFlowerDiff;
import sweetmagic.worldgen.flower.FlowerGurdenModifier;
import sweetmagic.worldgen.flower.FlowerModifier;
import sweetmagic.worldgen.flower.FruitModifier;
import sweetmagic.worldgen.flower.MoonModifier;
import sweetmagic.worldgen.flower.PrismModifier;
import sweetmagic.worldgen.flower.SugarModifier;

public class SMFlowerGen {
    private static final Map<String, ResourceKey<PlacedFeature>> keyMap = new HashMap<String, ResourceKey<PlacedFeature>>();
    public static final SimpleBlockConfiguration SUGAR = new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((BlockState)BlockInit.sugarbell_plant.m_49966_().m_61124_((Property)ISMCrop.AGE3, (Comparable)Integer.valueOf(3))), 10).m_146271_((Object)((BlockState)BlockInit.glowflower_plant.m_49966_().m_61124_((Property)ISMCrop.AGE3, (Comparable)Integer.valueOf(3))), 5).m_146271_((Object)((BlockState)BlockInit.sannyflower_plant.m_49966_().m_61124_((Property)ISMCrop.AGE3, (Comparable)Integer.valueOf(2))), 2).m_146271_((Object)((BlockState)BlockInit.raspberry_plant.m_49966_().m_61124_((Property)ISMCrop.AGE5, (Comparable)Integer.valueOf(5))), 1).m_146271_((Object)((BlockState)BlockInit.mint_plant.m_49966_().m_61124_((Property)ISMCrop.AGE3, (Comparable)Integer.valueOf(3))), 1).m_146270_()));
    public static final SimpleBlockConfiguration MOON = new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((BlockState)BlockInit.moonblossom_plant.m_49966_().m_61124_((Property)ISMCrop.AGE3, (Comparable)Integer.valueOf(2))), 5).m_146271_((Object)((BlockState)BlockInit.drizzly_mysotis_plant.m_49966_().m_61124_((Property)ISMCrop.AGE3, (Comparable)Integer.valueOf(2))), 5).m_146270_()));
    public static final SimpleBlockConfiguration PRISM = new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)BlockInit.snowdrop.m_49966_(), 2).m_146271_((Object)((BlockState)BlockInit.glowflower_plant.m_49966_().m_61124_((Property)ISMCrop.AGE3, (Comparable)Integer.valueOf(3))), 3).m_146271_((Object)((BlockState)BlockInit.sannyflower_plant.m_49966_().m_61124_((Property)ISMCrop.AGE3, (Comparable)Integer.valueOf(2))), 3).m_146271_((Object)((BlockState)BlockInit.fire_nasturtium_plant.m_49966_().m_61124_((Property)ISMCrop.AGE3, (Comparable)Integer.valueOf(3))), 3).m_146271_((Object)((BlockState)BlockInit.clerodendrum_plant.m_49966_().m_61124_((Property)ISMCrop.AGE3, (Comparable)Integer.valueOf(3))), 3).m_146271_((Object)((BlockState)BlockInit.mint_plant.m_49966_().m_61124_((Property)ISMCrop.AGE3, (Comparable)Integer.valueOf(3))), 3).m_146271_((Object)((BlockState)BlockInit.cotton_plant.m_49966_().m_61124_((Property)ISMCrop.AGE3, (Comparable)Integer.valueOf(3))), 3).m_146270_()));
    public static final SimpleBlockConfiguration FRUIT = new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((BlockState)BlockInit.blueberry_plant.m_49966_().m_61124_((Property)ISMCrop.AGE4, (Comparable)Integer.valueOf(4))), 3).m_146271_((Object)((BlockState)BlockInit.olive_plant.m_49966_().m_61124_((Property)ISMCrop.AGE4, (Comparable)Integer.valueOf(4))), 3).m_146270_()));
    public static final SimpleBlockConfiguration WHITE = new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((BlockState)BlockInit.whitenet_plant.m_49966_().m_61124_((Property)ISMCrop.AGE3, (Comparable)Integer.valueOf(3))), 5).m_146270_()));
    public static final SimpleBlockConfiguration FLOWER = new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((BlockState)BlockInit.cornflower.m_49966_().m_61124_((Property)SMFlowerDiff.SIZE, (Comparable)Integer.valueOf(0))), 5).m_146271_((Object)((BlockState)BlockInit.cornflower.m_49966_().m_61124_((Property)SMFlowerDiff.SIZE, (Comparable)Integer.valueOf(1))), 5).m_146271_((Object)((BlockState)BlockInit.lily_valley.m_49966_().m_61124_((Property)SMFlowerDiff.SIZE, (Comparable)Integer.valueOf(0))), 5).m_146271_((Object)((BlockState)BlockInit.lily_valley.m_49966_().m_61124_((Property)SMFlowerDiff.SIZE, (Comparable)Integer.valueOf(1))), 5).m_146271_((Object)BlockInit.cosmos.m_49966_(), 10).m_146271_((Object)BlockInit.blackrose.m_49966_(), 10).m_146271_((Object)((BlockState)BlockInit.white_clover.m_49966_().m_61124_((Property)SMFlowerDiff.SIZE, (Comparable)Integer.valueOf(0))), 4).m_146271_((Object)((BlockState)BlockInit.white_clover.m_49966_().m_61124_((Property)SMFlowerDiff.SIZE, (Comparable)Integer.valueOf(1))), 3).m_146271_((Object)((BlockState)BlockInit.white_clover.m_49966_().m_61124_((Property)SMFlowerDiff.SIZE, (Comparable)Integer.valueOf(2))), 3).m_146271_((Object)BlockInit.foxtail_grass.m_49966_(), 10).m_146271_((Object)BlockInit.snowdrop.m_49966_(), 10).m_146271_((Object)BlockInit.turkey_balloonflower.m_49966_(), 10).m_146271_((Object)BlockInit.iberis_umbellata.m_49966_(), 10).m_146271_((Object)BlockInit.ultramarine_rose.m_49966_(), 10).m_146271_((Object)BlockInit.solid_star.m_49966_(), 10).m_146271_((Object)BlockInit.zinnia.m_49966_(), 10).m_146271_((Object)BlockInit.campanula.m_49966_(), 10).m_146271_((Object)BlockInit.primula_polyansa.m_49966_(), 10).m_146271_((Object)((BlockState)BlockInit.hydrangea.m_49966_().m_61124_((Property)SMFlowerDiff.SIZE, (Comparable)Integer.valueOf(0))), 4).m_146271_((Object)((BlockState)BlockInit.hydrangea.m_49966_().m_61124_((Property)SMFlowerDiff.SIZE, (Comparable)Integer.valueOf(1))), 3).m_146271_((Object)((BlockState)BlockInit.hydrangea.m_49966_().m_61124_((Property)SMFlowerDiff.SIZE, (Comparable)Integer.valueOf(2))), 3).m_146271_((Object)BlockInit.carnation_crayola.m_49966_(), 10).m_146271_((Object)BlockInit.christmas_rose.m_49966_(), 10).m_146271_((Object)BlockInit.portulaca.m_49966_(), 10).m_146271_((Object)BlockInit.surfinia.m_49966_(), 10).m_146271_((Object)((BlockState)BlockInit.pansy_blue.m_49966_().m_61124_((Property)SMFlowerDiff.SIZE, (Comparable)Integer.valueOf(0))), 4).m_146271_((Object)((BlockState)BlockInit.pansy_blue.m_49966_().m_61124_((Property)SMFlowerDiff.SIZE, (Comparable)Integer.valueOf(1))), 3).m_146271_((Object)((BlockState)BlockInit.pansy_blue.m_49966_().m_61124_((Property)SMFlowerDiff.SIZE, (Comparable)Integer.valueOf(2))), 3).m_146271_((Object)BlockInit.pansy_yellowmazenta.m_49966_(), 10).m_146271_((Object)BlockInit.marigold.m_49966_(), 10).m_146271_((Object)BlockInit.christmarose_ericsmithii.m_49966_(), 10).m_146270_()));

    public static void register(DeferredRegister<BiomeModifier> register) {
        GenerationStep.Decoration dec = GenerationStep.Decoration.VEGETAL_DECORATION;
        register.register("plain_flower", () -> new SugarModifier(dec, SMFlowerGen.registerPlace("plain_flower", SUGAR, (Integer)SMConfig.plainFlowerChance.get())));
        register.register("forest_flower", () -> new MoonModifier(dec, SMFlowerGen.registerPlace("forest_flower", MOON, (Integer)SMConfig.forestFlowerChance.get())));
        register.register("flower_flower", () -> new FlowerModifier(dec, SMFlowerGen.registerPlace("flower_flower", FLOWER, (Integer)SMConfig.flowerFlowerChance.get())));
        register.register("prism_flower", () -> new PrismModifier(dec, SMFlowerGen.registerPlace("prism_flower", PRISM, 6)));
        register.register("fruit_flower", () -> new FruitModifier(dec, SMFlowerGen.registerPlace("fruit_flower", FRUIT, 5)));
        register.register("garden_flower", () -> new FlowerGurdenModifier(dec, SMFlowerGen.registerPlace("garden_flower", FLOWER, 100)));
    }

    public static final Holder<PlacedFeature> registerPlace(String name, SimpleBlockConfiguration config, int chance) {
        return SMFlowerGen.register(SweetMagicCore.getSRC(name), SMFlowerGen.register(SweetMagicCore.getSRC(name), Feature.f_65763_, FeatureUtils.m_206470_((int)6, (Holder)PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)config))), new PlacementModifier[]{CountPlacement.m_191628_((int)chance), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> Holder<ConfiguredFeature<FC, ?>> register(ResourceLocation id, F feature, FC config) {
        return SMFlowerGen.badRegister(BuiltinRegistries.f_123861_, id, new ConfiguredFeature(feature, config));
    }

    public static <V extends T, T> Holder<V> badRegister(Registry<T> registry, ResourceLocation id, V value) {
        return BuiltinRegistries.m_206388_(registry, (ResourceLocation)id, value);
    }

    public static Holder<PlacedFeature> register(ResourceLocation id, Holder<? extends ConfiguredFeature<?, ?>> feature, List<PlacementModifier> mod) {
        keyMap.put(id.m_135815_(), (ResourceKey<PlacedFeature>)ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)id));
        return BuiltinRegistries.m_206388_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)id, (Object)new PlacedFeature(Holder.m_205706_(feature), List.copyOf(mod)));
    }

    public static Holder<PlacedFeature> register(ResourceLocation id, Holder<? extends ConfiguredFeature<?, ?>> feature, PlacementModifier ... mod) {
        return SMFlowerGen.register(id, feature, List.of(mod));
    }

    public static ResourceKey<PlacedFeature> getFeatureKey(String key) {
        return keyMap.get(key);
    }
}

