/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.worldgen.ore;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.RegistryObject;
import sweetmagic.init.TagInit;
import sweetmagic.worldgen.flower.BaseModifier;

public record CSOreModifier(GenerationStep.Decoration step, Holder<PlacedFeature> feature) implements BiomeModifier
{
    public static final RegistryObject<Codec<? extends BiomeModifier>> OREMOD = BaseModifier.getModifier("cssmores");
    private static List<TagKey<Biome>> biomeTagList = Arrays.asList(TagInit.IS_SWEETMAGIC);

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder build) {
        if (BaseModifier.is(biome, biomeTagList)) {
            BaseModifier.addFeature(phase, build, this.step, this.feature);
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)OREMOD.get();
    }

    public static Codec<CSOreModifier> makeCodec() {
        return RecordCodecBuilder.create(build -> build.group((App)Codec.STRING.comapFlatMap(CSOreModifier::generationStageFromString, Enum::toString).fieldOf("generation_stage").forGetter(CSOreModifier::step), (App)PlacedFeature.f_191773_.fieldOf("feature").forGetter(CSOreModifier::feature)).apply((Applicative)build, CSOreModifier::new));
    }

    private static DataResult<GenerationStep.Decoration> generationStageFromString(String name) {
        return BaseModifier.generatResult(name);
    }
}

