/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.worldgen.ore;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.registries.DeferredRegister;
import sweetmagic.init.BlockInit;
import sweetmagic.worldgen.ore.CSOreModifier;
import sweetmagic.worldgen.ore.OreModifier;

public class SMOreGen {
    public static final List<OreConfiguration.TargetBlockState> ORE_AETHER = SMOreGen.getOreList(BlockInit.aether_crystal_ore, BlockInit.deep_aether_crystal_ore);
    public static final List<OreConfiguration.TargetBlockState> ORE_COSMIC = SMOreGen.getOreList(BlockInit.cosmic_crystal_ore, BlockInit.deep_cosmic_crystal_ore);
    public static final List<OreConfiguration.TargetBlockState> ORE_FLUORITE = SMOreGen.getOreList(BlockInit.fluorite_ore, BlockInit.deep_fluorite_ore);
    public static final List<OreConfiguration.TargetBlockState> ORE_REDBERYL = SMOreGen.getOreList(BlockInit.redberyl_ore, BlockInit.deep_redberyl_ore);
    public static final Holder<PlacedFeature> ORE_AE_SMALL = SMOreGen.getPlace("ore_ae_sm", ORE_AETHER, 4, 0.3f, SMOreGen.getOreMod(6, SMOreGen.absolute(10), SMOreGen.absolute(30)));
    public static final Holder<PlacedFeature> ORE_AE_LARGE = SMOreGen.getPlace("ore_ae_la", ORE_AETHER, 12, 0.45f, SMOreGen.getOreMod(8, SMOreGen.absolute(-20), SMOreGen.absolute(60)));
    public static final Holder<PlacedFeature> ORE_AE_BURIED = SMOreGen.getPlace("ore_ae_bu", ORE_AETHER, 8, 0.75f, SMOreGen.getOreMod(6, SMOreGen.aboveBottom(-80), SMOreGen.aboveBottom(40)));
    public static final Holder<PlacedFeature> ORE_CS_SMALL = SMOreGen.getPlace("ore_cs_sm", ORE_COSMIC, 2, 0.3f, SMOreGen.getOreMod(3, SMOreGen.absolute(10), SMOreGen.absolute(30)));
    public static final Holder<PlacedFeature> ORE_CS_LARGE = SMOreGen.getPlace("ore_cs_la", ORE_COSMIC, 6, 0.45f, SMOreGen.getOreMod(4, SMOreGen.absolute(-20), SMOreGen.absolute(60)));
    public static final Holder<PlacedFeature> ORE_CS_BURIED = SMOreGen.getPlace("ore_cs_bu", ORE_COSMIC, 4, 0.75f, SMOreGen.getOreMod(2, SMOreGen.aboveBottom(-80), SMOreGen.aboveBottom(40)));
    public static final Holder<PlacedFeature> ORE_FR_SMALL = SMOreGen.getPlace("ore_fr_sm", ORE_FLUORITE, 3, 0.4f, SMOreGen.getOreMod(5, SMOreGen.absolute(20), SMOreGen.absolute(40)));
    public static final Holder<PlacedFeature> ORE_FR_LARGE = SMOreGen.getPlace("ore_fr_la", ORE_FLUORITE, 9, 0.6f, SMOreGen.getOreMod(7, SMOreGen.absolute(-30), SMOreGen.absolute(50)));
    public static final Holder<PlacedFeature> ORE_FR_BURIED = SMOreGen.getPlace("ore_fr_bu", ORE_FLUORITE, 6, 0.85f, SMOreGen.getOreMod(4, SMOreGen.aboveBottom(-90), SMOreGen.aboveBottom(30)));
    public static final Holder<PlacedFeature> ORE_RB_SMALL = SMOreGen.getPlace("ore_fb_sm", ORE_REDBERYL, 2, 0.35f, SMOreGen.getOreMod(4, SMOreGen.absolute(0), SMOreGen.absolute(30)));
    public static final Holder<PlacedFeature> ORE_RB_LARGE = SMOreGen.getPlace("ore_fb_la", ORE_REDBERYL, 6, 0.5f, SMOreGen.getOreMod(5, SMOreGen.absolute(-40), SMOreGen.absolute(40)));
    public static final Holder<PlacedFeature> ORE_RB_BURIED = SMOreGen.getPlace("ore_fb_bu", ORE_REDBERYL, 4, 0.8f, SMOreGen.getOreMod(3, SMOreGen.aboveBottom(-100), SMOreGen.aboveBottom(20)));

    public static void register(DeferredRegister<BiomeModifier> biome) {
        SMOreGen.register("ore_ae_small", biome, ORE_AE_SMALL, 0);
        SMOreGen.register("ore_ae_large", biome, ORE_AE_LARGE, 0);
        SMOreGen.register("ore_ae_buried", biome, ORE_AE_BURIED, 0);
        SMOreGen.register("ore_cs_small", biome, ORE_CS_SMALL, 1);
        SMOreGen.register("ore_cs_large", biome, ORE_CS_LARGE, 1);
        SMOreGen.register("ore_cs_buried", biome, ORE_CS_BURIED, 1);
        SMOreGen.register("ore_fr_small", biome, ORE_FR_SMALL, 1);
        SMOreGen.register("ore_fr_large", biome, ORE_FR_LARGE, 1);
        SMOreGen.register("ore_fr_buried", biome, ORE_FR_BURIED, 1);
        SMOreGen.register("ore_rb_small", biome, ORE_RB_SMALL, 1);
        SMOreGen.register("ore_rb_large", biome, ORE_RB_LARGE, 1);
        SMOreGen.register("ore_rb_buried", biome, ORE_RB_BURIED, 1);
    }

    public static void register(String name, DeferredRegister<BiomeModifier> biome, Holder<PlacedFeature> place, int data) {
        SMOreGen.register(name, biome, switch (data) {
            case 1 -> new CSOreModifier(GenerationStep.Decoration.UNDERGROUND_ORES, place);
            default -> new OreModifier(GenerationStep.Decoration.UNDERGROUND_ORES, place);
        });
    }

    public static void register(String name, DeferredRegister<BiomeModifier> biome, BiomeModifier mod) {
        biome.register(name, () -> mod);
    }

    public static List<OreConfiguration.TargetBlockState> getOreList(Block ore, Block deepOre) {
        return List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)ore.m_49966_()), OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)deepOre.m_49966_()));
    }

    public static Holder<PlacedFeature> getPlace(String name, List<OreConfiguration.TargetBlockState> oreList, int size, float chance, List<PlacementModifier> placeMod) {
        Holder featuer = FeatureUtils.m_206488_((String)(name + "_fe"), (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(oreList, size, chance));
        return PlacementUtils.m_206509_((String)name, (Holder)featuer, placeMod);
    }

    public static List<PlacementModifier> orePlacement(PlacementModifier count, PlacementModifier place) {
        return List.of(count, InSquarePlacement.m_191715_(), place, BiomeFilter.m_191561_());
    }

    public static List<PlacementModifier> getOreMod(int count, VerticalAnchor ver1, VerticalAnchor ver2) {
        return SMOreGen.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)count), (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)ver1, (VerticalAnchor)ver2));
    }

    public static VerticalAnchor absolute(int y) {
        return VerticalAnchor.m_158922_((int)y);
    }

    public static VerticalAnchor aboveBottom(int y) {
        return VerticalAnchor.m_158930_((int)y);
    }
}

