/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.worldgen.tree.featuer;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Material;
import sweetmagic.init.BlockInit;
import sweetmagic.worldgen.tree.featuer.AbstractTreeFeatuer;

public class MagiaFeature
extends AbstractTreeFeatuer {
    public int height = 10;
    public int randHeight = 1;
    private static final EnumProperty<Direction.Axis> AXIS = RotatedPillarBlock.f_55923_;

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> con) {
        int k;
        int i;
        BlockPos pos = con.m_159777_();
        WorldGenLevel world = con.m_159774_();
        if (!this.checkBlock(world.m_8055_(pos.m_7495_()).m_60734_())) {
            return false;
        }
        for (int y = 1; y <= 8; ++y) {
            Material mate = world.m_8055_(pos.m_6630_(y)).m_60767_();
            if (mate == Material.f_76296_ || mate != Material.f_76300_) continue;
            return false;
        }
        int maxHeight = world.m_213780_().m_188503_(this.randHeight) + this.height;
        BlockState log = this.getLog();
        BlockState leave = this.getLeave();
        this.subTrunk(world, pos.m_122012_(), log, Direction.NORTH);
        this.subTrunk(world, pos.m_122019_(), log, Direction.SOUTH);
        this.subTrunk(world, pos.m_122024_(), log, Direction.WEST);
        this.subTrunk(world, pos.m_122029_(), log, Direction.EAST);
        for (int y = 0; y < maxHeight; ++y) {
            this.setBlock(world, pos.m_6630_(y), log);
        }
        this.setBlock(world, pos.m_7918_(0, maxHeight, -1), (BlockState)log.m_61124_(AXIS, (Comparable)Direction.Axis.Z));
        this.setBlock(world, pos.m_7918_(0, maxHeight, 1), (BlockState)log.m_61124_(AXIS, (Comparable)Direction.Axis.Z));
        this.setBlock(world, pos.m_7918_(-1, maxHeight, 0), (BlockState)log.m_61124_(AXIS, (Comparable)Direction.Axis.X));
        this.setBlock(world, pos.m_7918_(1, maxHeight, 0), (BlockState)log.m_61124_(AXIS, (Comparable)Direction.Axis.X));
        BlockPos top = pos.m_7918_(0, maxHeight - 4, 0);
        for (i = -2; i <= 2; ++i) {
            for (k = -2; k <= 2; ++k) {
                this.setBlock(world, top.m_7918_(i, 0, k), leave);
            }
        }
        this.setSubLeave(world, top, 3, leave);
        for (i = -3; i <= 3; ++i) {
            for (k = -2; k <= 2; ++k) {
                this.setBlock(world, top.m_7918_(i, 1, k), leave);
                this.setBlock(world, top.m_7918_(k, 1, i), leave);
            }
        }
        this.setSubLeave(world, top.m_6630_(1), 4, leave);
        for (i = -3; i <= 3; ++i) {
            for (k = -1; k <= 1; ++k) {
                this.setBlock(world, top.m_7918_(i, 2, k), leave);
                this.setBlock(world, top.m_7918_(k, 2, i), leave);
            }
        }
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                for (int y = 0; y <= 1; ++y) {
                    this.setBlock(world, top.m_7918_(x, y + 2, z), leave);
                }
            }
        }
        this.setSubLeave(world, top.m_6630_(3), 3, leave);
        for (i = -2; i <= 2; ++i) {
            for (k = -1; k <= 1; ++k) {
                this.setBlock(world, top.m_7918_(i, 4, k), leave);
                this.setBlock(world, top.m_7918_(k, 4, i), leave);
            }
        }
        for (i = -1; i <= 1; ++i) {
            for (k = -1; k <= 1; ++k) {
                this.setBlock(world, top.m_7918_(i, 5, k), leave);
            }
        }
        this.setSubLeave(world, top.m_6630_(5), 2, leave);
        for (i = -1; i <= 1; ++i) {
            this.setBlock(world, top.m_7918_(i, 6, 0), leave);
            this.setBlock(world, top.m_7918_(0, 6, i), leave);
        }
        return true;
    }

    public void subTrunk(WorldGenLevel world, BlockPos pos, BlockState state, Direction face) {
        RandomSource rand = world.m_213780_();
        int height = rand.m_188503_(3) + 2;
        for (int y = 0; y < height + 1; ++y) {
            this.setBlock(world, pos.m_6630_(y), state);
        }
        this.setBlock(world, pos.m_7495_(), Blocks.f_50440_.m_49966_());
        int horizon = rand.m_188503_(2) + 1;
        block7: for (int i = 0; i < horizon; ++i) {
            BlockPos pos2 = pos;
            BlockState state2 = state;
            switch (face) {
                case NORTH: {
                    pos2 = pos2.m_122013_(i + 1);
                    state2 = (BlockState)state2.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    break;
                }
                case SOUTH: {
                    pos2 = pos2.m_122020_(i + 1);
                    state2 = (BlockState)state2.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    break;
                }
                case WEST: {
                    pos2 = pos2.m_122025_(i + 1);
                    state2 = (BlockState)state2.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    break;
                }
                case EAST: {
                    pos2 = pos2.m_122030_(i + 1);
                    state2 = (BlockState)state2.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                }
            }
            this.setBlock(world, pos2, state2);
            if (!world.m_46859_(pos2.m_7495_())) continue;
            for (int k = 0; k < 4; ++k) {
                pos2 = pos2.m_6625_(1);
                pos = pos.m_6625_(1);
                this.setBlock(world, pos2, (BlockState)state2.m_61124_(AXIS, (Comparable)Direction.Axis.Y));
                if (!world.m_46859_(pos2.m_6625_(1))) continue block7;
            }
        }
    }

    public void setSubLeave(WorldGenLevel world, BlockPos pos, int scale, BlockState leave) {
        RandomSource rand = world.m_213780_();
        float chance = 0.45f;
        if (rand.m_188501_() <= chance) {
            this.setBlock(world, pos.m_7918_(0, 0, scale), leave);
        }
        if (rand.m_188501_() <= chance) {
            this.setBlock(world, pos.m_7918_(scale, 0, 0), leave);
        }
        if (rand.m_188501_() <= chance) {
            this.setBlock(world, pos.m_7918_(0, 0, -scale), leave);
        }
        if (rand.m_188501_() <= chance) {
            this.setBlock(world, pos.m_7918_(-scale, 0, 0), leave);
        }
    }

    @Override
    public BlockState getLog() {
        return BlockInit.magiawood_log.m_49966_();
    }

    @Override
    public BlockState getLeave() {
        return (BlockState)((BlockState)BlockInit.magiawood_leaves.m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1));
    }

    protected void setBlock(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (world.m_46859_(pos) || state.equals(this.getLog())) {
            world.m_7731_(pos, state, 3);
        }
    }
}

