/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.worldgen.tree.gen;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.material.Material;
import sweetmagic.worldgen.tree.gen.AbstractTreeGen;

public class MagiaTreeGen
extends AbstractTreeGen {
    public int height = 10;
    public int randHeight = 1;
    private static final EnumProperty<Direction.Axis> AXIS = RotatedPillarBlock.f_55923_;

    public MagiaTreeGen(BlockState log, BlockState leave, int growValue) {
        super(log, leave, growValue);
    }

    @Override
    public void generate(Level world, RandomSource rand, BlockPos pos) {
        int k;
        int i;
        if (!this.checkBlock(world.m_8055_(pos.m_7495_()))) {
            return;
        }
        for (int y = 1; y <= 8; ++y) {
            Material mate = world.m_8055_(pos.m_6630_(y)).m_60767_();
            if (mate == Material.f_76296_ || mate != Material.f_76300_) continue;
            return;
        }
        world.m_7731_(pos, AIR, 3);
        int maxHeight = rand.m_188503_(this.randHeight) + this.height;
        this.subTrunk(world, pos.m_122012_(), this.log, Direction.NORTH);
        this.subTrunk(world, pos.m_122019_(), this.log, Direction.SOUTH);
        this.subTrunk(world, pos.m_122024_(), this.log, Direction.WEST);
        this.subTrunk(world, pos.m_122029_(), this.log, Direction.EAST);
        for (int y = 0; y < maxHeight; ++y) {
            this.setBlock(world, pos.m_6630_(y), this.log);
        }
        this.setBlock(world, this.offset(pos, 0.0, maxHeight, -1.0), (BlockState)this.log.m_61124_(AXIS, (Comparable)Direction.Axis.Z));
        this.setBlock(world, this.offset(pos, 0.0, maxHeight, 1.0), (BlockState)this.log.m_61124_(AXIS, (Comparable)Direction.Axis.Z));
        this.setBlock(world, this.offset(pos, -1.0, maxHeight, 0.0), (BlockState)this.log.m_61124_(AXIS, (Comparable)Direction.Axis.X));
        this.setBlock(world, this.offset(pos, 1.0, maxHeight, 0.0), (BlockState)this.log.m_61124_(AXIS, (Comparable)Direction.Axis.X));
        BlockPos top = this.offset(pos, 0.0, maxHeight - 4, 0.0);
        for (i = -2; i <= 2; ++i) {
            for (k = -2; k <= 2; ++k) {
                this.setBlock(world, top.m_7918_(i, 0, k), this.leave);
            }
        }
        this.setSubLeave(world, top, 3);
        for (i = -3; i <= 3; ++i) {
            for (k = -2; k <= 2; ++k) {
                this.setBlock(world, top.m_7918_(i, 1, k), this.leave);
                this.setBlock(world, top.m_7918_(k, 1, i), this.leave);
            }
        }
        this.setSubLeave(world, top.m_6630_(1), 4);
        for (i = -3; i <= 3; ++i) {
            for (k = -1; k <= 1; ++k) {
                this.setBlock(world, top.m_7918_(i, 2, k), this.leave);
                this.setBlock(world, top.m_7918_(k, 2, i), this.leave);
            }
        }
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                for (int y = 0; y <= 1; ++y) {
                    this.setBlock(world, top.m_7918_(x, y + 2, z), this.leave);
                }
            }
        }
        this.setSubLeave(world, top.m_6630_(3), 3);
        for (i = -2; i <= 2; ++i) {
            for (k = -1; k <= 1; ++k) {
                this.setBlock(world, top.m_7918_(i, 4, k), this.leave);
                this.setBlock(world, top.m_7918_(k, 4, i), this.leave);
            }
        }
        for (i = -1; i <= 1; ++i) {
            for (k = -1; k <= 1; ++k) {
                this.setBlock(world, top.m_7918_(i, 5, k), this.leave);
            }
        }
        this.setSubLeave(world, top.m_6630_(5), 2);
        for (i = -1; i <= 1; ++i) {
            this.setBlock(world, top.m_7918_(i, 6, 0), this.leave);
            this.setBlock(world, top.m_7918_(0, 6, i), this.leave);
        }
    }

    public void subTrunk(Level world, BlockPos pos, BlockState state, Direction face) {
        RandomSource rand = world.m_213780_();
        int height = rand.m_188503_(3) + 2;
        for (int y = 0; y < height; ++y) {
            this.setBlock(world, pos.m_6630_(y), state);
        }
        int horizon = rand.m_188503_(2) + 1;
        for (int i = 0; i < horizon; ++i) {
            BlockPos pos2 = pos;
            BlockState state2 = state;
            switch (face) {
                case NORTH: {
                    pos2 = pos2.m_122013_(i + 1);
                    state2 = (BlockState)state2.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    break;
                }
                case SOUTH: {
                    pos2 = pos2.m_122020_(i + 1);
                    state2 = (BlockState)state2.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    break;
                }
                case WEST: {
                    pos2 = pos2.m_122025_(i + 1);
                    state2 = (BlockState)state2.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    break;
                }
                case EAST: {
                    pos2 = pos2.m_122030_(i + 1);
                    state2 = (BlockState)state2.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                }
            }
            this.setBlock(world, pos2, state2);
        }
    }

    public void setSubLeave(Level world, BlockPos pos, int scale) {
        RandomSource rand = world.m_213780_();
        float chance = 0.45f;
        if (rand.m_188501_() <= chance) {
            this.setBlock(world, this.offset(pos, 0.0, 0.0, scale), this.leave);
        }
        if (rand.m_188501_() <= chance) {
            this.setBlock(world, this.offset(pos, scale, 0.0, 0.0), this.leave);
        }
        if (rand.m_188501_() <= chance) {
            this.setBlock(world, this.offset(pos, 0.0, 0.0, -scale), this.leave);
        }
        if (rand.m_188501_() <= chance) {
            this.setBlock(world, this.offset(pos, -scale, 0.0, 0.0), this.leave);
        }
    }
}

