/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.worldgen.tree.gen;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import sweetmagic.init.block.sm.FruitLeaves;
import sweetmagic.worldgen.tree.gen.AbstractTreeGen;

public class PrismTreeGen
extends AbstractTreeGen {
    public int height = 19;
    public int randHeight = 24;

    public PrismTreeGen(BlockState log, BlockState leave, int growValue) {
        super(log, leave, growValue);
    }

    @Override
    public void generate(Level world, RandomSource rand, BlockPos pos) {
        if (!this.checkBlock(world.m_8055_(pos.m_7495_()))) {
            return;
        }
        for (int y = 1; y <= 8; ++y) {
            Material mate = world.m_8055_(pos.m_6630_(y)).m_60767_();
            if (mate == Material.f_76296_ || mate != Material.f_76300_) continue;
            return;
        }
        world.m_7731_(pos, AIR, 3);
        int maxHeight = rand.m_188503_(this.randHeight) + this.randHeight;
        BlockState log = this.log;
        BlockState leave = this.leave;
        if (leave.m_61138_((Property)FruitLeaves.NOGLOW)) {
            leave = (BlockState)leave.m_61124_((Property)FruitLeaves.NOGLOW, (Comparable)Boolean.valueOf(true));
        }
        this.subTrunk(world, pos.m_122012_(), log);
        this.subTrunk(world, pos.m_122019_(), log);
        this.subTrunk(world, pos.m_122024_(), log);
        this.subTrunk(world, pos.m_122029_(), log);
        for (int y = 0; y < maxHeight; ++y) {
            this.setBlock(world, pos.m_6630_(y), log);
        }
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                for (int y = this.height; y <= maxHeight - 4; ++y) {
                    boolean isOverZ;
                    if (rand.m_188503_(20) != 0) continue;
                    this.setLeave(world, pos.m_7918_(x, y, z), leave);
                    boolean isOverX = x == 2 || x == -2;
                    boolean bl = isOverZ = z == 2 || z == -2;
                    if (isOverX && isOverZ) {
                        this.setBlock(world, pos.m_7918_(x / 2, y - 1, z / 2), log);
                        continue;
                    }
                    if (isOverX) {
                        this.setBlock(world, pos.m_7918_(x / 2, y - 1, z), log);
                        continue;
                    }
                    if (!isOverZ) continue;
                    this.setBlock(world, pos.m_7918_(x, y - 1, z / 2), log);
                }
            }
        }
        BlockPos top = pos.m_7918_(0, maxHeight - 1, 0);
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                this.setBlock(world, top.m_7918_(x, 0, z), leave);
            }
        }
        this.setAir(world, top.m_7918_(-2, 0, -2), leave);
        this.setAir(world, top.m_7918_(2, 0, -2), leave);
        this.setAir(world, top.m_7918_(-2, 0, 2), leave);
        this.setAir(world, top.m_7918_(2, 0, 2), leave);
        this.setBlock(world, top.m_7918_(0, 1, -1), leave);
        this.setBlock(world, top.m_7918_(-1, 1, 0), leave);
        this.setBlock(world, top.m_7918_(0, 1, 1), leave);
        this.setBlock(world, top.m_7918_(1, 1, 0), leave);
        this.setBlock(world, top.m_7494_(), leave);
        this.setBlock(world, top.m_6630_(2), leave);
    }

    public void subTrunk(Level world, BlockPos pos, BlockState state) {
        RandomSource rand = world.m_213780_();
        int height = rand.m_188503_(6) + 8;
        for (int y = 0; y <= height; ++y) {
            this.setBlock(world, pos.m_6630_(y), state);
        }
    }

    public void setLeave(Level world, BlockPos pos, BlockState leave) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                this.setBlock(world, pos.m_7918_(x, 0, z), leave);
                this.setBlock(world, pos.m_7918_(x, 1, z), leave);
            }
        }
        this.setAir(world, pos.m_7918_(-1, 1, -1), leave);
        this.setAir(world, pos.m_7918_(1, 1, -1), leave);
        this.setAir(world, pos.m_7918_(-1, 1, 1), leave);
        this.setAir(world, pos.m_7918_(1, 1, 1), leave);
        world.m_7731_(pos, this.log, 3);
    }

    public void setAir(Level world, BlockPos pos, BlockState state) {
        if (world.m_8055_(pos).m_60734_() == state.m_60734_()) {
            world.m_7731_(pos, AIR, 3);
        }
    }
}

