/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright;

import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec2;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector4dc;

public class Helper {
    public static Vec2 preciseMousePos() {
        MouseHandler mouse = Minecraft.getInstance().mouseHandler;
        Window window = Minecraft.getInstance().getWindow();
        return new Vec2((float)(mouse.xpos() * (double)window.getGuiScaledWidth() / (double)window.getScreenWidth()), (float)(mouse.ypos() * (double)window.getGuiScaledHeight() / (double)window.getScreenHeight()));
    }

    public static Vector2d clampWithin(Vector2d value, Vector4dc bounds) {
        if (bounds.x() > bounds.z() || bounds.y() > bounds.w()) {
            return new Vector2d(bounds.x(), bounds.y());
        }
        value.x = Math.clamp(value.x, bounds.x(), bounds.z());
        value.y = Math.clamp(value.y, bounds.y(), bounds.w());
        return value;
    }

    public static boolean isUsingSpyglass(Player player) {
        return player.isUsingItem() && player.getItemInHand(player.getUsedItemHand()).is(Items.SPYGLASS);
    }

    public static float getMouseProximityFade(Vector2dc mouseScreen, Vector2dc posScreen, float startDist) {
        double dist = mouseScreen.distance(posScreen);
        if (dist < (double)startDist) {
            return Mth.clamp((float)(1.5f * (float)(dist / (double)startDist) - 0.5f), (float)0.11f, (float)1.0f);
        }
        return 1.0f;
    }
}

