/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright;

import org.joml.Vector2d;
import org.joml.Vector2dc;

public class LerpedVector2d {
    private Vector2d start;
    private Vector2d end;
    private double progress = 0.0;

    public LerpedVector2d(Vector2d start, Vector2d end) {
        this.start = start;
        this.end = end;
    }

    public void set(Vector2d pos) {
        this.start = pos;
        this.end = pos;
        this.progress = 0.0;
    }

    public void setStart(Vector2d start) {
        this.start = start;
    }

    public void setEnd(Vector2d end) {
        this.end = end;
    }

    public void tickProgress(double delta) {
        this.progress = Math.clamp(this.progress + delta, 0.0, 1.0);
    }

    public void tickProgress(double delta, Vector2d diffTracker) {
        diffTracker.sub((Vector2dc)this.get());
        this.progress = Math.clamp(this.progress + delta, 0.0, 1.0);
        diffTracker.add((Vector2dc)this.get());
    }

    public double getFrac() {
        double alpha = 2.0;
        return Math.pow(this.progress, 2.0) / (Math.pow(this.progress, 2.0) + Math.pow(1.0 - this.progress, 2.0));
    }

    public Vector2d get() {
        double frac = this.getFrac();
        return new Vector2d((Vector2dc)this.start).mul(1.0 - frac).add((Vector2dc)new Vector2d((Vector2dc)this.end).mul(frac));
    }
}

