/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import foundry.veil.api.client.render.shader.uniform.ShaderUniform;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.joml.Matrix4f;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector4dc;
import wawa.mapwright.Helper;
import wawa.mapwright.MapwrightClient;

public class Rendering {
    public static void renderHead(GuiGraphics guiGraphics, Vector2dc playerPosition, Vector2dc mouseScreen, double xOff, double yOff, float scale, Vector4dc worldBounds) {
        Vector2d pos = new Vector2d(playerPosition).add(xOff, yOff).mul((double)scale);
        Helper.clampWithin(pos, worldBounds);
        float alpha = Helper.getMouseProximityFade(mouseScreen, (Vector2dc)pos, 35.0f);
        Rendering.renderPlayerIcon(guiGraphics, pos.x - 8.0, pos.y - 8.0, Minecraft.getInstance().player, alpha);
    }

    public static void renderPlayerIcon(GuiGraphics graphics, double x, double y, LocalPlayer player, float alpha) {
        ResourceLocation skinTexture = player.getSkin().texture();
        RenderType renderType = VeilRenderType.get((ResourceLocation)RenderTypes.UV_REMAP, (Object[])new Object[]{skinTexture, Textures.HEAD_ICON});
        if (renderType == null) {
            return;
        }
        ShaderUniform xOffset = VeilRenderSystem.setShader((ResourceLocation)Shaders.UV_REMAP).getOrCreateUniform((CharSequence)"XOffset");
        float rot = (player.yRotO + 90.0f) % 360.0f / 360.0f;
        int frame = Math.round(rot * 16.0f);
        xOffset.setFloat(0.0f);
        Rendering.renderTypeBlit(graphics, renderType, x, y, 0, 0.0f, 16.0f * (float)frame, 16, 16, 16, 256, alpha);
        xOffset.setFloat(0.5f);
        Rendering.renderTypeBlit(graphics, renderType, x, y, 0, 0.0f, 16.0f * (float)frame, 16, 16, 16, 256, alpha);
    }

    public static NativeImage getPaletteTexture() {
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        NativeImage image = null;
        try {
            Resource resource = resourceManager.getResourceOrThrow(Textures.PALETTE);
            try (InputStream stream = resource.open();){
                image = NativeImage.read((InputStream)stream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return image;
    }

    public static void renderTypeBlit(GuiGraphics guiGraphics, RenderType renderType, double x, double y, int blitOffset, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight, float alpha) {
        Rendering.renderTypeBlit(guiGraphics, renderType, x, x + (double)uWidth, y, y + (double)vHeight, blitOffset, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight, alpha);
    }

    public static void renderTypeBlit(GuiGraphics guiGraphics, RenderType renderType, double x1, double x2, double y1, double y2, int blitOffset, int uWidth, int vHeight, float uOffset, float vOffset, int textureWidth, int textureHeight, float alpha) {
        Rendering.renderTypeBlit(guiGraphics, renderType, x1, x2, y1, y2, blitOffset, (uOffset + 0.0f) / (float)textureWidth, (uOffset + (float)uWidth) / (float)textureWidth, (vOffset + 0.0f) / (float)textureHeight, (vOffset + (float)vHeight) / (float)textureHeight, alpha);
    }

    public static void renderTypeBlit(GuiGraphics guiGraphics, RenderType renderType, double x1, double x2, double y1, double y2, int blitOffset, float minU, float maxU, float minV, float maxV, float alpha) {
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferBuilder.addVertex(matrix4f, (float)x1, (float)y1, (float)blitOffset).setUv(minU, minV).setColor(1.0f, 1.0f, 1.0f, alpha);
        bufferBuilder.addVertex(matrix4f, (float)x1, (float)y2, (float)blitOffset).setUv(minU, maxV).setColor(1.0f, 1.0f, 1.0f, alpha);
        bufferBuilder.addVertex(matrix4f, (float)x2, (float)y2, (float)blitOffset).setUv(maxU, maxV).setColor(1.0f, 1.0f, 1.0f, alpha);
        bufferBuilder.addVertex(matrix4f, (float)x2, (float)y1, (float)blitOffset).setUv(maxU, minV).setColor(1.0f, 1.0f, 1.0f, alpha);
        renderType.draw(bufferBuilder.buildOrThrow());
    }

    public static void renderTypeBlitUV1(GuiGraphics guiGraphics, RenderType renderType, int x, int y, int width, int height, int textureWidth, int textureHeight, int blitOffset, float u, float v) {
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_LIGHTMAP_COLOR);
        bufferBuilder.addVertex(matrix4f, (float)x, (float)y, (float)blitOffset).setUv(u / (float)textureWidth, v / (float)textureHeight).setUv2(x, y).setColor(-1);
        bufferBuilder.addVertex(matrix4f, (float)x, (float)y + (float)height, (float)blitOffset).setUv(u / (float)textureWidth, (v + (float)height) / (float)textureHeight).setUv2(x, y + height).setColor(-1);
        bufferBuilder.addVertex(matrix4f, (float)x + (float)width, (float)y + (float)height, (float)blitOffset).setUv((u + (float)width) / (float)textureWidth, (v + (float)height) / (float)textureHeight).setUv2(x + width, y + height).setColor(-1);
        bufferBuilder.addVertex(matrix4f, (float)x + (float)width, (float)y, (float)blitOffset).setUv((u + (float)width) / (float)textureWidth, v / (float)textureHeight).setUv2(x + width, y).setColor(-1);
        renderType.draw(bufferBuilder.buildOrThrow());
    }

    public static void croppedBlit(GuiGraphics graphics, ResourceLocation atlasLocation, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV, float red, float green, float blue, float alpha) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)atlasLocation);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = graphics.pose().last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferbuilder.addVertex(matrix4f, (float)x1, (float)y1, (float)blitOffset).setUv(minU, minV).setColor(red, green, blue, alpha);
        bufferbuilder.addVertex(matrix4f, (float)x1, (float)y2, (float)blitOffset).setUv(minU, maxV).setColor(red, green, blue, alpha);
        bufferbuilder.addVertex(matrix4f, (float)x2, (float)y2, (float)blitOffset).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        bufferbuilder.addVertex(matrix4f, (float)x2, (float)y1, (float)blitOffset).setUv(maxU, minV).setColor(red, green, blue, alpha);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static class RenderTypes {
        public static final ResourceLocation PALETTE_SWAP = MapwrightClient.id("palette_swap");
        public static final ResourceLocation UV_REMAP = MapwrightClient.id("uv_remap");
        public static final ResourceLocation BACKGROUND = MapwrightClient.id("background");
    }

    public static class Textures {
        public static final ResourceLocation PALETTE = MapwrightClient.id("textures/gui/palette.png");
        public static final ResourceLocation HEAD_ICON = MapwrightClient.id("textures/gui/head_icon.png");
        public static final ResourceLocation BACKGROUND = MapwrightClient.id("background");
        public static final ResourceLocation BACKGROUND_FULL = MapwrightClient.id("textures/gui/sprites/background.png");
    }

    public static class Shaders {
        public static final ResourceLocation PALETTE_SWAP = MapwrightClient.id("palette_swap");
        public static final ResourceLocation UV_REMAP = MapwrightClient.id("uv_remap");
        public static final ResourceLocation BACKGROUND = MapwrightClient.id("background");
    }
}

