/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.data;

import com.mojang.blaze3d.platform.NativeImage;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.DynamicTexture;
import wawa.mapwright.data.AbstractPage;
import wawa.mapwright.data.Page;
import wawa.mapwright.data.PageIO;
import wawa.mapwright.data.PageManager;

public class EmptyPage
extends AbstractPage {
    private final PageManager parent;
    private boolean loading = true;
    private NativeImage loadedImage = null;
    boolean attemptedUndo = false;
    NativeImage undoImage = null;
    NativeImage redoImage = null;

    public EmptyPage(int rx, int ry, PageManager parent, PageIO pageIO) {
        super(rx, ry);
        this.parent = parent;
        this.runPageLoadThread(pageIO);
    }

    private void runPageLoadThread(PageIO pageIO) {
        Util.ioPool().execute(() -> {
            this.loadedImage = pageIO.tryLoadImage(this.rx, this.ry);
            this.loading = false;
        });
    }

    @Override
    public void setPixel(int x, int y, int RGBA) {
        if (!this.isLoading()) {
            if (this.loadedImage == null) {
                this.loadedImage = new NativeImage(512, 512, true);
            }
            this.loadedImage.setPixelRGBA(x, y, RGBA);
        }
    }

    @Override
    public NativeImage getImage() {
        return this.loadedImage;
    }

    @Override
    public NativeImage unboChanges(NativeImage replacement) {
        if (!this.isLoading()) {
            DynamicTexture texture = new DynamicTexture(512, 512, false);
            texture.getPixels().copyFrom(replacement);
            this.parent.replacePage(this.rx, this.ry, new Page(this.rx, this.ry, texture));
            this.attemptedUndo = false;
            replacement.close();
            this.undoImage = null;
            this.redoImage = null;
            return new NativeImage(512, 512, true);
        }
        this.attemptedUndo = true;
        this.undoImage = replacement;
        this.redoImage = new NativeImage(512, 512, true);
        return this.redoImage;
    }

    @Override
    public void render(GuiGraphics guiGraphics, double xOff, double yOff) {
        super.render(guiGraphics, xOff, yOff);
        if (this.loadedImage != null) {
            this.parent.replacePage(this.rx, this.ry, new Page(this.rx, this.ry, new DynamicTexture(this.loadedImage)));
        }
    }

    @Override
    public void save(PageIO pageIO, boolean close) {
        if (close) {
            this.close();
        }
    }

    @Override
    protected void close() {
        if (this.loadedImage != null) {
            this.loadedImage.close();
        }
    }

    public boolean isLoading() {
        return this.loading;
    }
}

