/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.data;

import com.mojang.blaze3d.platform.NativeImage;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.Rendering;
import wawa.mapwright.data.AbstractPage;
import wawa.mapwright.data.PageIO;

public class Page
extends AbstractPage {
    private final ResourceLocation textureID;
    private final DynamicTexture texture;
    private boolean uploadDirty = true;
    private boolean diskDirty = false;

    public Page(int rx, int ry, DynamicTexture texture) {
        super(rx, ry);
        this.texture = texture;
        this.textureID = MapwrightClient.id("map_" + rx + "_" + ry);
        Minecraft.getInstance().getTextureManager().register(this.textureID, (AbstractTexture)texture);
    }

    public Page(int rx, int ry) {
        this(rx, ry, new DynamicTexture(512, 512, false));
        this.texture.getPixels().fillRect(0, 0, 512, 512, 0);
    }

    @Override
    public void setPixel(int x, int y, int RGBA) {
        this.texture.getPixels().setPixelRGBA(x, y, RGBA);
        this.uploadDirty = true;
        this.diskDirty = true;
    }

    @Override
    public NativeImage getImage() {
        return this.texture.getPixels();
    }

    @Override
    public NativeImage unboChanges(NativeImage replacement) {
        NativeImage previous = new NativeImage(512, 512, false);
        previous.copyFrom(this.texture.getPixels());
        this.texture.getPixels().copyFrom(replacement);
        replacement.close();
        this.diskDirty = true;
        this.uploadDirty = true;
        return previous;
    }

    @Override
    public int getPixel(int x, int y) {
        return this.texture.getPixels().getPixelRGBA(x, y);
    }

    @Override
    public void render(GuiGraphics guiGraphics, double xOff, double yOff) {
        super.render(guiGraphics, xOff, yOff);
        RenderType renderType = VeilRenderType.get((ResourceLocation)Rendering.RenderTypes.PALETTE_SWAP, (Object[])new Object[]{this.textureID});
        if (renderType == null) {
            return;
        }
        if (this.uploadDirty) {
            this.texture.upload();
        }
        Rendering.renderTypeBlit(guiGraphics, renderType, (double)this.left() + xOff, (double)this.top() + yOff, 0, 0.0f, 0.0f, 512, 512, 512, 512, 1.0f);
    }

    @Override
    public void save(PageIO pageIO, boolean close) {
        if (this.diskDirty) {
            this.diskDirty = false;
            Util.ioPool().execute(() -> {
                pageIO.trySaveImage(this.rx, this.ry, this.isEmpty() ? null : this.texture.getPixels());
                if (close) {
                    this.close();
                }
            });
        }
    }

    public boolean isEmpty() {
        int[] pixels;
        for (int pixel : pixels = this.texture.getPixels().getPixelsRGBA()) {
            if (pixel == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void close() {
        Minecraft.getInstance().getTextureManager().release(this.textureID);
    }
}

