/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.map.tool;

import com.mojang.blaze3d.platform.NativeImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.data.PageManager;
import wawa.mapwright.map.stamp_bag.StampInformation;
import wawa.mapwright.map.tool.StampTool;
import wawa.mapwright.map.tool.Tool;
import wawa.mapwright.map.widgets.MapWidget;

public class CopyTool
extends Tool {
    public static CopyTool INSTANCE = new CopyTool(MapwrightClient.id("copy_tool"));
    private static final ResourceLocation TEXTURE = MapwrightClient.id("tool/copy/copy");
    private final ResourceLocation textureID;
    public NativeImage clipboard = null;
    private Vector2ic start = null;

    public CopyTool(ResourceLocation textureID) {
        this.textureID = textureID;
    }

    @Override
    public void mouseDown(PageManager activePage, MapWidget.MouseType mouseType, Vector2d world) {
        if (mouseType == MapWidget.MouseType.LEFT && this.clipboard == null && this.start == null) {
            this.start = new Vector2i((Vector2dc)world, 2);
        }
    }

    @Override
    public void mouseRelease(PageManager activePage, MapWidget.MouseType mouseType, Vector2d world) {
        Vector2i end = new Vector2i((Vector2dc)world, 2);
        if (this.start != null) {
            Vector2i upper_left = this.start.min((Vector2ic)end, new Vector2i());
            Vector2i size = this.start.max((Vector2ic)end, new Vector2i()).sub((Vector2ic)upper_left);
            if (this.clipboard != null) {
                this.clipboard.close();
            }
            if (size.x() > 0 && size.y() > 0) {
                NativeImage nativeImage = new NativeImage(size.x(), size.y(), false);
                activePage.forEachInRegion(upper_left.x(), upper_left.y(), size.x(), size.y(), (arg_0, arg_1, arg_2) -> ((NativeImage)nativeImage).setPixelRGBA(arg_0, arg_1, arg_2));
                StampInformation tempStamp = MapwrightClient.STAMP_HANDLER.temporaryStampInformation;
                StampTool stampTool = StampTool.INSTANCE;
                stampTool.setActiveStamp(tempStamp);
                tempStamp.forceSetTexture(nativeImage);
                MapwrightClient.TOOL_MANAGER.set(stampTool);
            } else {
                this.clipboard = null;
                Minecraft.getInstance().getTextureManager().release(this.textureID);
            }
            this.start = null;
        }
    }

    @Override
    public void renderScreen(GuiGraphics graphics, double mouseX, double mouseY) {
        graphics.blitSprite(TEXTURE, (int)mouseX - 8, (int)mouseY - 10, 16, 16);
    }

    @Override
    public void renderWorld(GuiGraphics graphics, int worldX, int worldY, double xOff, double yOff) {
        if (this.start != null) {
            graphics.renderOutline((int)((double)this.start.x() + xOff), (int)((double)this.start.y() + yOff), worldX - this.start.x(), worldY - this.start.y(), -16777216);
        }
    }
}

