/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.map.tool;

import com.mojang.blaze3d.platform.NativeImage;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.Rendering;
import wawa.mapwright.data.PageManager;
import wawa.mapwright.map.tool.Tool;
import wawa.mapwright.map.widgets.MapWidget;

public class DrawTool
extends Tool {
    private final ResourceLocation icon;
    protected final int internal_color;
    protected final int visual_color;
    protected int r = 0;
    private static final ResourceLocation id = MapwrightClient.id("draw");
    private static DynamicTexture preview = new DynamicTexture(1, 1, false);

    public DrawTool(ResourceLocation icon, int color, int visual_color) {
        this.icon = icon;
        this.internal_color = color;
        this.visual_color = visual_color;
    }

    public int getRadius() {
        return this.r;
    }

    private void rebuildPixels() {
        preview.close();
        int wh = this.r * 2 + 1;
        NativeImage im = new NativeImage(wh, wh, false);
        if (this.internal_color == 0) {
            im.fillRect(0, 0, wh, wh, -16777216);
            if (wh >= 3) {
                im.fillRect(1, 1, wh - 2, wh - 2, 0);
            }
        } else {
            im.fillRect(0, 0, wh, wh, this.internal_color);
        }
        preview = new DynamicTexture(im);
        preview.upload();
        Minecraft.getInstance().getTextureManager().register(id, (AbstractTexture)preview);
    }

    @Override
    public void mouseMove(PageManager activePage, MapWidget.MouseType mouseType, Vector2dc oldWorld, Vector2dc world) {
        switch (mouseType) {
            case LEFT: {
                this.pixelLine(oldWorld.floor(new Vector2d()), world.floor(new Vector2d()), pos -> this.putSquare(activePage, (Vector2ic)pos, this.internal_color));
                break;
            }
            case RIGHT: {
                this.pixelLine(oldWorld.floor(new Vector2d()), world.floor(new Vector2d()), pos -> this.removeSquare(activePage, (Vector2ic)pos, 0));
            }
        }
    }

    public void putSquare(PageManager activePage, Vector2ic pos, int targetColor) {
        activePage.startSnapshot();
        activePage.putSquare(pos.x(), pos.y(), targetColor, this.r);
    }

    public void removeSquare(PageManager activePage, Vector2ic pos, int targetColor) {
        activePage.startSnapshot();
        activePage.putSquare(pos.x(), pos.y(), targetColor, this.r);
    }

    @Override
    public void mouseRelease(PageManager activePage, MapWidget.MouseType mouseType, Vector2d world) {
        activePage.endSnapshot();
    }

    private void pixelLine(Vector2d point1, Vector2d point2, Consumer<Vector2i> perPixel) {
        Vector2d delta = new Vector2d((Vector2dc)point1).sub((Vector2dc)point2);
        int steps = (int)Math.max(1.0, Math.ceil(Math.max(Math.abs(delta.x), Math.abs(delta.y))));
        delta.div((double)steps);
        Vector2d pos = new Vector2d((Vector2dc)point2);
        for (int i = 0; i < steps + 1; ++i) {
            perPixel.accept(new Vector2i(pos.x + 0.5, pos.y + 0.5, 2));
            pos.add((Vector2dc)delta);
        }
    }

    @Override
    public void controlScroll(PageManager activePage, double mouseX, double mouseY, double scrollY) {
        this.r = Mth.clamp((int)(this.r + (int)scrollY), (int)0, (int)(this.internal_color == 0 ? 12 : 6));
        this.rebuildPixels();
    }

    @Override
    public void renderWorld(GuiGraphics graphics, int worldX, int worldY, double xOff, double yOff) {
        RenderType renderType = VeilRenderType.get((ResourceLocation)Rendering.RenderTypes.PALETTE_SWAP, (Object[])new Object[]{id});
        if (renderType == null) {
            return;
        }
        int wh = this.r * 2 + 1;
        double x = (double)(worldX - this.r) + xOff;
        double y = (double)(worldY - this.r) + yOff;
        Rendering.renderTypeBlit(graphics, renderType, x, y, 0, 0.0f, 0.0f, wh, wh, wh, wh, 1.0f);
    }

    @Override
    public void renderScreen(GuiGraphics graphics, double mouseX, double mouseY) {
        graphics.blitSprite(this.icon, (int)mouseX - 16, (int)mouseY - 16, 32, 32);
    }

    @Override
    public void onSelect() {
        this.rebuildPixels();
    }

    public int getVisualColor() {
        return this.visual_color;
    }

    public int getInternalColor() {
        return this.internal_color;
    }

    static {
        preview.getPixels().setPixelRGBA(0, 0, -16777216);
        preview.upload();
        Minecraft.getInstance().getTextureManager().register(id, (AbstractTexture)preview);
    }
}

