/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.map.tool;

import com.mojang.blaze3d.platform.NativeImage;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.Rendering;
import wawa.mapwright.data.PageManager;
import wawa.mapwright.map.stamp_bag.StampInformation;
import wawa.mapwright.map.stamp_bag.StampTexture;
import wawa.mapwright.map.tool.Tool;
import wawa.mapwright.map.widgets.MapWidget;

public class StampTool
extends Tool {
    public static StampTool INSTANCE = new StampTool();
    private static final ResourceLocation TEXTURE = MapwrightClient.id("tool/stamp/stamp");
    private StampInformation information = null;
    private boolean registeredTexture = false;
    private ResourceLocation textureLoc = null;

    @Override
    public void onDeselect() {
        this.setActiveStamp(null);
        if (this.isTempStamp()) {
            this.information.getTextureManager().releaseStamp();
        }
    }

    public void setActiveStamp(@Nullable StampInformation stampInformation) {
        if (this.registeredTexture) {
            this.registeredTexture = false;
            Minecraft.getInstance().getTextureManager().release(this.textureLoc);
            this.textureLoc = null;
        }
        this.changeStamp(stampInformation);
    }

    private void changeStamp(@Nullable StampInformation stampInformation) {
        if (this.information != stampInformation) {
            if (this.information != null) {
                this.information.getTextureManager().removeUser();
            }
            if (stampInformation != null) {
                stampInformation.getTextureManager().addUser();
            }
        }
        this.information = stampInformation;
    }

    @Override
    public void mouseDown(PageManager activePage, MapWidget.MouseType mouseType, Vector2d world) {
        if (mouseType == MapWidget.MouseType.LEFT && this.information != null) {
            StampTexture manager = this.information.getTextureManager();
            NativeImage texture = manager.getTexture();
            if (texture == null) {
                return;
            }
            if (this.registeredTexture) {
                world = world.add(0.0, 8.0);
                Vector2i end = new Vector2i((Vector2dc)world, 2);
                activePage.putRegion(end.x() - texture.getWidth() / 2, end.y() - texture.getHeight() / 2, texture.getWidth(), texture.getHeight(), (arg_0, arg_1, arg_2) -> StampTool.lambda$mouseDown$0(texture, activePage, (Vector2ic)end, arg_0, arg_1, arg_2));
            }
        }
    }

    @Override
    public void renderWorld(GuiGraphics graphics, int worldX, int worldY, double xOff, double yOff) {
        if (this.information != null) {
            RenderType renderType;
            StampTexture manager = this.information.getTextureManager();
            NativeImage texture = manager.getTexture();
            if (texture == null) {
                return;
            }
            if (!this.registeredTexture) {
                ResourceLocation managerLocation;
                this.registeredTexture = true;
                this.textureLoc = managerLocation = MapwrightClient.id("stamp_tool_image");
                Minecraft.getInstance().getTextureManager().register(managerLocation, (AbstractTexture)manager);
            }
            if ((renderType = VeilRenderType.get((ResourceLocation)Rendering.RenderTypes.PALETTE_SWAP, (Object[])new Object[]{this.textureLoc})) == null) {
                return;
            }
            Rendering.renderTypeBlit(graphics, renderType, (double)worldX + xOff - (double)(texture.getWidth() / 2), (double)(worldY += 8) + yOff - (double)(texture.getHeight() / 2), 0, 0.0f, 0.0f, texture.getWidth(), texture.getHeight(), texture.getWidth(), texture.getHeight(), 1.0f);
            graphics.renderOutline((int)((double)worldX + xOff - (double)(texture.getWidth() / 2)), (int)((double)worldY + yOff - (double)(texture.getHeight() / 2)), texture.getWidth(), texture.getHeight(), -16777216);
        }
    }

    @Override
    public void renderScreen(GuiGraphics graphics, double mouseX, double mouseY) {
        graphics.blitSprite(TEXTURE, (int)mouseX - 8, (int)mouseY - 8, 16, 16);
    }

    public boolean isTempStamp() {
        return this.information == MapwrightClient.STAMP_HANDLER.temporaryStampInformation;
    }

    private static /* synthetic */ int lambda$mouseDown$0(NativeImage texture, PageManager activePage, Vector2ic end, int dx, int dy, int old) {
        int pixelColor = texture.getPixelRGBA(dx, dy);
        if (pixelColor == 0) {
            return activePage.getPixelARGB(end.x() - texture.getWidth() / 2 + dx, end.y() - texture.getHeight() / 2 + dy);
        }
        return texture.getPixelRGBA(dx, dy);
    }
}

