/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.map.widgets;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec2;
import wawa.mapwright.Helper;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.map.tool.CopyTool;
import wawa.mapwright.map.tool.DrawTool;
import wawa.mapwright.map.tool.PanTool;
import wawa.mapwright.map.tool.PinTool;
import wawa.mapwright.map.tool.StampBagDebuggerTool;
import wawa.mapwright.map.widgets.SingleToolWidget;

public class ToolPickerWidget
extends AbstractWidget {
    private final List<SingleToolWidget> tools = new ArrayList<SingleToolWidget>();
    private final DrawTool pen = new DrawTool(MapwrightClient.id("tool/pen/pen_cursor"), -16777216, -16777216);
    private final DrawTool eraser = new DrawTool(MapwrightClient.id("tool/eraser/eraser_cursor"), 0, 0);
    private final SingleToolWidget.BrushWidget brushWidget;
    private final PinTool pin = new PinTool();
    private final StampBagDebuggerTool bagDebugger = new StampBagDebuggerTool();
    public int finalToolY = this.getY();

    public ToolPickerWidget(int x, int y) {
        super(x, y, 0, 0, (Component)Component.literal((String)"tool picker"));
        this.tools.add(new SingleToolWidget(this.getX(), this.offsetFinalY(0), MapwrightClient.id("tool/pan"), MapwrightClient.id("tool/pan_highlight"), w -> PanTool.INSTANCE, (Component)Component.literal((String)"pan")));
        this.tools.add(new SingleToolWidget(this.getX(), this.offsetFinalY(20), MapwrightClient.id("tool/pen/pen"), MapwrightClient.id("tool/pen/pen_highlight"), w -> this.pen, (Component)Component.literal((String)"pen")));
        this.brushWidget = new SingleToolWidget.BrushWidget(this.getX(), this.offsetFinalY(20));
        this.tools.add(this.brushWidget);
        this.tools.add(new SingleToolWidget(this.getX(), this.offsetFinalY(20), MapwrightClient.id("tool/eraser/eraser"), MapwrightClient.id("tool/eraser/eraser_highlight"), w -> this.eraser, (Component)Component.literal((String)"eraser")));
        this.tools.add(new SingleToolWidget.PinWidget(this.getX(), this.offsetFinalY(20), w -> this.pin, (Component)Component.literal((String)"pin")));
        this.tools.add(new SingleToolWidget(this.getX(), this.offsetFinalY(20), MapwrightClient.id("tool/copy/copy"), MapwrightClient.id("tool/copy/copy_highlight"), w -> CopyTool.INSTANCE, (Component)Component.literal((String)"copy")));
        this.updateBounds();
    }

    private int offsetFinalY(int offset) {
        return this.finalToolY += offset;
    }

    public void pickHand() {
        MapwrightClient.TOOL_MANAGER.set(PanTool.INSTANCE);
    }

    public void pickPen() {
        MapwrightClient.TOOL_MANAGER.set(this.pen);
    }

    public void pickBrush() {
        if (MapwrightClient.TOOL_MANAGER.get() == this.brushWidget.last) {
            Vec2 mouse = Helper.preciseMousePos();
            this.brushWidget.openToMouse(mouse.x, mouse.y);
        } else {
            MapwrightClient.TOOL_MANAGER.set(this.brushWidget.last);
        }
    }

    public void pickEraser() {
        MapwrightClient.TOOL_MANAGER.set(this.eraser);
    }

    public void pickColor(int color) {
        if (color == -16777216) {
            MapwrightClient.TOOL_MANAGER.set(this.pen);
        } else {
            for (DrawTool drawTool : this.brushWidget.getBrushes()) {
                if (drawTool.getInternalColor() != color) continue;
                MapwrightClient.TOOL_MANAGER.set(drawTool);
                return;
            }
        }
    }

    public NativeImage getImageFromScissorTool() {
        return CopyTool.INSTANCE.clipboard;
    }

    private void updateBounds() {
        int left = 100000;
        int top = 100000;
        int right = 0;
        int bottom = 0;
        for (SingleToolWidget tool : this.tools) {
            left = Math.min(left, tool.getX());
            top = Math.min(top, tool.getY());
            right = Math.max(right, tool.getRight());
            bottom = Math.max(bottom, tool.getBottom());
        }
        this.setX(left);
        this.setY(top);
        this.setWidth(right - left);
        this.setHeight(bottom - top);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.tools.stream().anyMatch(tool -> tool.isMouseOver(mouseX, mouseY));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.active) {
            return false;
        }
        for (SingleToolWidget tool : this.tools) {
            if (!tool.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (SingleToolWidget tool : this.tools) {
            tool.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

