/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import foundry.veil.api.client.render.shader.uniform.ShaderUniform;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.class_1011;
import net.minecraft.class_1921;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector4dc;
import wawa.mapwright.Helper;
import wawa.mapwright.MapwrightClient;

public class Rendering {
    public static void renderHead(class_332 guiGraphics, Vector2dc playerPosition, Vector2dc mouseScreen, double xOff, double yOff, float scale, Vector4dc worldBounds) {
        Vector2d pos = new Vector2d(playerPosition).add(xOff, yOff).mul((double)scale);
        Helper.clampWithin(pos, worldBounds);
        float alpha = Helper.getMouseProximityFade(mouseScreen, (Vector2dc)pos, 35.0f);
        Rendering.renderPlayerIcon(guiGraphics, pos.x - 8.0, pos.y - 8.0, class_310.method_1551().field_1724, alpha);
    }

    public static void renderPlayerIcon(class_332 graphics, double x, double y, class_746 player, float alpha) {
        class_2960 skinTexture = player.method_52814().comp_1626();
        class_1921 renderType = VeilRenderType.get((class_2960)RenderTypes.UV_REMAP, (Object[])new Object[]{skinTexture, Textures.HEAD_ICON});
        if (renderType == null) {
            return;
        }
        ShaderUniform xOffset = VeilRenderSystem.setShader((class_2960)Shaders.UV_REMAP).getOrCreateUniform((CharSequence)"XOffset");
        float rot = (player.field_5982 + 90.0f) % 360.0f / 360.0f;
        int frame = Math.round(rot * 16.0f);
        xOffset.setFloat(0.0f);
        Rendering.renderTypeBlit(graphics, renderType, x, y, 0, 0.0f, 16.0f * (float)frame, 16, 16, 16, 256, alpha);
        xOffset.setFloat(0.5f);
        Rendering.renderTypeBlit(graphics, renderType, x, y, 0, 0.0f, 16.0f * (float)frame, 16, 16, 16, 256, alpha);
    }

    public static class_1011 getPaletteTexture() {
        class_3300 resourceManager = class_310.method_1551().method_1478();
        class_1011 image = null;
        try {
            class_3298 resource = resourceManager.getResourceOrThrow(Textures.PALETTE);
            try (InputStream stream = resource.method_14482();){
                image = class_1011.method_4309((InputStream)stream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return image;
    }

    public static void renderTypeBlit(class_332 guiGraphics, class_1921 renderType, double x, double y, int blitOffset, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight, float alpha) {
        Rendering.renderTypeBlit(guiGraphics, renderType, x, x + (double)uWidth, y, y + (double)vHeight, blitOffset, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight, alpha);
    }

    public static void renderTypeBlit(class_332 guiGraphics, class_1921 renderType, double x1, double x2, double y1, double y2, int blitOffset, int uWidth, int vHeight, float uOffset, float vOffset, int textureWidth, int textureHeight, float alpha) {
        Rendering.renderTypeBlit(guiGraphics, renderType, x1, x2, y1, y2, blitOffset, (uOffset + 0.0f) / (float)textureWidth, (uOffset + (float)uWidth) / (float)textureWidth, (vOffset + 0.0f) / (float)textureHeight, (vOffset + (float)vHeight) / (float)textureHeight, alpha);
    }

    public static void renderTypeBlit(class_332 guiGraphics, class_1921 renderType, double x1, double x2, double y1, double y2, int blitOffset, float minU, float maxU, float minV, float maxV, float alpha) {
        Matrix4f matrix4f = guiGraphics.method_51448().method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y1, (float)blitOffset).method_22913(minU, minV).method_22915(1.0f, 1.0f, 1.0f, alpha);
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y2, (float)blitOffset).method_22913(minU, maxV).method_22915(1.0f, 1.0f, 1.0f, alpha);
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y2, (float)blitOffset).method_22913(maxU, maxV).method_22915(1.0f, 1.0f, 1.0f, alpha);
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y1, (float)blitOffset).method_22913(maxU, minV).method_22915(1.0f, 1.0f, 1.0f, alpha);
        renderType.method_60895(bufferBuilder.method_60800());
    }

    public static void renderTypeBlitUV1(class_332 guiGraphics, class_1921 renderType, int x, int y, int width, int height, int textureWidth, int textureHeight, int blitOffset, float u, float v) {
        Matrix4f matrix4f = guiGraphics.method_51448().method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1586);
        bufferBuilder.method_22918(matrix4f, (float)x, (float)y, (float)blitOffset).method_22913(u / (float)textureWidth, v / (float)textureHeight).method_22921(x, y).method_39415(-1);
        bufferBuilder.method_22918(matrix4f, (float)x, (float)y + (float)height, (float)blitOffset).method_22913(u / (float)textureWidth, (v + (float)height) / (float)textureHeight).method_22921(x, y + height).method_39415(-1);
        bufferBuilder.method_22918(matrix4f, (float)x + (float)width, (float)y + (float)height, (float)blitOffset).method_22913((u + (float)width) / (float)textureWidth, (v + (float)height) / (float)textureHeight).method_22921(x + width, y + height).method_39415(-1);
        bufferBuilder.method_22918(matrix4f, (float)x + (float)width, (float)y, (float)blitOffset).method_22913((u + (float)width) / (float)textureWidth, v / (float)textureHeight).method_22921(x + width, y).method_39415(-1);
        renderType.method_60895(bufferBuilder.method_60800());
    }

    public static void croppedBlit(class_332 graphics, class_2960 atlasLocation, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV, float red, float green, float blue, float alpha) {
        RenderSystem.setShaderTexture((int)0, (class_2960)atlasLocation);
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = graphics.method_51448().method_23760().method_23761();
        class_287 bufferbuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        bufferbuilder.method_22918(matrix4f, (float)x1, (float)y1, (float)blitOffset).method_22913(minU, minV).method_22915(red, green, blue, alpha);
        bufferbuilder.method_22918(matrix4f, (float)x1, (float)y2, (float)blitOffset).method_22913(minU, maxV).method_22915(red, green, blue, alpha);
        bufferbuilder.method_22918(matrix4f, (float)x2, (float)y2, (float)blitOffset).method_22913(maxU, maxV).method_22915(red, green, blue, alpha);
        bufferbuilder.method_22918(matrix4f, (float)x2, (float)y1, (float)blitOffset).method_22913(maxU, minV).method_22915(red, green, blue, alpha);
        class_286.method_43433((class_9801)bufferbuilder.method_60800());
        RenderSystem.disableBlend();
    }

    public static class RenderTypes {
        public static final class_2960 PALETTE_SWAP = MapwrightClient.id("palette_swap");
        public static final class_2960 UV_REMAP = MapwrightClient.id("uv_remap");
        public static final class_2960 BACKGROUND = MapwrightClient.id("background");
    }

    public static class Textures {
        public static final class_2960 PALETTE = MapwrightClient.id("textures/gui/palette.png");
        public static final class_2960 HEAD_ICON = MapwrightClient.id("textures/gui/head_icon.png");
        public static final class_2960 BACKGROUND = MapwrightClient.id("background");
        public static final class_2960 BACKGROUND_FULL = MapwrightClient.id("textures/gui/sprites/background.png");
    }

    public static class Shaders {
        public static final class_2960 PALETTE_SWAP = MapwrightClient.id("palette_swap");
        public static final class_2960 UV_REMAP = MapwrightClient.id("uv_remap");
        public static final class_2960 BACKGROUND = MapwrightClient.id("background");
    }
}

