/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.data;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.function.Predicate;
import net.minecraft.class_1011;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import org.joml.Vector2dc;
import org.joml.Vector2i;
import wawa.mapwright.data.AbstractPage;
import wawa.mapwright.data.EmptyPage;
import wawa.mapwright.data.Page;
import wawa.mapwright.data.PageIO;
import wawa.mapwright.data.Pin;
import wawa.mapwright.data.SpyglassPins;
import wawa.mapwright.data.history.OperationHistory;

public class PageManager {
    public PageIO pageIO;
    private final Map<Vector2i, AbstractPage> pages = new HashMap<Vector2i, AbstractPage>();
    private final Map<Pin.Type, Pin> pins = new HashMap<Pin.Type, Pin>();
    private final SpyglassPins spyglassPins = new SpyglassPins();
    private int emptyCount = 0;
    private int loadedCount = 0;
    private SnapshotState state = SnapshotState.IDLE;
    private static final int MAX_HISTORY = 16;
    private final Stack<OperationHistory> pastHistories = new Stack();
    private final Stack<OperationHistory> futureHistories = new Stack();
    private OperationHistory currentHistory;
    private int cleanupTimer = 0;

    public AbstractPage getOrCreatePage(int rx, int ry) {
        return this.pages.computeIfAbsent(new Vector2i(rx, ry), v -> {
            EmptyPage page = new EmptyPage(v.x, v.y, this, this.pageIO);
            this.deltaCount(page, 1);
            return page;
        });
    }

    private void deltaCount(AbstractPage page, int delta) {
        if (page instanceof EmptyPage) {
            this.emptyCount += delta;
        } else if (page instanceof Page) {
            this.loadedCount += delta;
        }
    }

    public String getDebugCount() {
        return this.emptyCount + this.loadedCount + " (" + this.emptyCount + " / " + this.loadedCount + ")";
    }

    public void startSnapshot() {
        if (this.state != SnapshotState.SNAPSHOTTING) {
            this.state = SnapshotState.SNAPSHOTTING;
            this.currentHistory = new OperationHistory(new HashMap<Vector2i, class_1011>());
            this.futureHistories.forEach(OperationHistory::clear);
            this.futureHistories.clear();
        }
    }

    public void endSnapshot() {
        if (this.state != SnapshotState.IDLE && this.currentHistory != null) {
            this.state = SnapshotState.IDLE;
            this.pastHistories.push(this.currentHistory);
            while (this.pastHistories.size() > 16) {
                ((OperationHistory)this.pastHistories.removeFirst()).clear();
            }
        }
    }

    public void undoChanges() {
        if (!this.pastHistories.empty() && this.state == SnapshotState.IDLE) {
            OperationHistory recentHistory = this.pastHistories.pop();
            OperationHistory redoHistory = new OperationHistory(new HashMap<Vector2i, class_1011>());
            for (Map.Entry<Vector2i, class_1011> entry : recentHistory.pagesModified().entrySet()) {
                AbstractPage page = this.getOrCreatePage(entry.getKey().x, entry.getKey().y);
                redoHistory.pagesModified().put(entry.getKey(), page.unboChanges(entry.getValue()));
            }
            this.futureHistories.push(redoHistory);
            recentHistory.clear();
        }
    }

    public void redoChanges() {
        if (!this.futureHistories.empty() && this.state == SnapshotState.IDLE) {
            OperationHistory recentHistory = this.futureHistories.pop();
            OperationHistory undoHistory = new OperationHistory(new HashMap<Vector2i, class_1011>());
            for (Map.Entry<Vector2i, class_1011> entry : recentHistory.pagesModified().entrySet()) {
                AbstractPage page = this.getOrCreatePage(entry.getKey().x, entry.getKey().y);
                undoHistory.pagesModified().put(entry.getKey(), page.unboChanges(entry.getValue()));
            }
            this.pastHistories.push(undoHistory);
            recentHistory.clear();
        }
    }

    public void snapshotPage(AbstractPage page) {
        Vector2i key;
        Map<Vector2i, class_1011> history;
        if (this.state == SnapshotState.SNAPSHOTTING && (history = this.currentHistory.pagesModified()).get(key = new Vector2i(page.rx, page.ry)) == null) {
            class_1011 image = new class_1011(512, 512, true);
            class_1011 pageImg = page.getImage();
            if (pageImg != null) {
                image.method_4317(pageImg);
            }
            history.put(key, image);
        }
    }

    public void putPixel(int x, int y, int RGBA) {
        EmptyPage ep;
        int ry;
        int rx = Math.floorDiv(x, 512);
        AbstractPage newPage = this.getOrCreatePage(rx, ry = Math.floorDiv(y, 512));
        if (newPage instanceof EmptyPage && (ep = (EmptyPage)newPage).isLoading()) {
            return;
        }
        this.snapshotPage(newPage);
        newPage.setPixel(x - rx * 512, y - ry * 512, RGBA);
    }

    public int getPixelARGB(int x, int y) {
        int rx = Math.floorDiv(x, 512);
        int ry = Math.floorDiv(y, 512);
        return this.getOrCreatePage(rx, ry).getPixel(x - rx * 512, y - ry * 512);
    }

    public void putSquare(int x, int y, int RGBA, int r) {
        for (int i = -r + x; i <= r + x; ++i) {
            for (int j = -r + y; j <= r + y; ++j) {
                this.putPixel(i, j, RGBA);
            }
        }
    }

    public void forEachInRegion(int x, int y, int w, int h, RegionGetter forEach) {
        int rx1 = Math.floorDiv(x, 512);
        int ry1 = Math.floorDiv(y, 512);
        int rx2 = Math.floorDiv(x + w, 512);
        int ry2 = Math.floorDiv(y + h, 512);
        for (int i = rx1; i <= rx2; ++i) {
            for (int j = ry1; j <= ry2; ++j) {
                AbstractPage page = this.getOrCreatePage(i, j);
                int dx1 = i == rx1 ? x - rx1 * 512 : 0;
                int dy1 = j == ry1 ? y - ry1 * 512 : 0;
                int dx2 = i == rx2 ? x - rx2 * 512 + w : 512;
                int dy2 = j == ry2 ? y - ry2 * 512 + h : 512;
                for (int k = dx1; k < dx2; ++k) {
                    for (int l = dy1; l < dy2; ++l) {
                        forEach.of(k + i * 512 - x, l + j * 512 - y, page.getPixel(k, l));
                    }
                }
            }
        }
    }

    public void putRegion(int x, int y, int w, int h, RegionMapping regionMapping) {
        this.startSnapshot();
        int rx1 = Math.floorDiv(x, 512);
        int ry1 = Math.floorDiv(y, 512);
        int rx2 = Math.floorDiv(x + w, 512);
        int ry2 = Math.floorDiv(y + h, 512);
        for (int i = rx1; i <= rx2; ++i) {
            for (int j = ry1; j <= ry2; ++j) {
                AbstractPage page = this.getOrCreatePage(i, j);
                this.snapshotPage(page);
                int dx1 = i == rx1 ? x - rx1 * 512 : 0;
                int dy1 = j == ry1 ? y - ry1 * 512 : 0;
                int dx2 = i == rx2 ? x - rx2 * 512 + w : 512;
                int dy2 = j == ry2 ? y - ry2 * 512 + h : 512;
                for (int k = dx1; k < dx2; ++k) {
                    for (int l = dy1; l < dy2; ++l) {
                        page.setPixel(k, l, regionMapping.apply(k + i * 512 - x, l + j * 512 - y, page.getPixel(k, l)));
                    }
                }
            }
        }
        this.endSnapshot();
    }

    public void putConditionalSquare(int x, int y, int RGBA, int r, Predicate<Integer> shouldReplace) {
        for (int i = -r + x; i <= r + x; ++i) {
            for (int j = -r + y; j <= r + y; ++j) {
                if (!shouldReplace.test(this.getPixelARGB(i, j))) continue;
                this.putPixel(i, j, RGBA);
            }
        }
    }

    public Collection<Pin> getPins() {
        return this.pins.values();
    }

    public void putPin(Pin.Type type, Vector2dc pos) {
        this.pins.computeIfAbsent(type, Pin::new).setPosition(pos);
    }

    public void removePin(Pin.Type type) {
        this.pins.remove(type);
    }

    public SpyglassPins getSpyglassPins() {
        return this.spyglassPins;
    }

    public void replacePage(int rx, int ry, AbstractPage replacement) {
        this.deltaCount(this.pages.get(new Vector2i(rx, ry)), -1);
        this.pages.put(new Vector2i(rx, ry), replacement);
        this.deltaCount(replacement, 1);
    }

    public void reloadPageIO(class_1937 level, class_310 client) {
        this.pageIO = new PageIO(level, client);
        this.pins.clear();
        this.pins.putAll(this.pageIO.readPins());
    }

    public void tick() {
        long rendertime = class_156.method_658();
        if (--this.cleanupTimer < 0) {
            this.cleanupTimer = 200;
            Iterator<AbstractPage> it = this.pages.values().iterator();
            while (it.hasNext()) {
                AbstractPage page = it.next();
                if (rendertime - page.getLastRendertime() > 20000L) {
                    page.save(this.pageIO, true);
                    it.remove();
                    this.deltaCount(page, -1);
                    continue;
                }
                if (!(page instanceof EmptyPage)) continue;
                EmptyPage ep = (EmptyPage)page;
                if (!ep.attemptedUndo || ep.isLoading()) continue;
                if (ep.getImage() != null) {
                    ep.redoImage.method_4317(ep.getImage());
                }
                ep.unboChanges(ep.undoImage);
            }
        }
        this.spyglassPins.tick();
    }

    public void save(boolean close) {
        if (this.pageIO != null) {
            for (AbstractPage page : this.pages.values()) {
                page.save(this.pageIO, close);
            }
            this.pageIO.savePins(this.pins);
        }
    }

    public void saveAndClear() {
        this.save(true);
        this.pages.clear();
        this.emptyCount = 0;
        this.loadedCount = 0;
        this.pastHistories.forEach(OperationHistory::clear);
        this.pastHistories.clear();
        this.futureHistories.forEach(OperationHistory::clear);
        this.futureHistories.clear();
        this.pageIO = null;
    }

    public static enum SnapshotState {
        IDLE,
        SNAPSHOTTING;

    }

    @FunctionalInterface
    public static interface RegionGetter {
        public void of(int var1, int var2, int var3);
    }

    @FunctionalInterface
    public static interface RegionMapping {
        public int apply(int var1, int var2, int var3);
    }
}

