/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector4dc;
import wawa.mapwright.Helper;
import wawa.mapwright.MapwrightClient;

public class Pin {
    public final Type type;
    private Vector2dc position = null;
    public static Type DEFAULT = Type.simpleShorthand("red");
    private static final List<Type> TYPES = new ArrayList<Type>();
    public static Type SPYGLASS_EPHEMERAL = Type.simpleShorthand("spyglass");

    private static void addPinType(Type type) {
        TYPES.add(type);
    }

    @Nullable
    public static Type getType(class_2960 id) {
        for (Type type : TYPES) {
            if (!type.id.equals((Object)id)) continue;
            return type;
        }
        return null;
    }

    public static Collection<Type> getTypes() {
        return TYPES;
    }

    public Pin(Type type) {
        this.type = type;
    }

    public Pin(Type type, Vector2d position) {
        this(type);
        this.position = position;
    }

    public void setPosition(Vector2dc position) {
        this.position = position;
    }

    public Vector2dc getPosition() {
        return this.position;
    }

    public void draw(class_332 guiGraphics, Vector2dc mouseScreen, double xOff, double yOff, float scale, boolean highlight, Vector4dc worldBounds) {
        if (this.position != null) {
            Vector2d pos = new Vector2d(this.position).add(xOff, yOff).mul((double)scale);
            Helper.clampWithin(pos, worldBounds);
            float alpha = Helper.getMouseProximityFade(mouseScreen, (Vector2dc)pos, 35.0f);
            this.type.draw(guiGraphics, pos.x, pos.y, highlight, true, alpha);
        }
    }

    static {
        Pin.addPinType(DEFAULT);
        Pin.addPinType(Type.simpleShorthand("green"));
        Pin.addPinType(Type.simpleShorthand("blue"));
    }

    public record Type(class_2960 id, class_2960 uiTexture, class_2960 highlight, class_2960 positionedTexture, class_2960 positionedHighlight) {
        @Override
        public int hashCode() {
            return this.id.hashCode();
        }

        public static Type simpleShorthand(String name) {
            return new Type(MapwrightClient.id(name), MapwrightClient.id("pin/" + name + "/" + name), MapwrightClient.id("pin/pin_highlight"), MapwrightClient.id("pin/" + name + "/" + name + "_positioned"), MapwrightClient.id("pin/pin_positioned_highlight"));
        }

        public void draw(class_332 guiGraphics, double dx, double dy, boolean highlight, boolean onPoint, float alpha) {
            int x = (int)dx;
            int y = (int)dy;
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_22904(dx - (double)x, dy - (double)y, 0.0);
            if (onPoint) {
                guiGraphics.method_48465(x - 16, y - 16, 0, 32, 32, class_310.method_1551().method_52699().method_18667(this.positionedTexture), 1.0f, 1.0f, 1.0f, alpha);
                if (highlight) {
                    guiGraphics.method_48465(x - 17, y - 17, 0, 34, 34, class_310.method_1551().method_52699().method_18667(this.positionedHighlight), 1.0f, 1.0f, 1.0f, alpha);
                }
            } else {
                guiGraphics.method_48465(x, y, 0, 16, 16, class_310.method_1551().method_52699().method_18667(this.uiTexture), 1.0f, 1.0f, 1.0f, alpha);
                if (highlight) {
                    guiGraphics.method_48465(x - 1, y - 1, 0, 18, 18, class_310.method_1551().method_52699().method_18667(this.highlight), 1.0f, 1.0f, 1.0f, alpha);
                }
            }
            guiGraphics.method_51448().method_22909();
        }
    }
}

