/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.map;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1011;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.gui.GUIElementAtlases;
import wawa.mapwright.map.MapScreen;
import wawa.mapwright.map.stamp_bag.StampInformation;
import wawa.mapwright.map.stamp_bag.widgets.DualGUIElement;
import wawa.mapwright.map.stamp_bag.widgets.GUIElementButton;
import wawa.mapwright.map.stamp_bag.widgets.StampEntryWidget;
import wawa.mapwright.map.tool.StampBagDebuggerTool;

public class StampBagScreen {
    public static final StampBagScreen INSTANCE = new StampBagScreen();
    public MapScreen mapScreen;
    private ScreenState state = ScreenState.IDLE;
    private final Set<class_339> allWidgets = new HashSet<class_339>();
    private final Set<class_339> activeWidgets = new HashSet<class_339>();
    private int page = 1;
    boolean usingSearch = false;
    boolean usingFavorites = false;
    private final List<StampInformation> requestedInfo = new ArrayList<StampInformation>();
    private final class_342 saveText;
    private GUIElementButton confirmSave;
    private GUIElementButton cancelSave;
    private final GUIElementButton up;
    private final GUIElementButton down;
    private final GUIElementButton favorites;
    private final class_342 searchWidget;
    public StampEntry[] entries = new StampEntry[3];
    private final int browseBGWidth = 178;
    private final int browseBGY = 100;
    private final int browseBGHeight = 138;

    public StampBagScreen() {
        this.saveText = new class_342(class_310.method_1551().field_1772, 72, 17, (class_2561)class_2561.method_43473());
        this.saveText.method_25365(false);
        this.saveText.method_1856(true);
        this.saveText.method_1880(72);
        this.createSaveWidgets();
        this.createEntryWidgets();
        this.up = new GUIElementButton(0, 0, 16, GUIElementAtlases.STAMP_BAG_BROWSE_UP, b -> {
            int maxPageCount = this.usingSearch ? this.requestedInfo.size() : (this.usingFavorites ? MapwrightClient.STAMP_HANDLER.getTotalEntryCount(true) : MapwrightClient.STAMP_HANDLER.getTotalEntryCount());
            this.page = (int)Math.clamp((double)(this.page - 1), 1.0, maxPageCount == 0 ? 1.0 : Math.ceil((float)maxPageCount / 3.0f));
            this.refreshStamps();
        });
        this.down = new GUIElementButton(0, 0, 16, GUIElementAtlases.STAMP_BAG_BROWSE_DOWN, b -> {
            int maxPageCount = this.usingSearch ? this.requestedInfo.size() : (this.usingFavorites ? MapwrightClient.STAMP_HANDLER.getTotalEntryCount(true) : MapwrightClient.STAMP_HANDLER.getTotalEntryCount());
            this.page = (int)Math.clamp((double)(this.page + 1), 1.0, maxPageCount == 0 ? 1.0 : Math.ceil((float)maxPageCount / 3.0f));
            this.refreshStamps();
        });
        this.favorites = new DualGUIElement(0, 0, 16, GUIElementAtlases.STAMP_BAG_BROWSE_UNFAVORITE, GUIElementAtlases.STAMP_BAG_BROWSE_FAVORITE, b -> {
            this.usingFavorites ^= true;
            this.page = 1;
            ((DualGUIElement)b).imageSwitch = this.usingFavorites;
            this.refreshStamps();
        });
        this.searchWidget = new class_342(class_310.method_1551().field_1772, GUIElementAtlases.STAMP_BAG_BROWSE_ENTRY.width() - 1, 16, (class_2561)class_2561.method_43473());
        this.searchWidget.method_1863(s -> {
            boolean bl = this.usingSearch = !s.isEmpty();
            if (!s.isEmpty()) {
                this.page = 1;
            }
            this.refreshStamps();
        });
        this.searchWidget.method_25365(false);
        this.searchWidget.method_1856(true);
        this.searchWidget.method_1880(72);
    }

    private void createSaveWidgets() {
        this.confirmSave = new GUIElementButton(0, 0, 16, GUIElementAtlases.STAMP_BAG_SAVE_CONFIRM, b -> {
            class_1011 texture;
            if (!this.saveText.method_1882().isEmpty() && this.mapScreen != null && (texture = MapwrightClient.STAMP_HANDLER.temporaryStampInformation.getTextureManager().getTexture()) != null) {
                class_1011 copied = new class_1011(texture.method_4307(), texture.method_4323(), false);
                copied.method_4317(texture);
                MapwrightClient.STAMP_HANDLER.addNewStamp(copied, this.saveText.method_1882());
                this.saveText.method_1852("");
                this.mapScreen.toolPicker.pickHand();
                this.changeStage(ScreenState.BROWSING);
                return;
            }
            this.changeStage(ScreenState.IDLE);
        });
        this.cancelSave = new GUIElementButton(0, 0, 16, GUIElementAtlases.STAMP_BAG_SAVE_CANCEL, b -> {
            this.saveText.method_1852("");
            this.changeStage(ScreenState.IDLE);
        });
        this.allWidgets.addAll(List.of(this.saveText, this.confirmSave, this.cancelSave));
    }

    private void createEntryWidgets() {
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = new StampEntry();
            StampEntry entry = this.entries[i];
            entry.self = new StampEntryWidget(0, 0, this, wid -> {}, MapwrightClient.id("stamp_widget_" + i));
            entry.delete = new GUIElementButton(0, 0, 16, GUIElementAtlases.STAMP_BAG_BROWSE_TRASH, b -> {
                StampInformation si = entry.self.stampInformation;
                if (si != null) {
                    MapwrightClient.STAMP_HANDLER.removeStamp(si);
                }
                this.refreshStamps();
            });
            entry.favorite = new DualGUIElement(0, 0, 16, GUIElementAtlases.STAMP_BAG_BROWSE_UNFAVORITE, GUIElementAtlases.STAMP_BAG_BROWSE_FAVORITE, b -> {
                StampInformation si = entry.self.stampInformation;
                if (si != null) {
                    si.setFavorited(!si.isFavorited());
                    ((DualGUIElement)b).imageSwitch = si.isFavorited();
                    MapwrightClient.STAMP_HANDLER.setDirty();
                }
            });
        }
    }

    public void setMapScreen(MapScreen screen) {
        this.mapScreen = screen;
    }

    public void resetWidgetInfo() {
        this.allWidgets.forEach(w -> {
            w.field_22763 = false;
            w.method_25365(false);
        });
        int stampBagX = this.mapScreen.stampBag.method_46426();
        int stampBagY = this.mapScreen.stampBag.method_46427();
        StampBagScreen.setWidgetXY((class_339)this.saveText, stampBagX - 123, stampBagY - 1);
        StampBagScreen.setWidgetXY((class_339)this.confirmSave, stampBagX - 49, stampBagY);
        StampBagScreen.setWidgetXY((class_339)this.cancelSave, stampBagX - 28, stampBagY);
        int backgroundX = this.mapScreen.field_22789 - 15 - 8 - 164 - 21;
        int backgroundY = 100;
        for (int i = 0; i < this.entries.length; ++i) {
            int entryY = 126 + i * 37;
            StampEntry entry = this.entries[i];
            StampBagScreen.setWidgetXY(entry.self, backgroundX + 10, entryY);
            StampBagScreen.setWidgetXY((class_339)entry.favorite, backgroundX + GUIElementAtlases.STAMP_BAG_BROWSE_ENTRY.width() + 9, entryY);
            StampBagScreen.setWidgetXY((class_339)entry.delete, backgroundX + GUIElementAtlases.STAMP_BAG_BROWSE_ENTRY.width() + 9, entryY + 16);
        }
        StampBagScreen.setWidgetXY((class_339)this.up, backgroundX + GUIElementAtlases.STAMP_BAG_BROWSE_ENTRY.width() + 28, 126);
        StampBagScreen.setWidgetXY((class_339)this.down, backgroundX + GUIElementAtlases.STAMP_BAG_BROWSE_ENTRY.width() + 28, 216);
        StampBagScreen.setWidgetXY((class_339)this.favorites, backgroundX + GUIElementAtlases.STAMP_BAG_BROWSE_ENTRY.width() + 9, 105);
        StampBagScreen.setWidgetXY((class_339)this.searchWidget, backgroundX + 10, 105);
    }

    private static void setWidgetXY(class_339 w, int x, int y) {
        w.method_46421(x);
        w.method_46419(y);
    }

    public void changeStage(ScreenState newStage) {
        for (class_339 w : this.activeWidgets) {
            this.mapScreen.method_37066((class_364)w);
            w.method_25365(false);
            w.field_22763 = false;
        }
        this.resetWidgetInfo();
        this.activeWidgets.clear();
        if (this.state == ScreenState.BROWSING) {
            for (StampInformation si : this.requestedInfo) {
                si.getTextureManager().removeUser();
            }
        }
        this.state = newStage;
        switch (newStage.ordinal()) {
            case 1: {
                this.addWidget((class_339)this.saveText);
                this.addWidget((class_339)this.confirmSave);
                this.addWidget((class_339)this.cancelSave);
                this.setMapScreenWidgetActivity(false);
                break;
            }
            case 2: {
                if (this.refreshStamps()) {
                    return;
                }
                this.addWidget((class_339)this.up);
                this.addWidget((class_339)this.down);
                this.addWidget((class_339)this.searchWidget);
                this.addWidget((class_339)this.favorites);
                break;
            }
            case 0: {
                this.setMapScreenWidgetActivity(true);
            }
        }
    }

    private boolean refreshStamps() {
        for (StampInformation si : this.requestedInfo) {
            si.getTextureManager().removeUser();
        }
        this.requestedInfo.clear();
        int pageLoc = 3 * this.page;
        if (this.usingSearch) {
            MapwrightClient.STAMP_HANDLER.requestStampContaining(this.requestedInfo, this.searchWidget.method_1882(), this.usingFavorites);
        } else {
            MapwrightClient.STAMP_HANDLER.bulkRequestStamps(this.requestedInfo, this.usingFavorites, pageLoc - 3, pageLoc - 2, pageLoc - 1);
        }
        for (int i = 0; i < 3; ++i) {
            int index = i;
            if (this.usingSearch) {
                index = pageLoc - (3 - i);
            }
            StampEntry entry = this.entries[i];
            if (!this.requestedInfo.isEmpty() && index >= 0 && index <= this.requestedInfo.size() - 1) {
                StampInformation si = this.requestedInfo.get(index);
                entry.self.changeStampInformation(si);
                this.addWidget(entry.self);
                this.addWidget((class_339)entry.delete);
                this.addWidget((class_339)entry.favorite);
                entry.favorite.imageSwitch = si.isFavorited();
                entry.addedWidgets = true;
                continue;
            }
            this.removeWidget(entry.self);
            this.removeWidget((class_339)entry.delete);
            this.removeWidget((class_339)entry.favorite);
            entry.self.changeStampInformation(null);
            entry.addedWidgets = false;
        }
        for (StampInformation si : this.requestedInfo) {
            si.getTextureManager().addUser();
        }
        return false;
    }

    private void setMapScreenWidgetActivity(boolean active) {
        for (class_339 w : this.mapScreen.allWidgets) {
            w.field_22763 = active;
        }
        this.mapScreen.stampBag.field_22763 = true;
    }

    public void addWidget(class_339 wid) {
        wid.field_22763 = true;
        this.mapScreen.method_25429(wid);
        this.activeWidgets.add(wid);
    }

    public void removeWidget(class_339 wid) {
        this.mapScreen.method_37066((class_364)wid);
        this.activeWidgets.remove(wid);
        wid.method_25365(false);
        wid.field_22763 = false;
    }

    public void renderScreen(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 ps = guiGraphics.method_51448();
        ps.method_22903();
        ps.method_22903();
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        ps.method_22909();
        ps.method_22903();
        for (class_339 w : this.activeWidgets) {
            ps.method_22903();
            w.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            ps.method_22909();
        }
        ps.method_22909();
    }

    public void renderBackground(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        switch (this.state.ordinal()) {
            case 1: {
                GUIElementAtlases background = GUIElementAtlases.STAMP_BAG_SAVE;
                int x = this.mapScreen.stampBag.method_46426() - background.width();
                int y = this.mapScreen.stampBag.method_46427() - 5;
                background.render(guiGraphics, x, y);
                break;
            }
            case 2: {
                int browseBGX = this.mapScreen.field_22789 - 15 - 8 - 164 - 21;
                guiGraphics.method_52706(StampBagDebuggerTool.backgroundID, browseBGX, this.browseBGY, this.browseBGWidth, this.browseBGHeight);
                for (int i = 0; i < this.entries.length; ++i) {
                    if (this.entries[i].addedWidgets) {
                        GUIElementAtlases.STAMP_BAG_BROWSE_ENTRY.render(guiGraphics, browseBGX + 10, this.browseBGY + 26 + i * 37);
                    }
                    int maxPageCount = this.usingSearch ? this.requestedInfo.size() : (this.usingFavorites ? MapwrightClient.STAMP_HANDLER.getTotalEntryCount(true) : MapwrightClient.STAMP_HANDLER.getTotalEntryCount());
                    guiGraphics.method_51433(class_310.method_1551().field_1772, "%s/%s".formatted(maxPageCount == 0 ? 0 : this.page, (int)Math.ceil((float)maxPageCount / 3.0f)), browseBGX + GUIElementAtlases.STAMP_BAG_BROWSE_ENTRY.width() + 27, this.browseBGY + 74, Color.WHITE.getRGB(), true);
                }
                break;
            }
        }
    }

    public void mouseClicked(double mouseX, double mouseY, int button) {
        int browseBGX;
        if (this.state != ScreenState.IDLE && this.state != ScreenState.SAVING && (mouseX < (double)(browseBGX = this.mapScreen.field_22789 - 15 - 8 - 164 - 21) || mouseX > (double)(browseBGX + this.browseBGWidth) || mouseY < (double)this.browseBGY || mouseY > (double)(this.browseBGY + this.browseBGHeight)) && !this.mapScreen.stampBag.method_49606()) {
            this.changeStage(ScreenState.IDLE);
        }
    }

    public void parentClose() {
        for (class_339 w : this.activeWidgets) {
            w.method_25365(false);
            this.mapScreen.method_37066((class_364)w);
        }
        this.mapScreen = null;
    }

    public ScreenState getState() {
        return this.state;
    }

    public boolean hasAnyTextBoxFoxused() {
        return this.saveText.method_25370() || this.searchWidget.method_25370();
    }

    public static enum ScreenState {
        IDLE,
        SAVING,
        BROWSING;

    }

    public class StampEntry {
        public DualGUIElement favorite;
        public GUIElementButton delete;
        public StampEntryWidget self;
        public boolean addedWidgets = false;

        public void addAllWidgets() {
            StampBagScreen.this.addWidget((class_339)this.favorite);
            StampBagScreen.this.addWidget((class_339)this.delete);
            StampBagScreen.this.addWidget(this.self);
        }
    }
}

