/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.map.background;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import org.joml.Vector2dc;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.Rendering;

public class MapBackground {
    private static final int[] sizesHorizontal = new int[]{8, 32, 96};
    private static final int[] sizesVertical = new int[]{8, 16, 48};
    private static final int minSize = Arrays.stream(sizesHorizontal).min().getAsInt();
    public final int topMargin;
    public final int leftMargin;
    public final int rightMargin;
    public final int bottomMargin;
    private final FullEdge topEdge = new FullEdge(Edge.TOP);
    private final FullEdge leftEdge = new FullEdge(Edge.LEFT);
    private final FullEdge rightEdge = new FullEdge(Edge.RIGHT);
    private final FullEdge bottomEdge = new FullEdge(Edge.BOTTOM);

    public MapBackground(int width, int height, int topMargin, int leftMargin, int rightMargin, int bottomMargin) {
        this.topMargin = topMargin;
        this.leftMargin = leftMargin;
        this.rightMargin = rightMargin;
        this.bottomMargin = bottomMargin;
        Random rand = new Random((long)width * (long)height);
        this.topEdge.buildEdge(width - leftMargin - rightMargin, rand);
        this.leftEdge.buildEdge(height - topMargin - bottomMargin, rand);
        this.rightEdge.buildEdge(height - topMargin - bottomMargin, rand);
        this.bottomEdge.buildEdge(width - leftMargin - rightMargin, rand);
    }

    public int innerWidth(int width) {
        return width - this.leftMargin - this.rightMargin;
    }

    public int innerHeight(int height) {
        return height - this.topMargin - this.bottomMargin;
    }

    public int getTrueWidth() {
        return this.topEdge.trueSize;
    }

    public int getTrueHeight() {
        return this.leftEdge.trueSize;
    }

    public void render(class_332 guiGraphics, int x, int y, int width, int height, Vector2dc backgroundTranslation, int blitOffset) {
        ShaderProgram backgroundProgram = VeilRenderSystem.setShader((class_2960)Rendering.Shaders.BACKGROUND);
        if (backgroundProgram == null) {
            return;
        }
        backgroundProgram.getOrCreateUniform((CharSequence)"ScreenCenter").setVectorI(x + width / 2, y + height / 2);
        backgroundProgram.getOrCreateUniform((CharSequence)"Translation").setVector((float)backgroundTranslation.x(), (float)backgroundTranslation.y());
        class_1921 sprite = VeilRenderType.get((class_2960)Rendering.RenderTypes.BACKGROUND, (Object[])new Object[]{MapwrightClient.id("textures/gui/sprites/background/corner.png")});
        if (sprite == null) {
            return;
        }
        Rendering.renderTypeBlitUV1(guiGraphics, sprite, x, y, this.leftMargin, this.topMargin, this.leftMargin + this.rightMargin, this.topMargin + this.bottomMargin, blitOffset, 0.0f, 0.0f);
        Rendering.renderTypeBlitUV1(guiGraphics, sprite, x + width - this.rightMargin, y, this.rightMargin, this.topMargin, this.leftMargin + this.rightMargin, this.topMargin + this.bottomMargin, blitOffset, this.leftMargin, 0.0f);
        Rendering.renderTypeBlitUV1(guiGraphics, sprite, x, y + height - this.bottomMargin, this.leftMargin, this.bottomMargin, this.leftMargin + this.rightMargin, this.topMargin + this.bottomMargin, blitOffset, 0.0f, this.topMargin);
        Rendering.renderTypeBlitUV1(guiGraphics, sprite, x + width - this.rightMargin, y + height - this.bottomMargin, this.rightMargin, this.bottomMargin, this.leftMargin + this.rightMargin, this.topMargin + this.bottomMargin, blitOffset, this.leftMargin, this.topMargin);
        sprite = VeilRenderType.get((class_2960)Rendering.RenderTypes.BACKGROUND, (Object[])new Object[]{MapwrightClient.id("textures/gui/sprites/background/center.png")});
        if (sprite == null) {
            return;
        }
        Rendering.renderTypeBlitUV1(guiGraphics, sprite, x + this.leftMargin, y + this.topMargin, this.innerWidth(width), this.innerHeight(height), 1, 1, blitOffset, 0.0f, 0.0f);
        this.topEdge.render(guiGraphics, Rendering.RenderTypes.BACKGROUND, x + this.leftMargin, y, this.topMargin, blitOffset);
        this.leftEdge.render(guiGraphics, Rendering.RenderTypes.BACKGROUND, x, y + this.topMargin, this.leftMargin, blitOffset);
        this.rightEdge.render(guiGraphics, Rendering.RenderTypes.BACKGROUND, x + width - this.rightMargin, y + this.topMargin, this.rightMargin, blitOffset);
        this.bottomEdge.render(guiGraphics, Rendering.RenderTypes.BACKGROUND, x + this.rightMargin, y + height - this.bottomMargin, this.bottomMargin, blitOffset);
    }

    private static class FullEdge
    extends ArrayList<EdgeTexture> {
        public final Edge edge;
        private int trueSize = 0;

        public FullEdge(Edge edge) {
            this.edge = edge;
        }

        public void buildEdge(int targetSize, Random random) {
            this.clear();
            int currentSize = 0;
            int[] sizeCount = new int[this.edge.textureSizes.length];
            while (currentSize + minSize <= targetSize) {
                int candidateIndex = random.nextInt(sizeCount.length);
                if (this.edge.textureSizes[candidateIndex] + currentSize > targetSize) continue;
                currentSize += this.edge.textureSizes[candidateIndex];
                int n = candidateIndex;
                sizeCount[n] = sizeCount[n] + 1;
            }
            this.trueSize = currentSize;
            for (int i = 0; i < sizeCount.length; ++i) {
                for (int j = 0; j < sizeCount[i]; ++j) {
                    this.add(new EdgeTexture(i, random.nextInt(3)));
                }
            }
            Collections.shuffle(this, random);
        }

        public void render(class_332 guiGraphics, class_2960 renderType, int x, int y, int size, int blitOffset) {
            if (this.edge.horizontal) {
                for (EdgeTexture edge : this) {
                    int width = this.edge.textureSizes[edge.sizeIndex];
                    class_1921 sprite = VeilRenderType.get((class_2960)renderType, (Object[])new Object[]{this.edge.textures[edge.sizeIndex]});
                    if (sprite == null) continue;
                    Rendering.renderTypeBlitUV1(guiGraphics, sprite, x, y, width, size, width, size * 3, blitOffset, 0.0f, edge.index * size);
                    x += width;
                }
            } else {
                for (EdgeTexture edge : this) {
                    int height = this.edge.textureSizes[edge.sizeIndex];
                    class_1921 sprite = VeilRenderType.get((class_2960)renderType, (Object[])new Object[]{this.edge.textures[edge.index]});
                    if (sprite == null) continue;
                    Rendering.renderTypeBlitUV1(guiGraphics, sprite, x, y, size, height, size * 3, height, blitOffset, edge.index * size, 0.0f);
                    y += height;
                }
            }
        }
    }

    static enum Edge {
        TOP("top", true, sizesHorizontal),
        LEFT("left", false, sizesVertical),
        RIGHT("right", false, sizesVertical),
        BOTTOM("bottom", true, sizesHorizontal);

        final boolean horizontal;
        final int[] textureSizes;
        final class_2960[] textures;

        private Edge(String prefix, boolean horizontal, int[] textureSizes) {
            this.horizontal = horizontal;
            this.textureSizes = textureSizes;
            this.textures = (class_2960[])Arrays.stream(textureSizes).mapToObj(i -> MapwrightClient.id("textures/gui/sprites/background/" + prefix + "/" + i + ".png")).toArray(class_2960[]::new);
        }
    }

    private record EdgeTexture(int sizeIndex, int index) {
        public static final int variations = 3;
    }
}

