/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.map.stamp_bag;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1011;
import org.jetbrains.annotations.NotNull;
import wawa.mapwright.map.stamp_bag.StampTexture;

public final class StampInformation {
    public static final Codec<StampInformation> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("file_name").forGetter(StampInformation::getFileName), (App)Codec.STRING.fieldOf("custom_name").forGetter(StampInformation::getCustomName), (App)Codec.BOOL.fieldOf("favorite").forGetter(StampInformation::isFavorited)).apply((Applicative)i, StampInformation::new));
    private final String fileName;
    private final String customName;
    private boolean favorited;
    @NotNull
    private final StampTexture stampTexture;
    private boolean removed = false;

    public StampInformation(String fileName, String customName, boolean favorite, class_1011 newStamp) {
        this(fileName, customName, favorite);
        this.stampTexture.setFirstStamp(newStamp);
    }

    public StampInformation(String fileName, String customName, boolean favorite) {
        this.fileName = fileName;
        this.customName = customName;
        this.favorited = favorite;
        this.stampTexture = new StampTexture();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getCustomName() {
        return this.customName;
    }

    public boolean isFavorited() {
        return this.favorited;
    }

    public void setFavorited(boolean favorited) {
        this.favorited = favorited;
    }

    @NotNull
    public StampTexture getTextureManager() {
        return this.stampTexture;
    }

    public void forceSetTexture(@NotNull class_1011 newImage) {
        this.stampTexture.releaseStamp();
        this.stampTexture.setFirstStamp(newImage);
    }

    public void setStampTexture(@NotNull class_1011 newImage) {
        class_1011 texture;
        if (!this.removed && (texture = this.stampTexture.getTexture()) == null) {
            this.stampTexture.setFirstStamp(newImage);
        }
    }

    public void setRemoved() {
        this.removed = true;
        this.getTextureManager().removeFromHandler();
    }
}

