/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.map.stamp_bag;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wawa.mapwright.MapwrightClient;

public class StampTexture
extends class_1044 {
    private static final int MAX_LIFE = 600;
    private int usages = 0;
    private int ticksUntilRemoval = 600;
    private boolean removedFromHandler = false;
    @Nullable
    private class_1011 stamp;

    public void tick() {
        if (this.removedFromHandler) {
            if (this.stamp != null) {
                this.releaseStamp();
            }
            return;
        }
        if (this.stamp != null) {
            if (this.usages <= 0 && this.ticksUntilRemoval-- <= 0) {
                this.releaseStamp();
            } else if (this.usages > 0) {
                this.ticksUntilRemoval = 600;
            }
            return;
        }
        this.ticksUntilRemoval = 600;
    }

    public void addUser() {
        if (!this.removedFromHandler) {
            ++this.usages;
        }
    }

    public void removeUser() {
        if (this.usages > 0) {
            --this.usages;
        }
    }

    public class_1011 getTexture() {
        return this.stamp;
    }

    public void releaseStamp() {
        if (this.stamp != null) {
            this.stamp.close();
            super.method_4528();
            this.stamp = null;
        }
    }

    public void setFirstStamp(@NotNull class_1011 image) {
        if (!this.removedFromHandler && this.stamp == null) {
            this.stamp = image;
            this.prepareStamp(this.stamp);
        }
    }

    private void prepareStamp(@NotNull class_1011 stamp) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                TextureUtil.prepareImage((int)this.method_4624(), (int)stamp.method_4307(), (int)stamp.method_4323());
                this.upload();
            });
        } else {
            TextureUtil.prepareImage((int)this.method_4624(), (int)stamp.method_4307(), (int)stamp.method_4323());
            this.upload();
        }
    }

    private void upload() {
        if (this.stamp != null) {
            this.method_23207();
            this.stamp.method_4301(0, 0, 0, false);
        } else {
            MapwrightClient.LOGGER.warn("Trying to upload disposed texture {}", (Object)this.method_4624());
        }
    }

    public void removeFromHandler() {
        this.removedFromHandler = true;
        this.releaseStamp();
        this.usages = 0;
    }

    public void method_4528() {
    }

    public void method_4625(class_3300 resourceManager) throws IOException {
    }
}

