/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.map.tool;

import foundry.veil.api.client.render.rendertype.VeilRenderType;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.Rendering;
import wawa.mapwright.data.PageManager;
import wawa.mapwright.map.stamp_bag.StampInformation;
import wawa.mapwright.map.stamp_bag.StampTexture;
import wawa.mapwright.map.tool.Tool;
import wawa.mapwright.map.widgets.MapWidget;

public class StampTool
extends Tool {
    public static StampTool INSTANCE = new StampTool();
    private static final class_2960 TEXTURE = MapwrightClient.id("tool/stamp/stamp");
    private StampInformation information = null;
    private boolean registeredTexture = false;
    private class_2960 textureLoc = null;

    @Override
    public void onDeselect() {
        this.setActiveStamp(null);
        if (this.isTempStamp()) {
            this.information.getTextureManager().releaseStamp();
        }
    }

    public void setActiveStamp(@Nullable StampInformation stampInformation) {
        if (this.registeredTexture) {
            this.registeredTexture = false;
            class_310.method_1551().method_1531().method_4615(this.textureLoc);
            this.textureLoc = null;
        }
        this.changeStamp(stampInformation);
    }

    private void changeStamp(@Nullable StampInformation stampInformation) {
        if (this.information != stampInformation) {
            if (this.information != null) {
                this.information.getTextureManager().removeUser();
            }
            if (stampInformation != null) {
                stampInformation.getTextureManager().addUser();
            }
        }
        this.information = stampInformation;
    }

    @Override
    public void mouseDown(PageManager activePage, MapWidget.MouseType mouseType, Vector2d world) {
        if (mouseType == MapWidget.MouseType.LEFT && this.information != null) {
            StampTexture manager = this.information.getTextureManager();
            class_1011 texture = manager.getTexture();
            if (texture == null) {
                return;
            }
            if (this.registeredTexture) {
                world = world.add(0.0, 8.0);
                Vector2i end = new Vector2i((Vector2dc)world, 2);
                activePage.putRegion(end.x() - texture.method_4307() / 2, end.y() - texture.method_4323() / 2, texture.method_4307(), texture.method_4323(), (arg_0, arg_1, arg_2) -> StampTool.lambda$mouseDown$0(texture, activePage, (Vector2ic)end, arg_0, arg_1, arg_2));
            }
        }
    }

    @Override
    public void renderWorld(class_332 graphics, int worldX, int worldY, double xOff, double yOff) {
        if (this.information != null) {
            class_1921 renderType;
            StampTexture manager = this.information.getTextureManager();
            class_1011 texture = manager.getTexture();
            if (texture == null) {
                return;
            }
            if (!this.registeredTexture) {
                class_2960 managerLocation;
                this.registeredTexture = true;
                this.textureLoc = managerLocation = MapwrightClient.id("stamp_tool_image");
                class_310.method_1551().method_1531().method_4616(managerLocation, (class_1044)manager);
            }
            if ((renderType = VeilRenderType.get((class_2960)Rendering.RenderTypes.PALETTE_SWAP, (Object[])new Object[]{this.textureLoc})) == null) {
                return;
            }
            Rendering.renderTypeBlit(graphics, renderType, (double)worldX + xOff - (double)(texture.method_4307() / 2), (double)(worldY += 8) + yOff - (double)(texture.method_4323() / 2), 0, 0.0f, 0.0f, texture.method_4307(), texture.method_4323(), texture.method_4307(), texture.method_4323(), 1.0f);
            graphics.method_49601((int)((double)worldX + xOff - (double)(texture.method_4307() / 2)), (int)((double)worldY + yOff - (double)(texture.method_4323() / 2)), texture.method_4307(), texture.method_4323(), -16777216);
        }
    }

    @Override
    public void renderScreen(class_332 graphics, double mouseX, double mouseY) {
        graphics.method_52706(TEXTURE, (int)mouseX - 8, (int)mouseY - 8, 16, 16);
    }

    public boolean isTempStamp() {
        return this.information == MapwrightClient.STAMP_HANDLER.temporaryStampInformation;
    }

    private static /* synthetic */ int lambda$mouseDown$0(class_1011 texture, PageManager activePage, Vector2ic end, int dx, int dy, int old) {
        int pixelColor = texture.method_4315(dx, dy);
        if (pixelColor == 0) {
            return activePage.getPixelARGB(end.x() - texture.method_4307() / 2 + dx, end.y() - texture.method_4323() / 2 + dy);
        }
        return texture.method_4315(dx, dy);
    }
}

