/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.map.widgets;

import foundry.veil.api.client.color.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1011;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6382;
import net.minecraft.class_8002;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.Rendering;
import wawa.mapwright.map.tool.PaletteDrawTool;
import wawa.mapwright.map.widgets.SingleToolWidget;

public class ColorPickerWidget
extends class_339 {
    public static final int COLOR_COUNT = 12;
    private final List<PaletteSwabWidget> swabs = new ArrayList<PaletteSwabWidget>();
    private final SingleToolWidget.BrushWidget brushWidget;
    private final int defaultX;
    private final int defaultY;

    public ColorPickerWidget(int rightAnchor, int centerY, SingleToolWidget.BrushWidget brushWidget) {
        super(rightAnchor, centerY, 0, 0, (class_2561)class_2561.method_43470((String)"color picker"));
        this.brushWidget = brushWidget;
        class_1011 texture = Rendering.getPaletteTexture();
        int colorCount = Math.min(12, texture.method_4307());
        for (int i = 0; i < colorCount; ++i) {
            float n = (float)(i + 1) / 13.0f;
            Color color = new Color(n, n, n);
            int pixelRGBA = texture.method_4315(i + 1, 0);
            Color trueColor = new Color(Integer.reverseBytes(pixelRGBA) >> 8);
            int columns = 4;
            int sx = i % 4 * 10;
            int sy = i / 4 * 10;
            this.field_22758 = Math.max(this.field_22758, sx + 8);
            this.field_22759 = Math.max(this.field_22759, sy + 8);
            this.swabs.add(new PaletteSwabWidget(this, sx, sy, color.argb(), trueColor.argb()));
        }
        this.defaultX = rightAnchor - this.field_22758 - 4;
        this.defaultY = centerY - this.field_22759 / 2 + 8;
        this.method_46421(this.defaultX);
        this.method_46419(this.defaultY);
        brushWidget.last = this.swabs.getFirst().tool;
    }

    public void openToMouse(double mouseX, double mouseY) {
        this.field_22763 = true;
        this.method_46421((int)(mouseX - (double)(this.field_22758 / 2)));
        this.method_46419((int)(mouseY - (double)(this.field_22759 / 2)));
    }

    public void resetPos() {
        this.method_46421(this.defaultX);
        this.method_46419(this.defaultY);
    }

    public List<PaletteDrawTool> getBrushes() {
        return this.swabs.stream().map(swab -> swab.tool).collect(Collectors.toList());
    }

    public boolean method_25405(double mouseX, double mouseY) {
        int padding = 10;
        return this.method_37303() && (mouseX >= (double)this.method_46426() - 10.0 && mouseY >= (double)this.method_46427() - 10.0 && mouseX < (double)(this.method_46426() + this.field_22758 + 10) && mouseY < (double)(this.method_46427() + this.field_22759 + 10) || this.swabs.stream().anyMatch(swab -> swab.method_25405(mouseX, mouseY)));
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (PaletteSwabWidget swab : this.swabs) {
            if (!swab.method_25402(mouseX, mouseY, button)) continue;
            return true;
        }
        return this.method_25405(mouseX, mouseY);
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_8002.method_47946((class_332)guiGraphics, (int)this.method_46426(), (int)this.method_46427(), (int)this.field_22758, (int)this.field_22759, (int)0);
        for (PaletteSwabWidget swab : this.swabs) {
            swab.method_48579(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    public static class PaletteSwabWidget
    extends class_339 {
        private final ColorPickerWidget parent;
        private final int relX;
        private final int relY;
        public final int color;
        public final int visualColor;
        public final PaletteDrawTool tool;

        public PaletteSwabWidget(ColorPickerWidget parent, int x, int y, int color, int visualColor) {
            super(0, 0, 8, 8, (class_2561)class_2561.method_43470((String)"color swab"));
            this.parent = parent;
            this.relX = x;
            this.relY = y;
            this.color = color;
            this.visualColor = visualColor;
            this.tool = new PaletteDrawTool(MapwrightClient.id("tool/brush/brush_cursor"), this.getABGR(), this.visualColor, parent.brushWidget);
        }

        public int method_46426() {
            return this.parent.method_46426() + this.relX;
        }

        public int method_46427() {
            return this.parent.method_46427() + this.relY;
        }

        protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (this.method_25405(mouseX, mouseY)) {
                guiGraphics.method_25294(this.method_46426() - 1, this.method_46427() - 1, this.method_55442() + 1, this.method_55443() + 1, -1);
                guiGraphics.method_25294(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443(), -16777216);
                guiGraphics.method_25294(this.method_46426() + 1, this.method_46427() + 1, this.method_55442() - 1, this.method_55443() - 1, this.visualColor);
            } else {
                guiGraphics.method_25294(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443(), this.visualColor);
            }
        }

        public void method_25348(double mouseX, double mouseY) {
            MapwrightClient.TOOL_MANAGER.set(this.tool);
            this.parent.brushWidget.last = this.tool;
        }

        public int getABGR() {
            int B = this.color & 0xFF;
            int G = this.color >> 8 & 0xFF;
            int R = this.color >> 16 & 0xFF;
            int A = this.color >> 24 & 0xFF;
            return A << 24 | B << 16 | G << 8 | R;
        }

        protected void method_47399(class_6382 narrationElementOutput) {
        }
    }
}

