/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.map.widgets;

import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2i;
import org.joml.Vector4d;
import org.joml.Vector4dc;
import wawa.mapwright.Helper;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.Rendering;
import wawa.mapwright.data.Pin;
import wawa.mapwright.data.SpyglassPins;
import wawa.mapwright.map.MapScreen;
import wawa.mapwright.map.background.MapBackground;
import wawa.mapwright.map.tool.PanTool;
import wawa.mapwright.map.tool.PinTool;
import wawa.mapwright.map.tool.Tool;

public class MapWidget
extends class_339 {
    private static final int OUTER_PADDING = 30;
    private static final int TOP_MARGIN = 40;
    private static final int LEFT_MARGIN = 96;
    private static final int RIGHT_MARGIN = 96;
    private static final int BOTTOM_MARGIN = 40;
    private static final int TOP_SCISSOR = 20;
    private static final int LEFT_SCISSOR = 50;
    private static final int RIGHT_SCISSOR = 20;
    private static final int BOTTOM_SCISSOR = 20;
    private final MapScreen parent;
    private final MapBackground background;
    public MouseType mouseType = MouseType.NONE;
    public double oldMouseX;
    public double oldMouseY;

    public MapWidget(MapScreen parent) {
        super(30, 30, parent.field_22789 - 60, parent.field_22790 - 60, (class_2561)class_2561.method_43470((String)"Map Display"));
        this.background = new MapBackground(this.field_22758, this.field_22759, 40, 96, 96, 40);
        this.method_25358(this.background.getTrueWidth() + 96 + 96);
        this.method_53533(this.background.getTrueHeight() + 40 + 40);
        this.method_46421((parent.field_22789 - this.field_22758) / 2);
        this.method_46419((parent.field_22790 - this.field_22759) / 2);
        this.parent = parent;
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        Vector2d panning = this.parent.lerpedPanning.get();
        float scale = this.parent.getScale();
        this.background.render(guiGraphics, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759, (Vector2dc)this.parent.backgroundPanning, -1);
        guiGraphics.method_51448().method_22903();
        double hw = (double)this.field_22758 / 2.0;
        double hh = (double)this.field_22759 / 2.0;
        guiGraphics.method_51448().method_22904((double)this.method_46426() + hw, (double)this.method_46427() + hh, 0.0);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_22905(scale, scale, 1.0f);
        double xOff = -panning.x;
        double yOff = -panning.y;
        guiGraphics.method_44379(this.method_46426() + 50, this.method_46427() + 20, this.method_55442() - 20, this.method_55443() - 20);
        Vector2d topLeftWorld = this.parent.screenToWorld(new Vector2d((double)this.method_46426(), (double)this.method_46427()));
        Vector2d bottomRightWorld = this.parent.screenToWorld(new Vector2d((double)this.method_55442(), (double)this.method_55443()));
        Vector2i topLeft = new Vector2i(topLeftWorld.x / 512.0, topLeftWorld.y / 512.0, 2);
        Vector2i bottomRight = new Vector2i(bottomRightWorld.x / 512.0, bottomRightWorld.y / 512.0, 1);
        for (int x = topLeft.x; x < bottomRight.x; ++x) {
            for (int y = topLeft.y; y < bottomRight.y; ++y) {
                MapwrightClient.PAGE_MANAGER.getOrCreatePage(x, y).render(guiGraphics, xOff, yOff);
            }
        }
        class_241 mouse = Helper.preciseMousePos();
        Vector2d world = this.parent.screenToWorld(new Vector2d((double)mouse.field_1343, (double)mouse.field_1342));
        MapwrightClient.TOOL_MANAGER.get().renderWorld(guiGraphics, class_3532.method_15357((double)world.x), class_3532.method_15357((double)world.y), xOff, yOff);
        guiGraphics.method_44380();
        guiGraphics.method_51448().method_22909();
        Vector2d mouseScreen = new Vector2d((double)(mouseX - this.method_46426()) - hw, (double)(mouseY - this.method_46427()) - hh);
        Vector4d transformedScreenBounds = new Vector4d(-hw + 50.0, -hh + 20.0, (double)this.field_22758 - hw - 20.0, (double)this.field_22759 - hh - 20.0);
        for (Pin pin : MapwrightClient.PAGE_MANAGER.getPins()) {
            boolean highlight = false;
            Tool tool = MapwrightClient.TOOL_MANAGER.get();
            if (tool instanceof PinTool) {
                PinTool pinTool = (PinTool)tool;
                highlight = pinTool.currentPin == pin.type;
            }
            pin.draw(guiGraphics, (Vector2dc)mouseScreen, xOff, yOff, scale, highlight, (Vector4dc)transformedScreenBounds);
        }
        for (SpyglassPins.PinData pinData : MapwrightClient.PAGE_MANAGER.getSpyglassPins().getPins()) {
            pinData.pin().draw(guiGraphics, (Vector2dc)mouseScreen, xOff, yOff, scale, false, (Vector4dc)transformedScreenBounds);
        }
        class_243 playerPos = class_310.method_1551().field_1724.method_19538();
        Rendering.renderHead(guiGraphics, (Vector2dc)new Vector2d(playerPos.field_1352, playerPos.field_1350), (Vector2dc)mouseScreen, xOff, yOff, scale, (Vector4dc)transformedScreenBounds);
        guiGraphics.method_51448().method_22909();
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (class_437.method_25441()) {
            MapwrightClient.TOOL_MANAGER.get().controlScroll(MapwrightClient.PAGE_MANAGER, mouseX, mouseY, scrollY);
        } else {
            this.parent.deltaZoom((int)scrollY);
        }
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25405(mouseX, mouseY)) {
            this.oldMouseX = mouseX;
            this.oldMouseY = mouseY;
            MouseType newType = switch (button) {
                case 0 -> MouseType.LEFT;
                case 1 -> MouseType.RIGHT;
                case 2 -> MouseType.MIDDLE;
                default -> MouseType.NONE;
            };
            Vector2d world = this.parent.screenToWorld(new Vector2d(mouseX, mouseY));
            if (newType != this.mouseType && this.mouseType != MouseType.NONE) {
                MapwrightClient.TOOL_MANAGER.get().mouseRelease(MapwrightClient.PAGE_MANAGER, this.mouseType, world);
            }
            this.mouseType = newType;
            if (class_437.method_25441()) {
                int color = MapwrightClient.PAGE_MANAGER.getPixelARGB(class_3532.method_15357((double)world.x), class_3532.method_15357((double)world.y));
                this.parent.toolPicker.pickColor(color);
            } else if (this.mouseType == MouseType.LEFT || this.mouseType == MouseType.RIGHT) {
                MapwrightClient.TOOL_MANAGER.get().mouseDown(MapwrightClient.PAGE_MANAGER, this.mouseType, world);
                MapwrightClient.TOOL_MANAGER.get().mouseMove(MapwrightClient.PAGE_MANAGER, this.mouseType, (Vector2dc)world, (Vector2dc)world);
            }
            return true;
        }
        return false;
    }

    private boolean shouldPan() {
        if (this.mouseType == MouseType.MIDDLE) {
            return true;
        }
        if (this.mouseType == MouseType.LEFT || this.mouseType == MouseType.RIGHT) {
            return class_437.method_25441() || MapwrightClient.TOOL_MANAGER.get() instanceof PanTool;
        }
        return false;
    }

    public void method_16014(double mouseX, double mouseY) {
        Vector2d world = this.parent.screenToWorld(new Vector2d(mouseX, mouseY));
        Vector2d oldWorld = this.parent.screenToWorld(new Vector2d(this.oldMouseX, this.oldMouseY));
        if (this.shouldPan()) {
            this.parent.lerpedPanning.set(this.parent.lerpedPanning.get().add((Vector2dc)oldWorld).sub((Vector2dc)world));
            this.parent.backgroundPanning.add(this.oldMouseX, this.oldMouseY).sub(mouseX, mouseY);
        } else {
            if (!this.method_25405(mouseX, mouseY)) {
                this.mouseType = MouseType.NONE;
                return;
            }
            if (!class_437.method_25443() && !class_437.method_25441()) {
                MapwrightClient.TOOL_MANAGER.get().mouseMove(MapwrightClient.PAGE_MANAGER, this.mouseType, (Vector2dc)oldWorld, (Vector2dc)world);
            }
        }
        this.oldMouseX = mouseX;
        this.oldMouseY = mouseY;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        Vector2d world = this.parent.screenToWorld(new Vector2d(mouseX, mouseY));
        if (this.mouseType != MouseType.NONE) {
            MapwrightClient.TOOL_MANAGER.get().mouseRelease(MapwrightClient.PAGE_MANAGER, this.mouseType, world);
        }
        this.mouseType = MouseType.NONE;
        return true;
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    public static enum MouseType {
        NONE,
        LEFT,
        RIGHT,
        MIDDLE;

    }
}

