/*
 * Decompiled with CFR 0.152.
 */
package wawa.mapwright.map.widgets;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import wawa.mapwright.MapwrightClient;
import wawa.mapwright.data.Pin;
import wawa.mapwright.map.tool.PaletteDrawTool;
import wawa.mapwright.map.tool.PinTool;
import wawa.mapwright.map.tool.Tool;
import wawa.mapwright.map.widgets.ColorPickerWidget;
import wawa.mapwright.map.widgets.PinPickerWidget;

public class SingleToolWidget
extends class_339 {
    private final class_2960 sprite;
    private final class_2960 highlight;
    protected final Function<SingleToolWidget, Tool> toolFunction;
    protected String id = "";

    public SingleToolWidget(int x, int y, class_2960 sprite, class_2960 highlight, Function<SingleToolWidget, Tool> toolFunction, class_2561 message) {
        super(x, y, 16, 16, message);
        this.sprite = sprite;
        this.highlight = highlight;
        this.toolFunction = toolFunction;
        if (sprite != null) {
            this.id = "mapwright.tool." + Arrays.stream(sprite.method_12832().split("/")).toList().get(sprite.method_12832().split("/").length - 1);
        }
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.method_25405(mouseX, mouseY)) {
            guiGraphics.method_52706(this.highlight, this.method_46426() - 1, this.method_46427() - 1, 18, 18);
            this.renderTooltip(guiGraphics, mouseX, mouseY);
        }
        guiGraphics.method_52706(this.sprite, this.method_46426(), this.method_46427(), 16, 16);
    }

    protected void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        guiGraphics.method_51438(class_310.method_1551().field_1772, (class_2561)class_2561.method_43471((String)this.id), mouseX, mouseY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            MapwrightClient.TOOL_MANAGER.set(this.toolFunction.apply(this));
            return true;
        }
        return false;
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    public static class PinWidget
    extends SingleToolWidget {
        public Pin.Type last;
        private final PinPickerWidget pinPicker;

        public PinWidget(int x, int y, Function<SingleToolWidget, Tool> toolFunction, class_2561 message) {
            super(x, y, null, null, toolFunction, message);
            this.last = this.getTool().currentPin;
            this.pinPicker = new PinPickerWidget(this.method_46426() - 5, this.method_46427(), this);
            this.pinPicker.field_22763 = false;
            this.id = "mapwright.tool.pin";
        }

        public PinTool getTool() {
            return (PinTool)this.toolFunction.apply(this);
        }

        @Override
        protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.last.draw(guiGraphics, this.method_46426(), this.method_46427(), this.method_25405(mouseX, mouseY), false, 1.0f);
            if (this.method_25405(mouseX, mouseY)) {
                this.pinPicker.field_22763 = true;
                this.pinPicker.method_48579(guiGraphics, mouseX, mouseY, partialTick);
                this.renderTooltip(guiGraphics, mouseX, mouseY);
            } else {
                this.pinPicker.field_22763 = false;
            }
        }

        @Override
        protected void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
            mouseX = this.pinPicker.method_46426() - class_310.method_1551().field_1772.method_27525((class_5348)class_2561.method_43471((String)this.id)) - 24;
            super.renderTooltip(guiGraphics, mouseX, mouseY);
        }

        public boolean method_25405(double mouseX, double mouseY) {
            return super.method_25405(mouseX, mouseY) || this.pinPicker.method_25405(mouseX, mouseY) && this.pinPicker.method_37303();
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (!this.pinPicker.method_37303()) {
                return false;
            }
            if (!super.method_25402(mouseX, mouseY, button)) {
                return this.pinPicker.method_25402(mouseX, mouseY, button);
            }
            return false;
        }
    }

    public static class BrushWidget
    extends SingleToolWidget {
        public PaletteDrawTool last;
        private static final class_1058 mask = class_310.method_1551().method_52699().method_18667(MapwrightClient.id("tool/brush/brush_mask"));
        private final ColorPickerWidget colorPicker = new ColorPickerWidget(this.method_46426() - 5, this.method_46427(), this);
        private boolean atMouse = false;

        public BrushWidget(int x, int y) {
            super(x, y, MapwrightClient.id("tool/brush/brush"), MapwrightClient.id("tool/brush/brush_highlight"), w -> ((BrushWidget)w).last, (class_2561)class_2561.method_43470((String)"brush"));
            this.colorPicker.field_22763 = false;
        }

        public List<PaletteDrawTool> getBrushes() {
            return this.colorPicker.getBrushes();
        }

        public void openToMouse(double mouseX, double mouseY) {
            this.colorPicker.openToMouse(mouseX, mouseY);
            this.atMouse = true;
        }

        @Override
        protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
            float[] rgb = new Color(this.last.getVisualColor()).getRGBColorComponents(null);
            guiGraphics.method_48465(this.method_46426(), this.method_46427(), 0, 16, 16, mask, rgb[0], rgb[1], rgb[2], 1.0f);
            if (this.method_25405(mouseX, mouseY)) {
                this.colorPicker.field_22763 = true;
                this.colorPicker.method_48579(guiGraphics, mouseX, mouseY, partialTick);
            } else {
                this.colorPicker.field_22763 = false;
                this.colorPicker.resetPos();
                this.atMouse = false;
            }
        }

        @Override
        protected void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
            if (!this.atMouse) {
                mouseX = this.colorPicker.method_46426() - class_310.method_1551().field_1772.method_27525((class_5348)class_2561.method_43471((String)this.id)) - 24;
                super.renderTooltip(guiGraphics, mouseX, mouseY);
            }
        }

        public boolean method_25405(double mouseX, double mouseY) {
            return super.method_25405(mouseX, mouseY) || this.colorPicker.method_25405(mouseX, mouseY) && this.colorPicker.method_37303();
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (!this.colorPicker.method_37303()) {
                return false;
            }
            if (!super.method_25402(mouseX, mouseY, button)) {
                return this.colorPicker.method_25402(mouseX, mouseY, button);
            }
            return false;
        }
    }
}

