/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.hotkettles.blockentity;

import com.matthewperiut.hotkettles.block.KettleBlock;
import com.matthewperiut.hotkettles.item.HotKettleItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class KettleBlockEntity
extends BlockEntity {
    public boolean dirX = false;
    public int liquidHorizontalOffset = 0;
    public int liquidLevel = 0;

    public boolean isFull() {
        return this.liquidLevel == 5;
    }

    public void addLiquid() {
        if (this.liquidLevel == 0) {
            this.setLiquidLevel(this.liquidLevel + 1);
        } else {
            this.setLiquidLevel(this.liquidLevel + 2);
        }
        if (this.liquidLevel > 5) {
            this.setLiquidLevel(5);
        }
    }

    public boolean hot() {
        Block block = this.getLevel().getBlockState(this.worldPosition.below()).getBlock();
        return block == Blocks.LAVA || block == Blocks.LAVA_CAULDRON || block == Blocks.FIRE || block == Blocks.SOUL_FIRE || block == Blocks.TORCH || block == Blocks.SOUL_TORCH || block == Blocks.FURNACE && (Boolean)this.getLevel().getBlockState(this.worldPosition.below()).getValue((Property)BlockStateProperties.LIT) != false || block == Blocks.BLAST_FURNACE && (Boolean)this.getLevel().getBlockState(this.worldPosition.below()).getValue((Property)BlockStateProperties.LIT) != false || block == Blocks.CAMPFIRE && (Boolean)this.getLevel().getBlockState(this.worldPosition.below()).getValue((Property)BlockStateProperties.LIT) != false || block == Blocks.SOUL_CAMPFIRE && (Boolean)this.getLevel().getBlockState(this.worldPosition.below()).getValue((Property)BlockStateProperties.LIT) != false;
    }

    public ItemStack takeLiquid(Player player) {
        if (this.liquidLevel > 0) {
            if (this.liquidLevel - 2 < 0) {
                this.setLiquidLevel(0);
            } else {
                this.setLiquidLevel(this.liquidLevel - 2);
            }
        } else {
            return null;
        }
        int type = this.liquidHorizontalOffset / 2;
        if (this.liquidLevel <= 0) {
            this.setLiquidLevel(0);
            this.setLiquidHorizontalOffset(0);
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)KettleBlock.KETTLE_TYPE, (Comparable)Integer.valueOf(0)));
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                return new ItemStack((ItemLike)HotKettleItems.POISON.get());
            }
            case 2: {
                if (this.hot()) {
                    return new ItemStack((ItemLike)HotKettleItems.HOT_WATER.get());
                }
                player.displayClientMessage(Component.nullToEmpty((String)"You can make this drink hot by putting lava, torch, or lit furnace underneath kettle"), true);
                return new ItemStack((ItemLike)HotKettleItems.CUP_OF_WATER.get());
            }
            case 3: {
                if (this.hot()) {
                    return new ItemStack((ItemLike)HotKettleItems.STEAMED_MILK.get());
                }
                player.displayClientMessage(Component.nullToEmpty((String)"You can make this drink hot by putting lava, torch, or lit furnace underneath kettle"), true);
                return new ItemStack((ItemLike)HotKettleItems.CUP_OF_MILK.get());
            }
            case 4: {
                if (this.hot()) {
                    return new ItemStack((ItemLike)HotKettleItems.HOT_COCOA.get());
                }
                player.displayClientMessage(Component.nullToEmpty((String)"You can make this drink hot by putting lava, torch, or lit furnace underneath kettle"), true);
                return new ItemStack((ItemLike)HotKettleItems.BITTER_WATER.get());
            }
            case 5: {
                if (this.hot()) {
                    return new ItemStack((ItemLike)HotKettleItems.HOT_CIDER.get());
                }
                player.displayClientMessage(Component.nullToEmpty((String)"You can make this drink hot by putting lava, torch, or lit furnace underneath kettle"), true);
                return new ItemStack((ItemLike)HotKettleItems.APPLE_CIDER.get());
            }
            case 6: {
                return new ItemStack((ItemLike)HotKettleItems.CUP_OF_LAVA.get());
            }
        }
        return null;
    }

    public KettleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BuiltInRegistries.BLOCK_ENTITY_TYPE.getValue(ResourceLocation.fromNamespaceAndPath((String)"hotkettles", (String)"kettle")), pos, state);
        Direction dir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (dir == Direction.EAST || dir == Direction.WEST) {
            this.dirX = true;
        }
        this.liquidHorizontalOffset = (Integer)state.getValue((Property)KettleBlock.KETTLE_TYPE) * 2;
    }

    protected void loadAdditional(ValueInput view) {
        super.loadAdditional(view);
        this.liquidLevel = view.getIntOr("LiquidLevel", 0);
        this.liquidHorizontalOffset = view.getIntOr("LiquidHorizontalOffset", 0);
        this.dirX = view.getBooleanOr("DirX", false);
    }

    protected void saveAdditional(ValueOutput view) {
        super.saveAdditional(view);
        view.putInt("LiquidLevel", this.liquidLevel);
        view.putInt("LiquidHorizontalOffset", this.liquidHorizontalOffset);
        view.putBoolean("DirX", this.dirX);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithFullMetadata(registries);
    }

    public void setLiquidLevel(int level) {
        if (this.liquidLevel != level) {
            this.liquidLevel = level;
            this.setChanged();
            if (this.level != null) {
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }

    public void setLiquidHorizontalOffset(int offset) {
        if (this.liquidHorizontalOffset != offset) {
            this.liquidHorizontalOffset = offset;
            this.setChanged();
            if (this.level != null) {
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }
}

