/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.hotkettles.client.render.blockentity;

import com.matthewperiut.hotkettles.blockentity.KettleBlockEntity;
import com.matthewperiut.hotkettles.client.render.blockentity.KettleBlockEntityRenderState;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class KettleBlockEntityRenderer
implements BlockEntityRenderer<KettleBlockEntity, KettleBlockEntityRenderState> {
    private static final ResourceLocation LIQUIDS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hotkettles", (String)"textures/blockentity/liquids.png");
    private static final float Z_FIGHT_OFFSET = 0.001f;

    public KettleBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public KettleBlockEntityRenderState createRenderState() {
        return new KettleBlockEntityRenderState();
    }

    public void updateRenderState(KettleBlockEntity kettleBlockEntity, KettleBlockEntityRenderState renderState, float tickDelta, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)kettleBlockEntity, (BlockEntityRenderState)renderState, tickDelta, cameraPos, crumblingOverlay);
        renderState.liquidHorizontalOffset = kettleBlockEntity.liquidHorizontalOffset;
        renderState.liquidLevel = kettleBlockEntity.liquidLevel;
        renderState.dirX = kettleBlockEntity.dirX;
    }

    public void render(KettleBlockEntityRenderState renderState, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraRenderState) {
        matrices.pushPose();
        matrices.translate(0.0f, 1.0f, 0.0f);
        float uv_x_offset = renderState.liquidHorizontalOffset;
        int uv_y_offset = renderState.liquidLevel;
        float TEXTURE_WIDTH = 2.0f;
        float TEXTURE_HEIGHT = 5.0f;
        MultiBufferSource.BufferSource immediate = MultiBufferSource.immediate((ByteBufferBuilder)ByteBufferBuilder.exactlySized((int)288));
        RenderType renderLayer = RenderType.entityCutout((ResourceLocation)LIQUIDS_TEXTURE);
        VertexConsumer vertexConsumer = immediate.getBuffer(renderLayer);
        this.renderLiquidQuads(matrices, vertexConsumer, renderState, uv_x_offset, uv_y_offset, TEXTURE_WIDTH, TEXTURE_HEIGHT);
        immediate.endBatch();
        matrices.popPose();
    }

    private void renderLiquidQuads(PoseStack matrices, VertexConsumer vertexConsumer, KettleBlockEntityRenderState renderState, float uv_x_offset, int uv_y_offset, float texWidth, float texHeight) {
        PoseStack.Pose entry = matrices.last();
        int light = renderState.lightCoords;
        int overlay = OverlayTexture.NO_OVERLAY;
        if (renderState.dirX) {
            this.drawQuad(vertexConsumer, entry, light, overlay, 0.8135f, -0.8125f, 0.4375f, 0.8135f, -0.5f, 0.4375f, 0.8135f, -0.5f, 0.5625f, 0.8135f, -0.8125f, 0.5625f, uv_x_offset / 64.0f, (texHeight + (float)uv_y_offset) / 32.0f, uv_x_offset / 64.0f, (float)uv_y_offset / 32.0f, (texWidth + uv_x_offset) / 64.0f, (float)uv_y_offset / 32.0f, (texWidth + uv_x_offset) / 64.0f, (texHeight + (float)uv_y_offset) / 32.0f);
            this.drawQuad(vertexConsumer, entry, light, overlay, 0.1865f, -0.8125f, 0.5625f, 0.1865f, -0.5f, 0.5625f, 0.1865f, -0.5f, 0.4375f, 0.1865f, -0.8125f, 0.4375f, uv_x_offset / 64.0f, (texHeight + (float)uv_y_offset) / 32.0f, uv_x_offset / 64.0f, (float)uv_y_offset / 32.0f, (texWidth + uv_x_offset) / 64.0f, (float)uv_y_offset / 32.0f, (texWidth + uv_x_offset) / 64.0f, (texHeight + (float)uv_y_offset) / 32.0f);
        } else {
            this.drawQuad(vertexConsumer, entry, light, overlay, 0.4375f, -0.8125f, 0.1865f, 0.4375f, -0.5f, 0.1865f, 0.5625f, -0.5f, 0.1865f, 0.5625f, -0.8125f, 0.1865f, uv_x_offset / 64.0f, (texHeight + (float)uv_y_offset) / 32.0f, uv_x_offset / 64.0f, (float)uv_y_offset / 32.0f, (texWidth + uv_x_offset) / 64.0f, (float)uv_y_offset / 32.0f, (texWidth + uv_x_offset) / 64.0f, (texHeight + (float)uv_y_offset) / 32.0f);
            this.drawQuad(vertexConsumer, entry, light, overlay, 0.5625f, -0.8125f, 0.8135f, 0.5625f, -0.5f, 0.8135f, 0.4375f, -0.5f, 0.8135f, 0.4375f, -0.8125f, 0.8135f, uv_x_offset / 64.0f, (texHeight + (float)uv_y_offset) / 32.0f, uv_x_offset / 64.0f, (float)uv_y_offset / 32.0f, (texWidth + uv_x_offset) / 64.0f, (float)uv_y_offset / 32.0f, (texWidth + uv_x_offset) / 64.0f, (texHeight + (float)uv_y_offset) / 32.0f);
        }
    }

    private void drawQuad(VertexConsumer vertexConsumer, PoseStack.Pose entry, int light, int overlay, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float u1, float v1, float u2, float v2, float u3, float v3, float u4, float v4) {
        vertexConsumer.addVertex(entry, x1, y1, z1).setColor(255, 255, 255, 255).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(entry, 0.0f, 0.0f, 1.0f);
        vertexConsumer.addVertex(entry, x2, y2, z2).setColor(255, 255, 255, 255).setUv(u2, v2).setOverlay(overlay).setLight(light).setNormal(entry, 0.0f, 0.0f, 1.0f);
        vertexConsumer.addVertex(entry, x3, y3, z3).setColor(255, 255, 255, 255).setUv(u3, v3).setOverlay(overlay).setLight(light).setNormal(entry, 0.0f, 0.0f, 1.0f);
        vertexConsumer.addVertex(entry, x4, y4, z4).setColor(255, 255, 255, 255).setUv(u4, v4).setOverlay(overlay).setLight(light).setNormal(entry, 0.0f, 0.0f, 1.0f);
    }
}

