/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.block.entity;

import de.markusbordihn.easymobfarm.block.ModBlocks;
import de.markusbordihn.easymobfarm.block.entity.CreativeMobFarmBlockEntity;
import de.markusbordihn.easymobfarm.menu.MobFarmMenuWrapper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;

public class CreativeMobFarmBlockEntityWrapper
extends CreativeMobFarmBlockEntity {
    public CreativeMobFarmBlockEntityWrapper(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.CREATIVE_MOB_FARM_ENTITY.get(), blockPos, blockState);
    }

    @Override
    protected AbstractContainerMenu createMenu(int windowId, Inventory inventory) {
        return new MobFarmMenuWrapper(windowId, inventory, (Container)this, this.getContainerData());
    }

    public ResourceHandler<ItemResource> getItemCapability(Direction direction) {
        return new WorldlyContainerItemHandler(this, direction);
    }

    private static class WorldlyContainerItemHandler
    extends ItemStacksResourceHandler {
        private final CreativeMobFarmBlockEntity container;
        private final Direction direction;

        public WorldlyContainerItemHandler(CreativeMobFarmBlockEntity container, Direction direction) {
            super(container.getContainerSize());
            this.container = container;
            this.direction = direction;
        }

        protected ItemStack getStackUnchecked(int index) {
            return this.container.getItem(index);
        }

        protected void setStackUnchecked(int index, ItemStack stack) {
            this.container.setItem(index, stack);
        }

        public boolean isValid(int index, ItemResource resource) {
            int[] slots;
            for (int slot : slots = this.container.getSlotsForFace(this.direction)) {
                if (slot != index || !this.container.canPlaceItemThroughFace(index, resource.toStack(), this.direction)) continue;
                return true;
            }
            return false;
        }

        public int getCapacityAsInt(int index, ItemResource resource) {
            int[] slots;
            for (int slot : slots = this.container.getSlotsForFace(this.direction)) {
                if (slot != index) continue;
                return resource.toStack().getMaxStackSize();
            }
            return 0;
        }
    }
}

