/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.network.message.client;

import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinition;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinitionManager;
import de.markusbordihn.easymobfarm.network.message.NetworkMessageRecord;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record SyncMobCaptureCardDefinitionsMessage(Map<ResourceLocation, MobCaptureCardDefinition> definitions) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)"sync_mob_capture_card_definitions");
    public static final CustomPacketPayload.Type<SyncMobCaptureCardDefinitionsMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncMobCaptureCardDefinitionsMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), SyncMobCaptureCardDefinitionsMessage::create);

    public static SyncMobCaptureCardDefinitionsMessage create(FriendlyByteBuf buffer) {
        int size = buffer.readVarInt();
        HashMap<ResourceLocation, MobCaptureCardDefinition> definitions = new HashMap<ResourceLocation, MobCaptureCardDefinition>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation entityId = buffer.readResourceLocation();
            MobCaptureCardDefinition definition = MobCaptureCardDefinition.decode(buffer);
            definitions.put(entityId, definition);
        }
        return new SyncMobCaptureCardDefinitionsMessage(definitions);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeVarInt(this.definitions.size());
        for (Map.Entry<ResourceLocation, MobCaptureCardDefinition> entry : this.definitions.entrySet()) {
            buffer.writeResourceLocation(entry.getKey());
            entry.getValue().encode(buffer);
        }
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<SyncMobCaptureCardDefinitionsMessage> type() {
        return PAYLOAD_TYPE;
    }

    @Override
    public void handleClient() {
        if (this.definitions == null || this.definitions.isEmpty()) {
            log.warn("No mob capture card definitions to sync!");
            return;
        }
        log.info("Syncing {} mob capture card definitions to client.", (Object)this.definitions.size());
        MobCaptureCardDefinitionManager.setDefinitions(this.definitions);
    }
}

